/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.marketcetera.core.instruments.InstrumentFromMessage;
import org.marketcetera.event.HasFIXMessage;
import org.marketcetera.ors.ORSTestBase;
import org.marketcetera.ors.ORSTestClient;
import org.marketcetera.trade.Equity;
import org.marketcetera.trade.ExecutionReport;
import org.marketcetera.trade.ExecutionType;
import org.marketcetera.trade.Factory;
import org.marketcetera.trade.Instrument;
import org.marketcetera.trade.Option;
import org.marketcetera.trade.OptionType;
import org.marketcetera.trade.OrderCancel;
import org.marketcetera.trade.OrderID;
import org.marketcetera.trade.OrderReplace;
import org.marketcetera.trade.OrderSingle;
import org.marketcetera.trade.OrderType;
import org.marketcetera.trade.Side;
import org.marketcetera.trade.TypesTestBase;
import quickfix.Message;

@RunWith(value=Parameterized.class)
public class OrderSendingTest
extends ORSTestBase {
    private final Instrument mInstrument;

    public OrderSendingTest(Instrument inInstrument) {
        this.mInstrument = inInstrument;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({new Equity("sym")}, {new Option("sym", "20101010", BigDecimal.TEN, OptionType.Put)}, {new Option("sym", "20101010", BigDecimal.TEN, OptionType.Call)}, {new Option("sym", "201010", BigDecimal.TEN, OptionType.Put)});
    }

    @Test(timeout=300000L)
    public void orderSending() throws Exception {
        ORSTestClient c = OrderSendingTest.getAdminClient();
        Instrument instrument = this.getInstrument();
        OrderSingle order = Factory.getInstance().createOrderSingle();
        order.setOrderID(new OrderID("ID1"));
        order.setOrderType(OrderType.Limit);
        order.setQuantity(new BigDecimal("1"));
        order.setSide(Side.Buy);
        order.setInstrument(instrument);
        order.setPrice(BigDecimal.TEN);
        c.getClient().sendOrder(order);
        ExecutionReport er = (ExecutionReport)c.getReportListener().getNext();
        TypesTestBase.assertExecReportValues((ExecutionReport)er, null, (BigDecimal)new BigDecimal("0"), (BigDecimal)new BigDecimal("0"), (ExecutionType)ExecutionType.PendingNew, null, (BigDecimal)new BigDecimal("0"), (BigDecimal)new BigDecimal("0"), (BigDecimal)new BigDecimal("1"), (BigDecimal)new BigDecimal("1"), (OrderType)OrderType.Limit, (Side)Side.Buy, (Instrument)instrument, null, null, null, (boolean)true);
        Message msg = ((HasFIXMessage)er).getMessage();
        Assert.assertFalse((boolean)msg.isSetField(58));
        msg = OrderSendingTest.getNextExchangeMessage();
        Assert.assertEquals((Object)"ID1", (Object)msg.getString(11));
        Assert.assertEquals((Object)"UTF-8", (Object)msg.getHeader().getString(347));
        Assert.assertEquals((Object)"Test Text", (Object)msg.getString(58));
        Assert.assertEquals((Object)instrument, (Object)((InstrumentFromMessage)InstrumentFromMessage.SELECTOR.forValue((Object)msg)).extract(msg));
        OrderReplace replaceOrder = Factory.getInstance().createOrderReplace(er);
        replaceOrder.setOrderID(new OrderID("ID2"));
        replaceOrder.setSide(Side.Sell);
        replaceOrder.setBrokerOrderID(null);
        c.getClient().sendOrder(replaceOrder);
        er = (ExecutionReport)c.getReportListener().getNext();
        TypesTestBase.assertExecReportValues((ExecutionReport)er, null, (BigDecimal)new BigDecimal("0"), (BigDecimal)new BigDecimal("0"), (ExecutionType)ExecutionType.PendingReplace, null, (BigDecimal)new BigDecimal("0"), (BigDecimal)new BigDecimal("0"), (BigDecimal)new BigDecimal("1"), (BigDecimal)new BigDecimal("1"), (OrderType)OrderType.Limit, (Side)Side.Sell, (Instrument)instrument, null, null, null, (boolean)true);
        msg = OrderSendingTest.getNextExchangeMessage();
        Assert.assertEquals((Object)"ID2", (Object)msg.getString(11));
        Assert.assertEquals((Object)"UTF-8", (Object)msg.getHeader().getString(347));
        Assert.assertEquals((Object)"Test Text", (Object)msg.getString(58));
        Assert.assertEquals((Object)instrument, (Object)((InstrumentFromMessage)InstrumentFromMessage.SELECTOR.forValue((Object)msg)).extract(msg));
        OrderCancel cancelOrder = Factory.getInstance().createOrderCancel(er);
        cancelOrder.setOrderID(new OrderID("ID3"));
        cancelOrder.setBrokerOrderID(null);
        c.getClient().sendOrder(cancelOrder);
        er = (ExecutionReport)c.getReportListener().getNext();
        TypesTestBase.assertExecReportValues((ExecutionReport)er, null, (BigDecimal)new BigDecimal("0"), (BigDecimal)new BigDecimal("0"), (ExecutionType)ExecutionType.PendingCancel, null, (BigDecimal)new BigDecimal("0"), (BigDecimal)new BigDecimal("0"), (BigDecimal)new BigDecimal("1"), (BigDecimal)new BigDecimal("1"), (OrderType)OrderType.Limit, (Side)Side.Sell, (Instrument)instrument, null, null, null, (boolean)true);
        msg = OrderSendingTest.getNextExchangeMessage();
        Assert.assertEquals((Object)"ID3", (Object)msg.getString(11));
        Assert.assertEquals((Object)"UTF-8", (Object)msg.getHeader().getString(347));
        Assert.assertEquals((Object)"Test Text", (Object)msg.getString(58));
        Assert.assertEquals((Object)instrument, (Object)((InstrumentFromMessage)InstrumentFromMessage.SELECTOR.forValue((Object)msg)).extract(msg));
    }

    private Instrument getInstrument() {
        return this.mInstrument;
    }
}

