/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors;

import java.math.BigDecimal;
import java.util.HashSet;
import junit.framework.Test;
import org.junit.Ignore;
import org.marketcetera.core.ApplicationBase;
import org.marketcetera.core.ClassVersion;
import org.marketcetera.core.ExpectedTestFailure;
import org.marketcetera.core.FIXVersionTestSuite;
import org.marketcetera.core.FIXVersionedTestCase;
import org.marketcetera.ors.QuickFIXApplication;
import org.marketcetera.quickfix.FIXVersion;
import org.marketcetera.quickfix.IQuickFIXSender;
import org.marketcetera.quickfix.NullQuickFIXSender;
import org.marketcetera.spring.MockJmsTemplate;
import org.marketcetera.trade.Equity;
import org.marketcetera.trade.Instrument;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.jms.JmsException;
import org.springframework.jms.UncategorizedJmsException;
import org.springframework.jms.core.JmsOperations;
import org.springframework.jms.core.JmsTemplate;
import quickfix.IntField;
import quickfix.Message;
import quickfix.SessionID;
import quickfix.StringField;
import quickfix.UnsupportedMessageType;
import quickfix.field.DeliverToCompID;
import quickfix.field.MsgSeqNum;
import quickfix.field.RefMsgType;
import quickfix.field.SenderCompID;
import quickfix.field.TargetCompID;
import quickfix.field.Text;

@Ignore
@ClassVersion(value="$Id: QuickFIXApplicationTest.java 16154 2012-07-14 16:34:05Z colin $")
public class QuickFIXApplicationTest
extends FIXVersionedTestCase {
    public QuickFIXApplicationTest(String inName, FIXVersion version) {
        super(inName, version);
    }

    public static Test suite() {
        new ClassPathXmlApplicationContext(new String[]{"message-modifiers.xml", "order-limits.xml", "ors-shared.xml", "it-ors.xml", "ors_orm_vendor.xml", "ors_orm.xml", "ors_db.xml", "file:" + ApplicationBase.CONF_DIR + "main.xml", "file:" + ApplicationBase.CONF_DIR + "ors_base.xml"});
        return new FIXVersionTestSuite(QuickFIXApplicationTest.class, FIXVersionTestSuite.ALL_VERSIONS);
    }

    public void testMessageSendWhenJMSBarfs() throws Exception {
        JmsTemplate ops = new JmsTemplate(){

            public void convertAndSend(Object message) throws JmsException {
                throw new UncategorizedJmsException("testing exception handling: we always throw an exception");
            }
        };
        MockQuickFIXApplication qfApp = new MockQuickFIXApplication((JmsOperations)ops);
        qfApp.fromAdmin(new Message(), new SessionID("begin", "sender", "target"));
        Message execReport = this.msgFactory.newExecutionReport("123", "456", "789", '2', '1', new BigDecimal(100), new BigDecimal("10.10"), new BigDecimal(100), new BigDecimal("10.10"), new BigDecimal(100), new BigDecimal("10.10"), (Instrument)new Equity("XYZ"), "bob", "text");
        qfApp.fromApp(execReport, new SessionID("begin", "sender", "target"));
    }

    public void testLogoutPropagated() throws Exception {
        MockJmsTemplate jmsTemplate = new MockJmsTemplate();
        MockQuickFIXApplication qfApp = new MockQuickFIXApplication((JmsOperations)jmsTemplate);
        qfApp.onLogout(new SessionID(FIXVersion.FIX42.toString(), "sender", "target"));
        QuickFIXApplicationTest.assertEquals((int)1, (int)jmsTemplate.getSentMessages().size());
        Message received = jmsTemplate.getSentMessages().get(0);
        QuickFIXApplicationTest.assertEquals((String)"5", (String)received.getHeader().getString(35));
        QuickFIXApplicationTest.assertEquals((String)"sender", (String)received.getHeader().getString(49));
        QuickFIXApplicationTest.assertEquals((String)"target", (String)received.getHeader().getString(56));
        QuickFIXApplicationTest.assertNotNull((Object)received.getHeader().getString(52));
    }

    public void testWithDeliverToCompID() throws Exception {
        MockJmsTemplate jmsTemplate = new MockJmsTemplate();
        MockQuickFIXApplication qfApp = new MockQuickFIXApplication((JmsOperations)jmsTemplate);
        Message msg = this.msgFactory.newExecutionReport("200", "300", "400", '4', '1', BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, (Instrument)new Equity("BOB"), "account", "text");
        msg.getHeader().setField((IntField)new MsgSeqNum(1000));
        msg.getHeader().setField((StringField)new SenderCompID("sender"));
        msg.getHeader().setField((StringField)new TargetCompID("target"));
        msg.getHeader().setField((StringField)new DeliverToCompID("bob"));
        SessionID session = new SessionID(FIXVersion.FIX42.toString(), "sender", "target");
        qfApp.fromApp(msg, session);
        QuickFIXApplicationTest.assertEquals((int)1, (int)jmsTemplate.getSentMessages().size());
        QuickFIXApplicationTest.assertEquals((int)1, (int)((NullQuickFIXSender)qfApp.getSender()).getCapturedMessages().size());
        Message reject = (Message)((NullQuickFIXSender)qfApp.getSender()).getCapturedMessages().get(0);
        QuickFIXApplicationTest.assertEquals((String)"3", (String)reject.getHeader().getString(35));
        QuickFIXApplicationTest.assertEquals((int)9, (int)reject.getInt(373));
        QuickFIXApplicationTest.assertEquals((int)1000, (int)reject.getInt(45));
        QuickFIXApplicationTest.assertEquals((String)"8", (String)reject.getString(372));
        QuickFIXApplicationTest.assertTrue((String)reject.getString(58), (boolean)reject.getString(58).contains("bob"));
    }

    public void testUnsupportedMessageType_AllocationAck() throws Exception {
        MockJmsTemplate jmsTemplate = new MockJmsTemplate();
        final MockQuickFIXApplication qfApp = new MockQuickFIXApplication((JmsOperations)jmsTemplate);
        final Message ack = this.msgFactory.createMessage("P");
        new ExpectedTestFailure(UnsupportedMessageType.class){

            protected void execute() throws Throwable {
                qfApp.fromApp(ack, new SessionID(FIXVersion.FIX42.toString(), "sender", "target"));
            }
        }.run();
        QuickFIXApplicationTest.assertEquals((int)0, (int)jmsTemplate.getSentMessages().size());
    }

    public void testMessageModifiersAppliedToOutgoingAdminMessages() throws Exception {
        MockQuickFIXApplication qfApp = new MockQuickFIXApplication(null);
        Message msg = this.msgFactory.createMessage("A");
        qfApp.toAdmin(msg, new SessionID(this.fixVersion.toString(), "sender", "target"));
        QuickFIXApplicationTest.assertEquals((String)"field 37 not present in message", (String)"messageValue", (String)msg.getString(37));
        QuickFIXApplicationTest.assertEquals((String)"field 50 not present in header", (String)"headerValue", (String)msg.getHeader().getString(50));
    }

    public void testExecutionReportGoesToTradeTopic() throws Exception {
        MockJmsTemplate jmsTemplate = new MockJmsTemplate();
        MockJmsTemplate tradeRecorderJMS = new MockJmsTemplate();
        QuickFIXApplication qfApp = new QuickFIXApplication(null, null, null, null, null, null, (JmsOperations)tradeRecorderJMS, null);
        Message msg = this.msgFactory.newExecutionReport("123", "456", "789", '2', '1', new BigDecimal(100), new BigDecimal("10.10"), new BigDecimal(100), new BigDecimal("10.10"), new BigDecimal(100), new BigDecimal("10.10"), (Instrument)new Equity("XYZ"), "bob", "text");
        qfApp.fromApp(msg, new SessionID(this.fixVersion.toString(), "sender", "target"));
        QuickFIXApplicationTest.assertEquals((int)1, (int)jmsTemplate.getSentMessages().size());
        QuickFIXApplicationTest.assertEquals((int)1, (int)tradeRecorderJMS.getSentMessages().size());
        jmsTemplate.getSentMessages().clear();
        tradeRecorderJMS.getSentMessages().clear();
        qfApp.fromApp(msg, new SessionID(this.fixVersion.toString(), "sender", "target"));
        QuickFIXApplicationTest.assertEquals((int)0, (int)jmsTemplate.getSentMessages().size());
        QuickFIXApplicationTest.assertEquals((int)1, (int)tradeRecorderJMS.getSentMessages().size());
    }

    public void testOutgoingRejectCopiedToJMS() throws Exception {
        MockJmsTemplate jmsTemplate = new MockJmsTemplate();
        QuickFIXApplication qfApp = new QuickFIXApplication(null, null, null, null, null, null, null, null);
        SessionID sessionID = new SessionID(this.fixVersion.toString(), "sender", "target");
        Message logon = this.msgFactory.createMessage("A");
        qfApp.toAdmin(logon, sessionID);
        QuickFIXApplicationTest.assertEquals((String)"Logon shouldn't have been copied to JSM", (int)0, (int)jmsTemplate.getSentMessages().size());
        QuickFIXApplicationTest.assertFalse((String)"Shouldn't have had Text tag in outgoing logon", (boolean)logon.isSetField(58));
        jmsTemplate.getSentMessages().clear();
        Message reject = this.msgFactory.createMessage("3");
        reject.setField((StringField)new Text("no refmsgtype"));
        qfApp.toAdmin(reject, sessionID);
        QuickFIXApplicationTest.assertEquals((String)"text field should not be modified", (String)"no refmsgtype", (String)reject.getString(58));
        QuickFIXApplicationTest.assertEquals((String)"Reject should've been copied to JMS", (int)1, (int)jmsTemplate.getSentMessages().size());
        jmsTemplate.getSentMessages().clear();
        reject.setField((StringField)new RefMsgType("8"));
        reject.setField((StringField)new Text("Invalid tag number"));
        qfApp.toAdmin(reject, sessionID);
        QuickFIXApplicationTest.assertEquals((String)"Reject should've been copied to JMS", (int)1, (int)jmsTemplate.getSentMessages().size());
    }

    public static class MockQuickFIXApplication
    extends QuickFIXApplication {
        public static HashSet whiteList;

        public MockQuickFIXApplication(JmsOperations jmsOperations) {
            super(null, null, null, null, null, null, null, null);
        }

        protected void logMessage(Message message, SessionID sessionID) {
        }

        protected IQuickFIXSender createQuickFIXSender() {
            return new NullQuickFIXSender();
        }

        static {
            int i;
            whiteList = new HashSet();
            for (i = 0; i < 10; ++i) {
                whiteList.add("0123456789".substring(i, i + 1));
            }
            for (i = 0; i < 26; ++i) {
                whiteList.add("abcdefghijklmnopqrstuvwxyz".substring(i, i + 1));
            }
            for (i = 0; i < 15; ++i) {
                whiteList.add("abcdefghijklmnopqrstuvwxyz".substring(i, i + 1).toUpperCase());
            }
            for (i = 16; i < 26; ++i) {
                whiteList.add("abcdefghijklmnopqrstuvwxyz".substring(i, i + 1).toUpperCase());
            }
            for (i = 0; i < 26; ++i) {
                whiteList.add("A" + "abcdefghijklmnopqrstuvwxyz".substring(i, i + 1).toUpperCase());
            }
            for (i = 0; i < 8; ++i) {
                whiteList.add("B" + "abcdefghijklmnopqrstuvwxyz".substring(i, i + 1).toUpperCase());
            }
        }
    }
}

