/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors;

import java.util.concurrent.atomic.AtomicLong;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.marketcetera.core.NewFixVersionedTestCase;
import org.marketcetera.ors.OrderInfo;
import org.marketcetera.ors.OrderInfoCache;
import org.marketcetera.ors.Principals;
import org.marketcetera.ors.ReplyPersister;
import org.marketcetera.ors.history.ReportHistoryServices;
import org.marketcetera.quickfix.FIXVersion;
import org.marketcetera.trade.OrderID;
import org.marketcetera.trade.UserID;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.mockito.ArgumentMatcher;
import org.mockito.Matchers;
import org.mockito.Mockito;
import quickfix.Message;
import quickfix.StringField;
import quickfix.field.ClOrdID;
import quickfix.field.OrigClOrdID;

public class ReplyPersisterTest
extends NewFixVersionedTestCase {
    private AtomicLong counter = new AtomicLong(0L);
    private ReplyPersister replyPersister;
    private ReportHistoryServices reportHistoryServices;
    private OrderInfoCache orderInfoCache;

    public ReplyPersisterTest(FIXVersion inVersion) {
        super(inVersion);
    }

    @Before
    public void setup() throws Exception {
        super.setup();
        this.reportHistoryServices = (ReportHistoryServices)Mockito.mock(ReportHistoryServices.class);
        this.orderInfoCache = (OrderInfoCache)Mockito.mock(OrderInfoCache.class);
        this.replyPersister = new ReplyPersister(this.reportHistoryServices, this.orderInfoCache);
    }

    @Test
    public void testGetPrincipals() throws Exception {
        this.doOneGetPrincipalsTest(null, null);
        this.doOneGetPrincipalsTest(null, "order-" + this.counter.incrementAndGet());
        this.doOneGetPrincipalsTest("order-" + this.counter.incrementAndGet(), null);
        this.doOneGetPrincipalsTest("order-" + this.counter.incrementAndGet(), "order-" + this.counter.incrementAndGet());
    }

    private void doOneGetPrincipalsTest(String inOrderID, String inOrigOrderID) throws Exception {
        Message executionReport = this.generateExecutionReport(inOrderID, inOrigOrderID);
        SLF4JLoggerProxy.debug(ReplyPersisterTest.class, (String)"Testing orderID: {} origOrderID: {} using {}", (Object[])new Object[]{inOrderID, inOrigOrderID, executionReport});
        Principals expectedPrincipals = Principals.UNKNOWN;
        Principals actualPrincipals = this.replyPersister.getPrincipals(executionReport, true);
        this.validatePrincipals(Principals.UNKNOWN, actualPrincipals);
        OrderID orderID = inOrderID == null ? null : new OrderID(inOrderID);
        OrderID origOrderID = inOrigOrderID == null ? null : new OrderID(inOrigOrderID);
        OrderID orderIDToCache = null;
        if (inOrderID != null) {
            orderIDToCache = new OrderID(inOrderID);
        } else if (inOrigOrderID != null) {
            orderIDToCache = new OrderID(inOrigOrderID);
        }
        if (orderIDToCache != null) {
            expectedPrincipals = this.generatePrincipals();
            OrderInfo orderInfo = (OrderInfo)Mockito.mock(OrderInfo.class);
            Mockito.when((Object)orderInfo.getActorID()).thenReturn((Object)expectedPrincipals.getActorID());
            Mockito.when((Object)orderInfo.getViewerID()).thenReturn((Object)expectedPrincipals.getViewerID());
            Mockito.when((Object)orderInfo.getOrderID()).thenReturn((Object)orderID);
            Mockito.when((Object)orderInfo.getOrigOrderID()).thenReturn((Object)origOrderID);
            Mockito.when((Object)orderInfo.isViewerIDSet()).thenReturn((Object)true);
            Mockito.when((Object)this.orderInfoCache.get((OrderID)Matchers.argThat((Matcher)new OrderIDMatcher(orderIDToCache)))).thenReturn((Object)orderInfo);
        }
        actualPrincipals = this.replyPersister.getPrincipals(executionReport, true);
        this.validatePrincipals(expectedPrincipals, actualPrincipals);
    }

    private Principals generatePrincipals() {
        return new Principals(new UserID(this.counter.incrementAndGet()), new UserID(this.counter.incrementAndGet()));
    }

    private void validatePrincipals(Principals inExpectedValue, Principals inActualValue) throws Exception {
        if (inExpectedValue == null) {
            Assert.assertNull((Object)inActualValue);
        } else {
            Assert.assertNotNull((Object)inActualValue);
        }
        Assert.assertEquals((Object)inExpectedValue.getActorID(), (Object)inActualValue.getActorID());
        Assert.assertEquals((Object)inExpectedValue.getViewerID(), (Object)inActualValue.getViewerID());
    }

    private Message generateExecutionReport(String inOrderID, String inOrigOrderID) {
        Message message = this.getMsgFactory().createMessage("8");
        if (inOrderID != null) {
            message.setField((StringField)new ClOrdID(inOrderID));
        }
        if (inOrigOrderID != null) {
            message.setField((StringField)new OrigClOrdID(inOrigOrderID));
        }
        return message;
    }

    private static class OrderIDMatcher
    extends ArgumentMatcher<OrderID> {
        private final OrderID orderID;

        private OrderIDMatcher(OrderID inOrderID) {
            this.orderID = inOrderID;
        }

        public boolean matches(Object inArgument) {
            return this.orderID.equals(inArgument);
        }
    }
}

