/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import junit.framework.Test;
import org.junit.Ignore;
import org.marketcetera.core.ClassVersion;
import org.marketcetera.core.CoreException;
import org.marketcetera.core.ExpectedTestFailure;
import org.marketcetera.core.FIXVersionTestSuite;
import org.marketcetera.core.FIXVersionedTestCase;
import org.marketcetera.core.IDFactory;
import org.marketcetera.core.InMemoryIDFactory;
import org.marketcetera.ors.QuickFIXApplication;
import org.marketcetera.ors.QuickFIXApplicationTest;
import org.marketcetera.ors.RequestHandler;
import org.marketcetera.ors.filters.DefaultMessageModifier;
import org.marketcetera.ors.filters.MessageModifier;
import org.marketcetera.ors.filters.MessageRouteManager;
import org.marketcetera.ors.filters.MessageRouteManagerTest;
import org.marketcetera.quickfix.FIXDataDictionary;
import org.marketcetera.quickfix.FIXMessageFactory;
import org.marketcetera.quickfix.FIXMessageUtil;
import org.marketcetera.quickfix.FIXMessageUtilTest;
import org.marketcetera.quickfix.FIXVersion;
import org.marketcetera.quickfix.IQuickFIXSender;
import org.marketcetera.quickfix.NullQuickFIXSender;
import org.marketcetera.quickfix.QuickFIXSender;
import org.marketcetera.spring.MockJmsTemplate;
import org.marketcetera.trade.Equity;
import org.marketcetera.trade.Instrument;
import org.marketcetera.util.log.I18NBoundMessage0P;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.springframework.jms.core.JmsOperations;
import quickfix.CharField;
import quickfix.ConfigError;
import quickfix.FieldConvertError;
import quickfix.FieldNotFound;
import quickfix.IntField;
import quickfix.SessionID;
import quickfix.StringField;
import quickfix.field.ExDestination;
import quickfix.field.MsgSeqNum;
import quickfix.field.OrdType;
import quickfix.field.OrderID;
import quickfix.field.SecurityType;
import quickfix.field.Symbol;
import quickfix.fix41.Message;

@Ignore
@ClassVersion(value="$Id: RequestHandlerTest.java 16154 2012-07-14 16:34:05Z colin $")
public class RequestHandlerTest
extends FIXVersionedTestCase {
    public static final String HEADER_57_VAL = "CERT";
    public static final String HEADER_12_VAL = "12.24";
    public static final String TRAILER_2_VAL = "2-trailer";
    public static final String FIELDS_37_VAL = "37-regField";
    public static final String FIELDS_14_VAL = "37";

    public RequestHandlerTest(String inName, FIXVersion version) {
        super(inName, version);
    }

    public static Test suite() {
        return new FIXVersionTestSuite(RequestHandlerTest.class, FIXVersionTestSuite.ALL_VERSIONS, new HashSet<String>(Arrays.asList("testIncompatibleFIXVersions")), new FIXVersion[]{FIXVersion.FIX40});
    }

    public void testNewExecutionReportFromOrder() throws Exception {
    }

    public void testSendingTimeChanges() throws Exception {
    }

    public void testNewExecutionReportFromOrder_noAccount() throws Exception {
    }

    public void testNotNOSOrder() throws Exception {
        MyRequestHandler handler = new MyRequestHandler();
        quickfix.Message wrongMsg = this.msgFactory.newOrderCancelReject();
        wrongMsg.getHeader().setField((IntField)new MsgSeqNum(23));
        Object reject = null;
    }

    private void verifyExecutionReport(quickfix.Message inExecReport) throws Exception {
        FIXMessageUtilTest.verifyExecutionReport((quickfix.Message)inExecReport, (String)"100", (String)"IBM", (char)'1', (FIXMessageFactory)this.msgFactory, (FIXDataDictionary)this.fixDD);
    }

    public void testInsertDefaultFields() throws Exception {
        NullQuickFIXSender quickFIXSender = new NullQuickFIXSender();
        MyRequestHandler handler = new MyRequestHandler((IQuickFIXSender)quickFIXSender);
        quickfix.Message msg = this.msgFactory.newMarketOrder("bob", '1', new BigDecimal(100), (Instrument)new Equity("IBM"), '0', "bob");
        quickfix.Message response = null;
        RequestHandlerTest.assertNotNull(response);
        RequestHandlerTest.assertEquals((int)1, (int)quickFIXSender.getCapturedMessages().size());
        quickfix.Message modifiedMessage = (quickfix.Message)quickFIXSender.getCapturedMessages().get(0);
        RequestHandlerTest.assertEquals((String)HEADER_57_VAL, (String)modifiedMessage.getHeader().getString(57));
        RequestHandlerTest.assertEquals((String)HEADER_12_VAL, (String)modifiedMessage.getHeader().getString(12));
        RequestHandlerTest.assertEquals((String)TRAILER_2_VAL, (String)modifiedMessage.getTrailer().getString(2));
        RequestHandlerTest.assertEquals((String)FIELDS_37_VAL, (String)modifiedMessage.getString(37));
        RequestHandlerTest.assertEquals((String)FIELDS_14_VAL, (String)modifiedMessage.getString(14));
        if (this.msgFactory.getMsgAugmentor().needsTransactTime(modifiedMessage)) {
            RequestHandlerTest.assertNotNull((Object)modifiedMessage.getString(60));
        }
        modifiedMessage.removeField(14);
        modifiedMessage.removeField(37);
        modifiedMessage.getTrailer().removeField(2);
        this.fixDD.getDictionary().validate(modifiedMessage, true);
        response.setField((StringField)new OrderID("fake-order-id"));
        this.fixDD.getDictionary().validate(response, true);
    }

    public void testImmediateReportAfterRouteMgr() throws Exception {
        NullQuickFIXSender quickFIXSender = new NullQuickFIXSender();
        MyRequestHandler handler = new MyRequestHandler((IQuickFIXSender)quickFIXSender);
        MessageRouteManager routeManager = new MessageRouteManager();
        routeManager.setSeparateSuffix(true);
        quickfix.Message msg = this.msgFactory.newMarketOrder("bob", '1', new BigDecimal(100), (Instrument)new Equity("EUR/USD"), '0', "bob");
        Object response = null;
        RequestHandlerTest.assertNotNull(quickFIXSender.getCapturedMessages().get(0));
        RequestHandlerTest.assertEquals((String)"no symbol suffix in sent msg", (String)"USD", (String)((quickfix.Message)quickFIXSender.getCapturedMessages().get(0)).getString(65));
        RequestHandlerTest.assertNotNull(response);
        RequestHandlerTest.assertEquals((String)"verify symbol has been separated", (String)"EUR", (String)response.getString(55));
        RequestHandlerTest.assertEquals((String)"didn't pick up SymbolSfx", (String)"USD", (String)response.getString(65));
    }

    public void testForexOrder_withSeparateSuffix() throws Exception {
        NullQuickFIXSender quickFIXSender = new NullQuickFIXSender();
        MyRequestHandler handler = new MyRequestHandler((IQuickFIXSender)quickFIXSender);
        MessageRouteManager routeManager = new MessageRouteManager();
        routeManager.setSeparateSuffix(true);
        quickfix.Message msg = this.msgFactory.newMarketOrder("bob", '1', new BigDecimal(100), (Instrument)new Equity("EUR/USD"), '0', "bob");
        msg.setField((StringField)new SecurityType("FOR"));
        msg.setField((CharField)new OrdType('C'));
        Object response = null;
        RequestHandlerTest.assertNotNull(quickFIXSender.getCapturedMessages().get(0));
        RequestHandlerTest.assertFalse((String)"should not have symbol suffix in sent msg", (boolean)((quickfix.Message)quickFIXSender.getCapturedMessages().get(0)).isSetField(65));
        RequestHandlerTest.assertNotNull(response);
        RequestHandlerTest.assertEquals((String)"verify symbol has not been separated", (String)"EUR/USD", (String)response.getString(55));
    }

    public void testHandleEvents() throws Exception {
        NullQuickFIXSender quickFIXSender = new NullQuickFIXSender();
        MyRequestHandler handler = new MyRequestHandler((IQuickFIXSender)quickFIXSender);
        quickfix.Message newOrder = this.msgFactory.newMarketOrder("bob", '1', new BigDecimal(100), (Instrument)new Equity("IBM"), '0', "bob");
        quickfix.Message cancelOrder = this.msgFactory.newCancel("bob", "bob", '2', new BigDecimal(7), (Instrument)new Equity("TOLI"), "redParty");
        List<quickfix.Message> orderList = Arrays.asList(newOrder, cancelOrder);
        LinkedList responses = new LinkedList();
        for (quickfix.Message message : orderList) {
            responses.add(null);
        }
        RequestHandlerTest.assertEquals((String)"not enough events on the QF output", (int)2, (int)quickFIXSender.getCapturedMessages().size());
        RequestHandlerTest.assertEquals((String)"first output should be outgoing execReport", (String)"8", (String)((quickfix.Message)responses.get(0)).getHeader().getString(35));
        RequestHandlerTest.assertEquals((String)"2nd event should be original buy order", (Object)newOrder, quickFIXSender.getCapturedMessages().get(0));
        RequestHandlerTest.assertEquals((String)"3rd event should be cancel order", (Object)cancelOrder, quickFIXSender.getCapturedMessages().get(1));
        ((quickfix.Message)responses.get(0)).setField((StringField)new OrderID("fake-order-id"));
        this.verifyExecutionReport((quickfix.Message)responses.get(0));
    }

    public void testHandleMalformedEvent() throws Exception {
        quickfix.Message buyOrder = FIXMessageUtilTest.createNOS((String)"toli", (BigDecimal)new BigDecimal("12.34"), (BigDecimal)new BigDecimal("234"), (char)'1', (FIXMessageFactory)this.msgFactory);
        buyOrder.removeField(54);
        NullQuickFIXSender quickFIXSender = new NullQuickFIXSender();
        MyRequestHandler handler = new MyRequestHandler((IQuickFIXSender)quickFIXSender);
        final quickfix.Message result = null;
        RequestHandlerTest.assertNotNull(result);
        RequestHandlerTest.assertEquals((int)0, (int)quickFIXSender.getCapturedMessages().size());
        RequestHandlerTest.assertEquals((String)"first output should be outgoing execReport", (String)"8", (String)result.getHeader().getString(35));
        RequestHandlerTest.assertEquals((String)"should be a reject execReport", (char)'8', (char)result.getChar(39));
        RequestHandlerTest.assertTrue((String)"Error message should say field Side was missing", (boolean)result.getString(58).contains("field Side"));
        if (!this.msgFactory.getBeginString().equals(FIXVersion.FIX40.toString())) {
            RequestHandlerTest.assertEquals((String)"execType should be a reject", (char)'8', (char)result.getChar(150));
        }
        new ExpectedTestFailure(RuntimeException.class, "field=54"){

            protected void execute() throws Throwable {
                RequestHandlerTest.this.fixDD.getDictionary().validate(result, true);
            }
        }.run();
    }

    public void testMalformedPrice() throws Exception {
        NullQuickFIXSender quickFIXSender = new NullQuickFIXSender();
        MyRequestHandler handler = new MyRequestHandler((IQuickFIXSender)quickFIXSender);
        quickfix.Message buyOrder = FIXMessageUtilTest.createNOS((String)"toli", (BigDecimal)new BigDecimal("12.34"), (BigDecimal)new BigDecimal("234"), (char)'1', (FIXMessageFactory)this.msgFactory);
        buyOrder.setString(44, "23.23.3");
        RequestHandlerTest.assertNotNull((Object)buyOrder.getString(11));
        Object result = null;
        RequestHandlerTest.assertNotNull(result);
        RequestHandlerTest.assertEquals((String)"first output should be outgoing execReport", (String)"8", (String)result.getHeader().getString(35));
        RequestHandlerTest.assertEquals((String)"should be a reject execReport", (char)'8', (char)result.getChar(39));
        if (!this.msgFactory.getBeginString().equals(FIXVersion.FIX40.toString())) {
            RequestHandlerTest.assertEquals((String)"execType should be a reject", (char)'8', (char)result.getChar(150));
        }
        RequestHandlerTest.assertNotNull((String)"rejectExecReport doesn't have a ClOrdID set", (Object)result.getString(11));
        RequestHandlerTest.assertNotNull((String)"no useful rejection message", (Object)result.getString(58));
    }

    public void testHandleFIXMessages() throws Exception {
        NullQuickFIXSender quickFIXSender = new NullQuickFIXSender();
        MyRequestHandler handler = new MyRequestHandler((IQuickFIXSender)quickFIXSender);
        quickfix.Message newOrder = this.msgFactory.newCancelReplaceShares("bob", "orig", new BigDecimal(100));
        newOrder.setField((StringField)new Symbol("ASDF"));
        quickfix.Message cancelOrder = this.msgFactory.newCancel("bob", "bob", '2', new BigDecimal(7), (Instrument)new Equity("TOLI"), "redParty");
        RequestHandlerTest.assertEquals((String)"not enough events on the OM quickfix sink", (int)2, (int)quickFIXSender.getCapturedMessages().size());
        RequestHandlerTest.assertEquals((String)"1st event should be original buy order", (Object)newOrder, quickFIXSender.getCapturedMessages().get(0));
        RequestHandlerTest.assertEquals((String)"2nd event should be cancel order", (Object)cancelOrder, quickFIXSender.getCapturedMessages().get(1));
        this.fixDD.getDictionary().validate((quickfix.Message)quickFIXSender.getCapturedMessages().get(1), true);
    }

    public void testInvalidSessionID() throws Exception {
        QuickFIXSender quickFIXSender = new QuickFIXSender();
        MyRequestHandler handler = new MyRequestHandler((IQuickFIXSender)quickFIXSender);
        SessionID sessionID = new SessionID(this.msgFactory.getBeginString(), "no-sender", "no-target");
        quickfix.Message newOrder = this.msgFactory.newMarketOrder("123", '1', new BigDecimal(100), (Instrument)new Equity("SUNW"), '0', "dummyaccount");
        Object result = null;
    }

    public void testWithOrderRouteManager() throws Exception {
        final NullQuickFIXSender quickFIXSender = new NullQuickFIXSender();
        MyRequestHandler handler = new MyRequestHandler((IQuickFIXSender)quickFIXSender);
        MessageRouteManager orm = MessageRouteManagerTest.getORMWithOrderRouting("field:100");
        final quickfix.Message newOrder = this.msgFactory.newMarketOrder("bob", '1', new BigDecimal(100), (Instrument)new Equity("IBM"), '0', "bob");
        new ExpectedTestFailure(FieldNotFound.class){

            protected void execute() throws Throwable {
                newOrder.getField((StringField)new ExDestination());
            }
        }.run();
        Object result = null;
        RequestHandlerTest.assertNotNull(result);
        RequestHandlerTest.assertEquals((int)1, (int)quickFIXSender.getCapturedMessages().size());
        new ExpectedTestFailure(FieldNotFound.class){

            protected void execute() throws Throwable {
                newOrder.getHeader().getString(100);
                ((quickfix.Message)quickFIXSender.getCapturedMessages().get(1)).getField((StringField)new ExDestination());
            }
        }.run();
        this.orderRouterTesterHelper(handler, "BRK/A", null, "A");
        this.orderRouterTesterHelper(handler, "IFLI.IM", "Milan", null);
        this.orderRouterTesterHelper(handler, "BRK/A.N", "SIGMA", "A");
    }

    public void testIncomingNullMessage() throws Exception {
        MyRequestHandler handler = new MyRequestHandler();
        RequestHandlerTest.assertNull(null);
    }

    public void testIncompatibleFIXVersions() throws Exception {
        MyRequestHandler handler = new MyRequestHandler();
        Message msg = new Message();
        Object reject = null;
        RequestHandlerTest.assertEquals((String)"didn't get an execution report", (String)"8", (String)reject.getHeader().getString(35));
        RequestHandlerTest.assertEquals((String)"didn't get a reject", (String)"8", (String)reject.getString(39));
        reject = null;
    }

    public void testOrderListNotSupported() throws Exception {
        MyRequestHandler handler = new MyRequestHandler();
        quickfix.Message orderList = this.msgFactory.createMessage("E");
        orderList.setField((StringField)new Symbol("TOLI"));
        orderList.getHeader().setField((IntField)new MsgSeqNum(23));
        Object reject = null;
    }

    public void testMessageRejectedLoggedOutORS() throws Exception {
        NullQuickFIXSender sender = new NullQuickFIXSender();
        MyRequestHandler handler = new MyRequestHandler((IQuickFIXSender)sender);
        Object execReport = null;
        RequestHandlerTest.assertEquals((int)1, (int)sender.getCapturedMessages().size());
        RequestHandlerTest.assertTrue((boolean)FIXMessageUtil.isExecutionReport(execReport));
        RequestHandlerTest.assertEquals((char)'A', (char)execReport.getChar(39));
        sender.getCapturedMessages().clear();
        handler.getQFApp().onLogout(new SessionID(this.msgFactory.getBeginString(), "sender", "target"));
        execReport = null;
        RequestHandlerTest.assertEquals((int)0, (int)sender.getCapturedMessages().size());
        sender.getCapturedMessages().clear();
        handler.getQFApp().onLogon(null);
        execReport = null;
        RequestHandlerTest.assertEquals((int)1, (int)sender.getCapturedMessages().size());
        RequestHandlerTest.assertEquals((String)"8", (String)execReport.getHeader().getString(35));
        RequestHandlerTest.assertEquals((char)'A', (char)execReport.getChar(39));
    }

    public void testOrderCancelRejectWhenORSNotLoggedOn() throws Exception {
        NullQuickFIXSender sender = new NullQuickFIXSender();
        MyRequestHandler handler = new MyRequestHandler((IQuickFIXSender)sender);
        sender.getCapturedMessages().clear();
        handler.getQFApp().onLogout(new SessionID(this.msgFactory.getBeginString(), "sender", "target"));
        Object reject = null;
        RequestHandlerTest.assertEquals((int)0, (int)sender.getCapturedMessages().size());
        RequestHandlerTest.assertEquals((String)"9", (String)reject.getHeader().getString(35));
        RequestHandlerTest.assertEquals((String)"OrdStatus should not set", (char)'8', (char)reject.getChar(39));
    }

    public void testCommandsCopiedToTopic() throws Exception {
        MockJmsTemplate copyJmsTemplate = new MockJmsTemplate();
        MyRequestHandler handler = new MyRequestHandler(null, (JmsOperations)copyJmsTemplate);
        quickfix.Message nos = FIXMessageUtilTest.createNOS((String)"abc", (BigDecimal)new BigDecimal("10"), (BigDecimal)new BigDecimal("100"), (char)'1', (FIXMessageFactory)this.msgFactory);
        RequestHandlerTest.assertEquals((int)1, (int)copyJmsTemplate.getSentMessages().size());
        RequestHandlerTest.assertEquals((Object)nos, (Object)copyJmsTemplate.getSentMessages().get(0));
    }

    private void orderRouterTesterHelper(RequestHandler handler, String symbol, String expectedExchange, String shareClass) throws Exception {
        quickfix.Message qfMsg = this.msgFactory.newMarketOrder("bob", '1', new BigDecimal(100), (Instrument)new Equity(symbol), '0', "bob");
        NullQuickFIXSender nullQuickFIXSender = (NullQuickFIXSender)handler.getSender();
        nullQuickFIXSender.getCapturedMessages().clear();
        Object result = null;
        RequestHandlerTest.assertNotNull(result);
        RequestHandlerTest.assertEquals((int)1, (int)nullQuickFIXSender.getCapturedMessages().size());
        quickfix.Message incomingMsg = (quickfix.Message)nullQuickFIXSender.getCapturedMessages().get(0);
        if (expectedExchange != null) {
            RequestHandlerTest.assertEquals((String)expectedExchange, (String)incomingMsg.getString(100));
        }
        if (shareClass != null) {
            RequestHandlerTest.assertEquals((String)shareClass, (String)incomingMsg.getString(65));
        }
    }

    public static List<MessageModifier> getMessageModifiers() {
        LinkedList<MessageModifier> messageModifiers = new LinkedList<MessageModifier>();
        DefaultMessageModifier defaultOrderModifier = new DefaultMessageModifier();
        defaultOrderModifier.addDefaultField(57, (Object)HEADER_57_VAL, DefaultMessageModifier.MessageFieldType.HEADER);
        messageModifiers.add((MessageModifier)defaultOrderModifier);
        defaultOrderModifier = new DefaultMessageModifier();
        defaultOrderModifier.addDefaultField(12, (Object)HEADER_12_VAL, DefaultMessageModifier.MessageFieldType.HEADER);
        messageModifiers.add((MessageModifier)defaultOrderModifier);
        defaultOrderModifier = new DefaultMessageModifier();
        defaultOrderModifier.addDefaultField(2, (Object)TRAILER_2_VAL, DefaultMessageModifier.MessageFieldType.TRAILER);
        messageModifiers.add((MessageModifier)defaultOrderModifier);
        defaultOrderModifier = new DefaultMessageModifier();
        defaultOrderModifier.addDefaultField(37, (Object)FIELDS_37_VAL, DefaultMessageModifier.MessageFieldType.MESSAGE);
        messageModifiers.add((MessageModifier)defaultOrderModifier);
        defaultOrderModifier = new DefaultMessageModifier();
        defaultOrderModifier.addDefaultField(14, (Object)FIELDS_14_VAL, DefaultMessageModifier.MessageFieldType.MESSAGE);
        messageModifiers.add((MessageModifier)defaultOrderModifier);
        return messageModifiers;
    }

    private void verifyBMRejection(quickfix.Message inMsg, FIXMessageFactory msgFactory, I18NBoundMessage1P msg) throws Exception {
        if (msgFactory.getBeginString().equals(FIXVersion.FIX40.toString()) || msgFactory.getBeginString().equals(FIXVersion.FIX41.toString())) {
            RequestHandlerTest.assertEquals((String)"didn't get a session-level reject", (String)"3", (String)inMsg.getHeader().getString(35));
        } else {
            RequestHandlerTest.assertEquals((String)"didn't get a business-message reject", (String)"j", (String)inMsg.getHeader().getString(35));
        }
        RequestHandlerTest.assertEquals((String)"didn't get a right reason", (String)msg.getText(), (String)inMsg.getString(58));
    }

    public static void verifyRejection(quickfix.Message inMsg, FIXMessageFactory msgFactory, I18NBoundMessage0P msg) throws Exception {
        RequestHandlerTest.assertEquals((String)"didn't get an execution report", (String)"8", (String)inMsg.getHeader().getString(35));
        RequestHandlerTest.assertEquals((String)"didn't get a reject", (String)"8", (String)inMsg.getString(39));
        if (!msgFactory.getBeginString().equals(FIXVersion.FIX40.toString())) {
            RequestHandlerTest.assertEquals((String)"execType should be a reject", (char)'8', (char)inMsg.getChar(150));
        }
        RequestHandlerTest.assertEquals((String)"didn't get a right reason", (String)msg.getText(), (String)inMsg.getString(58));
        RequestHandlerTest.assertTrue((String)"rejects should have sending time in them too", (boolean)inMsg.getHeader().isSetField(52));
    }

    public static void verifyRejection(quickfix.Message inMsg, FIXMessageFactory msgFactory, I18NBoundMessage1P msg) throws Exception {
        RequestHandlerTest.assertEquals((String)"didn't get an execution report", (String)"8", (String)inMsg.getHeader().getString(35));
        RequestHandlerTest.assertEquals((String)"didn't get a reject", (String)"8", (String)inMsg.getString(39));
        if (!msgFactory.getBeginString().equals(FIXVersion.FIX40.toString())) {
            RequestHandlerTest.assertEquals((String)"execType should be a reject", (char)'8', (char)inMsg.getChar(150));
        }
        RequestHandlerTest.assertEquals((String)"didn't get a right reason", (String)msg.getText(), (String)inMsg.getString(58));
        RequestHandlerTest.assertTrue((String)"rejects should have sending time in them too", (boolean)inMsg.getHeader().isSetField(52));
    }

    public static class MyRequestHandler
    extends RequestHandler {
        private static int factoryStart = (int)Math.round(Math.random() * 1000.0);
        private QuickFIXApplication qfApp = new QuickFIXApplicationTest.MockQuickFIXApplication(null);

        public MyRequestHandler(IQuickFIXSender inQuickFIXSender, JmsOperations inIncomingCommandsCopier) throws ClassNotFoundException, ConfigError, FieldConvertError, CoreException {
            super(null, null, null, null, inQuickFIXSender, null, (IDFactory)new InMemoryIDFactory((long)factoryStart));
            this.qfApp.onLogon(null);
        }

        public MyRequestHandler(IQuickFIXSender sender) throws ClassNotFoundException, ConfigError, FieldConvertError, CoreException {
            this(sender, null);
        }

        public MyRequestHandler() throws ClassNotFoundException, ConfigError, FieldConvertError, CoreException {
            this(null);
        }

        public QuickFIXApplication getQFApp() {
            return this.qfApp;
        }
    }
}

