/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.event.HasFIXMessage;
import org.marketcetera.ors.ORSTestBase;
import org.marketcetera.ors.ORSTestClient;
import org.marketcetera.trade.Equity;
import org.marketcetera.trade.ExecutionReport;
import org.marketcetera.trade.FIXResponse;
import org.marketcetera.trade.Factory;
import org.marketcetera.trade.Instrument;
import org.marketcetera.trade.Option;
import org.marketcetera.trade.OptionType;
import org.marketcetera.trade.OrderCancelReject;
import org.marketcetera.trade.Originator;
import org.marketcetera.trade.ReportBase;
import org.marketcetera.trade.TypesTestBase;
import org.marketcetera.util.log.ActiveLocale;
import quickfix.FieldNotFound;
import quickfix.Message;
import quickfix.StringField;
import quickfix.field.SecurityDesc;

public class ResponseDeliveryTest
extends ORSTestBase {
    private static final String TEST_CATEGORY = "org.marketcetera.client.ClientImpl$TradeMessageReceiver";
    private static final int TEST_TIMEOUT = 300000;

    @Test(timeout=300000L)
    public void responseDelivery() throws Exception {
        Date start = new Date();
        Thread.sleep(1500L);
        ORSTestClient c = ResponseDeliveryTest.getAdminClient();
        Message msg = TypesTestBase.createEmptyExecReport();
        ResponseDeliveryTest.completeExecReport(msg);
        Assert.assertFalse((boolean)msg.isSetField(107));
        ResponseDeliveryTest.emulateFirstBrokerResponse(msg);
        ExecutionReport er = Factory.getInstance().createExecutionReport(msg, ResponseDeliveryTest.getFirstBrokerID(), Originator.Broker, null, null);
        ExecutionReport err = (ExecutionReport)c.getReportListener().getNext();
        TypesTestBase.assertExecReportEquals((ExecutionReport)er, (ExecutionReport)err);
        Assert.assertEquals((Object)"SECURITY_DESC", (Object)((HasFIXMessage)err).getMessage().getString(107));
        msg = ResponseDeliveryTest.createEmptyOrderCancelReject();
        ResponseDeliveryTest.completeOrderCancelReject(msg);
        Assert.assertFalse((boolean)msg.isSetField(107));
        ResponseDeliveryTest.emulateFirstBrokerResponse(msg);
        OrderCancelReject ocr = Factory.getInstance().createOrderCancelReject(msg, ResponseDeliveryTest.getFirstBrokerID(), Originator.Broker, null, null);
        OrderCancelReject ocrr = (OrderCancelReject)c.getReportListener().getNext();
        TypesTestBase.assertCancelRejectEquals((OrderCancelReject)ocr, (OrderCancelReject)ocrr);
        Assert.assertEquals((Object)"SECURITY_DESC", (Object)((HasFIXMessage)ocrr).getMessage().getString(107));
        msg = ResponseDeliveryTest.createEmptyBusinessMessageReject();
        Assert.assertFalse((boolean)msg.isSetField(107));
        this.setupTestCaseBase();
        ActiveLocale.setProcessLocale((Locale)Locale.ROOT);
        ResponseDeliveryTest.setDefaultLevel((Level)Level.OFF);
        ResponseDeliveryTest.setLevel((String)TEST_CATEGORY, (Level)Level.WARN);
        this.getAppender().clear();
        ResponseDeliveryTest.emulateFirstBrokerResponse(msg);
        Thread.sleep(5000L);
        FIXResponse response = Factory.getInstance().createFIXResponse(msg, ResponseDeliveryTest.getFirstBrokerID(), Originator.Broker, null, null);
        response.getMessage().setField((StringField)new SecurityDesc("SECURITY_DESC"));
        this.assertSomeEvent(Level.WARN, TEST_CATEGORY, "Received a fix report that was neither an execution report nor an order cancel reject: '" + response.toString() + "'. Client applications do " + "not yet support this message type, so it was not forwarded " + "to the application or its embedded strategies.", TEST_CATEGORY);
        ReportBase[] rs = c.getClient().getReportsSince(start);
        Assert.assertEquals((long)2L, (long)rs.length);
        TypesTestBase.assertExecReportEquals((ExecutionReport)er, (ExecutionReport)((ExecutionReport)rs[0]));
        TypesTestBase.assertCancelRejectEquals((OrderCancelReject)ocr, (OrderCancelReject)((OrderCancelReject)rs[1]));
    }

    @Test(timeout=300000L)
    public void instrumentsResponse() throws Exception {
        Instrument[] instruments;
        for (Instrument instrument : instruments = new Instrument[]{new Equity("sym"), new Option("sym", "20101010", BigDecimal.TEN, OptionType.Call)}) {
            Date start = new Date();
            Thread.sleep(1500L);
            ORSTestClient c = ResponseDeliveryTest.getAdminClient();
            Message msg = this.createERFor(instrument);
            ResponseDeliveryTest.completeExecReport(msg);
            ResponseDeliveryTest.emulateFirstBrokerResponse(msg);
            ExecutionReport expected = Factory.getInstance().createExecutionReport(msg, ResponseDeliveryTest.getFirstBrokerID(), Originator.Broker, null, null);
            ExecutionReport actual = (ExecutionReport)c.getReportListener().getNext();
            TypesTestBase.assertExecReportEquals((ExecutionReport)expected, (ExecutionReport)actual);
            ReportBase[] rs = c.getClient().getReportsSince(start);
            Assert.assertEquals((long)1L, (long)rs.length);
            TypesTestBase.assertExecReportEquals((ExecutionReport)expected, (ExecutionReport)((ExecutionReport)rs[0]));
        }
    }

    private Message createERFor(Instrument inInstrument) throws FieldNotFound {
        return TypesTestBase.getSystemMessageFactory().newExecutionReport("o1", "o2", "o3", '2', '1', BigDecimal.TEN, BigDecimal.TEN, BigDecimal.TEN, BigDecimal.TEN, BigDecimal.TEN, BigDecimal.TEN, inInstrument, "acc", "text");
    }
}

