/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.client.Client;
import org.marketcetera.client.brokers.BrokerStatus;
import org.marketcetera.ors.ORSTestBase;
import org.marketcetera.trade.Equity;
import org.marketcetera.trade.Factory;
import org.marketcetera.trade.Future;
import org.marketcetera.trade.FutureExpirationMonth;
import org.marketcetera.trade.Option;
import org.marketcetera.trade.OptionType;
import org.marketcetera.trade.ReportBase;

public class ServiceTest
extends ORSTestBase {
    private static final Equity TEST_EQUITY = new Equity("IBM");
    private static final Future TEST_FUTURE = new Future("BRN", FutureExpirationMonth.JANUARY, 2010);
    private static final Option TEST_OPTION = new Option("IBM", "20101010", BigDecimal.TEN, OptionType.Call);

    @Test
    public void services() throws Exception {
        Client c = ServiceTest.getAdminClient().getClient();
        List bs = c.getBrokersStatus().getBrokers();
        Assert.assertEquals((long)2L, (long)bs.size());
        BrokerStatus b = (BrokerStatus)bs.get(0);
        Assert.assertEquals((Object)"Broker 1", (Object)b.getName());
        Assert.assertEquals((Object)"broker1", (Object)b.getId().getValue());
        b = (BrokerStatus)bs.get(1);
        Assert.assertEquals((Object)"Broker 2", (Object)b.getName());
        Assert.assertEquals((Object)"broker2", (Object)b.getId().getValue());
        ReportBase[] rs = c.getReportsSince(new Date());
        Assert.assertEquals((long)0L, (long)rs.length);
        Assert.assertEquals((Object)BigDecimal.ZERO, (Object)c.getEquityPositionAsOf(new Date(), TEST_EQUITY));
        Assert.assertTrue((boolean)c.getAllEquityPositionsAsOf(new Date()).isEmpty());
        Assert.assertEquals((Object)BigDecimal.ZERO, (Object)c.getFuturePositionAsOf(new Date(), TEST_FUTURE));
        Assert.assertTrue((boolean)c.getAllFuturePositionsAsOf(new Date()).isEmpty());
        String id = Factory.getInstance().createOrderSingle().getOrderID().getValue();
        Assert.assertNotNull((Object)id);
        Assert.assertFalse((boolean)id.equals(Factory.getInstance().createOrderSingle().getOrderID().getValue()));
        Assert.assertArrayEquals((Object[])new String[]{"JUL", "JUP", "JUQ", "JUS", "JUX"}, (Object[])c.getOptionRoots("JNPR").toArray(new String[2]));
        Assert.assertEquals((Object)"JNPR", (Object)c.getUnderlying("JUX"));
        Assert.assertEquals((Object)BigDecimal.ZERO, (Object)c.getOptionPositionAsOf(new Date(), TEST_OPTION));
        Assert.assertEquals((long)0L, (long)c.getAllOptionPositionsAsOf(new Date()).size());
        Assert.assertEquals((long)0L, (long)c.getOptionPositionsAsOf(new Date(), new String[]{TEST_OPTION.getSymbol()}).size());
        Assert.assertNull((Object)c.getUserData());
        Properties userdata = new Properties();
        c.setUserData(userdata);
        Assert.assertNull((Object)c.getUserData());
        userdata.setProperty("key1", "value1");
        userdata.setProperty("key2", "value2");
        c.setUserData(userdata);
        Assert.assertEquals((Object)userdata, (Object)c.getUserData());
    }
}

