/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors.exchange;

import java.io.File;
import org.apache.log4j.PropertyConfigurator;
import org.marketcetera.core.ApplicationBase;
import org.marketcetera.ors.exchange.SampleExchange;
import org.marketcetera.util.log.SLF4JLoggerProxy;

public class Main
extends ApplicationBase {
    public static void main(String[] args) {
        SampleExchange exchange;
        PropertyConfigurator.configureAndWatch((String)(ApplicationBase.CONF_DIR + "log4j" + File.separator + "server.properties"), (long)20000L);
        SLF4JLoggerProxy.info(Main.class, (String)"Exchange is starting");
        try {
            exchange = new SampleExchange(ApplicationBase.CONF_DIR + args[0]);
            exchange.start();
        }
        catch (Throwable t) {
            try {
                SLF4JLoggerProxy.error(Main.class, (Throwable)t, (String)"Exchange is terminating due to an error", (Object[])new Object[0]);
            }
            catch (Throwable t2) {
                System.err.println("Reporting failed");
                System.err.println("Reporting failure");
                t2.printStackTrace();
                System.err.println("Original failure");
                t.printStackTrace();
            }
            return;
        }
        SLF4JLoggerProxy.info(Main.class, (String)"Exchange started successfully. Ctrl-C to exit");
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                exchange.stop();
                SLF4JLoggerProxy.info(Main.class, (String)"Exchange is terminated");
            }
        });
        try {
            new Main().startWaitingForever();
        }
        catch (Throwable t) {
            try {
                SLF4JLoggerProxy.error(Main.class, (Throwable)t, (String)"Exchange is terminating due to an error", (Object[])new Object[0]);
            }
            catch (Throwable t2) {
                System.err.println("Reporting failed");
                System.err.println("Reporting failure");
                t2.printStackTrace();
                System.err.println("Original failure");
                t.printStackTrace();
            }
            return;
        }
        SLF4JLoggerProxy.info(Main.class, (String)"Exchange is terminating successfully");
    }
}

