/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors.exchange;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.marketcetera.ors.exchange.CreateEvent;
import org.marketcetera.ors.exchange.Event;
import org.marketcetera.ors.exchange.FromAdminEvent;
import org.marketcetera.ors.exchange.FromAppEvent;
import org.marketcetera.ors.exchange.LogonEvent;
import org.marketcetera.ors.exchange.LogoutEvent;
import org.marketcetera.ors.exchange.ToAdminEvent;
import org.marketcetera.ors.exchange.ToAppEvent;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.marketcetera.util.quickfix.SpringSessionSettings;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import quickfix.Acceptor;
import quickfix.Application;
import quickfix.ConfigError;
import quickfix.DefaultMessageFactory;
import quickfix.Message;
import quickfix.MessageFactory;
import quickfix.Session;
import quickfix.SessionID;
import quickfix.SessionNotFound;
import quickfix.SocketAcceptor;

public class SampleExchange
implements Application {
    private final AbstractApplicationContext mContext;
    private final Acceptor mAcceptor;
    private final BlockingQueue<Event> mEvents = new LinkedBlockingQueue<Event>();

    public SampleExchange(String configFile) throws ConfigError {
        this.mContext = new FileSystemXmlApplicationContext(new String[]{"file:" + configFile});
        SpringSessionSettings settings = (SpringSessionSettings)this.mContext.getBean("x_settings");
        this.mAcceptor = new SocketAcceptor((Application)this, settings.getQMessageStoreFactory(), settings.getQSettings(), settings.getQLogFactory(), (MessageFactory)new DefaultMessageFactory());
    }

    public void onCreate(SessionID sessionId) {
        this.add(new CreateEvent(sessionId));
    }

    public void onLogon(SessionID sessionId) {
        this.add(new LogonEvent(sessionId));
    }

    public void onLogout(SessionID sessionId) {
        this.add(new LogoutEvent(sessionId));
    }

    public void toAdmin(Message message, SessionID sessionId) {
        this.add(new ToAdminEvent(sessionId, message));
    }

    public void toApp(Message message, SessionID sessionId) {
        this.add(new ToAppEvent(sessionId, message));
    }

    public void fromAdmin(Message message, SessionID sessionId) {
        this.add(new FromAdminEvent(sessionId, message));
    }

    public void fromApp(Message message, SessionID sessionId) {
        this.add(new FromAppEvent(sessionId, message));
    }

    public void start() throws ConfigError {
        this.mContext.registerShutdownHook();
        this.mContext.start();
        this.mAcceptor.start();
        SLF4JLoggerProxy.debug((Object)this, (String)"Exchange started");
    }

    public synchronized void stop() {
        SLF4JLoggerProxy.debug((Object)this, (String)"Exchange stopping");
        this.mAcceptor.stop();
        this.mContext.close();
        SLF4JLoggerProxy.debug((Object)this, (String)"Exchange stopped");
    }

    public void add(Event event) {
        SLF4JLoggerProxy.debug((Object)this, (String)"Adding event {}", (Object[])new Object[]{event});
        this.mEvents.add(event);
    }

    public Event getNext() throws InterruptedException {
        return this.mEvents.take();
    }

    public void clear() {
        this.mEvents.clear();
    }

    public static void sendMessage(Message message, SessionID sessionID) throws SessionNotFound {
        Session.sendToTarget((Message)message, (SessionID)sessionID);
    }
}

