/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors.filters;

import java.util.HashMap;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import junit.framework.Test;
import junit.framework.TestCase;
import org.marketcetera.core.CoreException;
import org.marketcetera.core.ExpectedTestFailure;
import org.marketcetera.core.MarketceteraTestSuite;
import org.marketcetera.ors.filters.DefaultMessageModifier;
import org.marketcetera.ors.filters.Messages;
import org.marketcetera.quickfix.FIXMessageFactory;
import org.marketcetera.quickfix.FIXVersion;
import quickfix.FieldNotFound;
import quickfix.Message;
import quickfix.StringField;

public class DefaultMessageModifierTest
extends TestCase {
    private static final String HEADER_57_VAL = "asdf";
    private static final String FIELD_21_VAL = "qwer";
    private static final String TRAILER_28_VAL = "ppp";
    private static final String FIELD_42_VAL = "123456789101112";
    private static final String FIELD_63_VAL = "field63val";
    private FIXMessageFactory msgFactory = FIXVersion.FIX44.getMessageFactory();

    public DefaultMessageModifierTest(String inName) {
        super(inName);
    }

    public static Test suite() {
        return new MarketceteraTestSuite(DefaultMessageModifierTest.class);
    }

    public void testModifyOrder() throws Exception {
        String testValue = "A value";
        DefaultMessageModifier modifier = new DefaultMessageModifier();
        modifier.addDefaultField(111, (Object)testValue, DefaultMessageModifier.MessageFieldType.MESSAGE);
        Message aMessage = this.msgFactory.newBasicOrder();
        modifier.modifyMessage(aMessage, null, null);
        StringField outField = new StringField(111);
        DefaultMessageModifierTest.assertEquals((String)testValue, (String)aMessage.getField(outField).getValue());
        final Message outerMessage = aMessage;
        new ExpectedTestFailure(FieldNotFound.class, null){

            protected void execute() throws Throwable {
                outerMessage.getField(new StringField(112));
            }
        }.run();
    }

    public void testIncorrectModiferListingFormat() {
        final DefaultMessageModifier mod = new DefaultMessageModifier();
        new ExpectedTestFailure(CoreException.class, Messages.ORDER_MODIFIER_WRONG_FIELD_FORMAT.getText((Object)"27(app")){

            protected void execute() throws Throwable {
                mod.setMsgFields(DefaultMessageModifierTest.createFieldsMap(new String[][]{{"27(app", "malformed"}}));
            }
        }.run();
    }

    public void testModifyOrderValueExists() throws Exception {
        String replacementValue = "Replacement value";
        DefaultMessageModifier modifier = new DefaultMessageModifier();
        modifier.addDefaultField(111, (Object)replacementValue, DefaultMessageModifier.MessageFieldType.MESSAGE);
        String originalValue = "Original value";
        Message aMessage = this.msgFactory.newBasicOrder();
        aMessage.setField(new StringField(111, originalValue));
        modifier.modifyMessage(aMessage, null, null);
        StringField outField = new StringField(111);
        DefaultMessageModifierTest.assertEquals((String)originalValue, (String)aMessage.getField(outField).getValue());
    }

    public void testModifyOrderWithPredicate() throws BackingStoreException, FieldNotFound, CoreException {
        DefaultMessageModifier mod = new DefaultMessageModifier();
        mod.setHeaderFields(DefaultMessageModifierTest.createFieldsMap(new String[][]{{"57(*)", HEADER_57_VAL}}));
        mod.setMsgFields(DefaultMessageModifierTest.createFieldsMap(new String[][]{{"21(d)", FIELD_21_VAL}, {"42(admin)", FIELD_42_VAL}, {"63(BH)", FIELD_63_VAL}}));
        mod.setTrailerFields(DefaultMessageModifierTest.createFieldsMap(new String[][]{{"28(app)", TRAILER_28_VAL}}));
        Message heartbeat = this.msgFactory.createMessage("0");
        Message newOrderSingle = this.msgFactory.newBasicOrder();
        newOrderSingle.removeField(21);
        Message logon = this.msgFactory.createMessage("A");
        Message confRequest = this.msgFactory.createMessage("BH");
        DefaultMessageModifierTest.assertTrue((boolean)mod.modifyMessage(heartbeat, null, null));
        DefaultMessageModifierTest.assertTrue((boolean)mod.modifyMessage(newOrderSingle, null, null));
        DefaultMessageModifierTest.assertTrue((boolean)mod.modifyMessage(logon, null, null));
        DefaultMessageModifierTest.assertTrue((boolean)mod.modifyMessage(confRequest, null, null));
        DefaultMessageModifierTest.assertEquals((String)HEADER_57_VAL, (String)heartbeat.getHeader().getString(57));
        DefaultMessageModifierTest.assertFalse((boolean)heartbeat.isSetField(21));
        DefaultMessageModifierTest.assertFalse((boolean)heartbeat.getTrailer().isSetField(28));
        DefaultMessageModifierTest.assertEquals((String)FIELD_42_VAL, (String)heartbeat.getString(42));
        DefaultMessageModifierTest.assertFalse((boolean)heartbeat.isSetField(63));
        DefaultMessageModifierTest.assertEquals((String)HEADER_57_VAL, (String)newOrderSingle.getHeader().getString(57));
        DefaultMessageModifierTest.assertEquals((String)FIELD_21_VAL, (String)newOrderSingle.getString(21));
        DefaultMessageModifierTest.assertEquals((String)TRAILER_28_VAL, (String)newOrderSingle.getTrailer().getString(28));
        DefaultMessageModifierTest.assertFalse((boolean)newOrderSingle.isSetField(42));
        DefaultMessageModifierTest.assertFalse((boolean)newOrderSingle.isSetField(63));
        DefaultMessageModifierTest.assertEquals((String)HEADER_57_VAL, (String)logon.getHeader().getString(57));
        DefaultMessageModifierTest.assertFalse((boolean)logon.isSetField(21));
        DefaultMessageModifierTest.assertFalse((boolean)logon.getTrailer().isSetField(28));
        DefaultMessageModifierTest.assertEquals((String)FIELD_42_VAL, (String)logon.getString(42));
        DefaultMessageModifierTest.assertFalse((boolean)logon.isSetField(63));
        DefaultMessageModifierTest.assertEquals((String)HEADER_57_VAL, (String)confRequest.getHeader().getString(57));
        DefaultMessageModifierTest.assertFalse((boolean)confRequest.isSetField(21));
        DefaultMessageModifierTest.assertEquals((String)TRAILER_28_VAL, (String)confRequest.getTrailer().getString(28));
        DefaultMessageModifierTest.assertFalse((boolean)confRequest.isSetField(42));
        DefaultMessageModifierTest.assertEquals((String)FIELD_63_VAL, (String)confRequest.getString(63));
    }

    public void testModifyOrderWithAllMessageTypeModifiers() throws Exception {
        DefaultMessageModifier mod = new DefaultMessageModifier();
        mod.setHeaderFields(DefaultMessageModifierTest.createFieldsMap(new String[][]{{"57", HEADER_57_VAL}}));
        mod.setMsgFields(DefaultMessageModifierTest.createFieldsMap(new String[][]{{"21", FIELD_21_VAL}}));
        mod.setTrailerFields(DefaultMessageModifierTest.createFieldsMap(new String[][]{{"28", TRAILER_28_VAL}}));
        Message msg = this.msgFactory.newBasicOrder();
        msg.removeField(21);
        DefaultMessageModifierTest.assertTrue((boolean)mod.modifyMessage(msg, null, null));
        DefaultMessageModifierTest.assertEquals((String)HEADER_57_VAL, (String)msg.getHeader().getString(57));
        DefaultMessageModifierTest.assertEquals((String)FIELD_21_VAL, (String)msg.getString(21));
        DefaultMessageModifierTest.assertEquals((String)TRAILER_28_VAL, (String)msg.getTrailer().getString(28));
    }

    public static Map<String, String> createFieldsMap(String[][] mappings) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String[] mapping : mappings) {
            result.put(mapping[0], mapping[1]);
        }
        return result;
    }
}

