/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors.filters;

import java.math.BigDecimal;
import junit.framework.Test;
import junit.framework.TestCase;
import org.marketcetera.core.MarketceteraTestSuite;
import org.marketcetera.ors.filters.FieldDuplicatorMessageModifier;
import org.marketcetera.quickfix.FIXMessageFactory;
import org.marketcetera.quickfix.FIXMessageUtilTest;
import org.marketcetera.quickfix.FIXVersion;
import org.marketcetera.quickfix.messagefactory.FIXMessageAugmentor;
import org.marketcetera.quickfix.messagefactory.NoOpFIXMessageAugmentor;
import quickfix.Message;

public class FieldDuplicatorMessageModifierTest
extends TestCase {
    private FIXMessageFactory msgFactory = FIXVersion.FIX42.getMessageFactory();

    public FieldDuplicatorMessageModifierTest(String inName) {
        super(inName);
    }

    public static Test suite() {
        return new MarketceteraTestSuite(FieldDuplicatorMessageModifierTest.class);
    }

    public void testFieldExists() throws Exception {
        Message msg = FIXMessageUtilTest.createNOS((String)"ABC", (BigDecimal)new BigDecimal("23.33"), (BigDecimal)new BigDecimal("100"), (char)'1', (FIXMessageFactory)this.msgFactory);
        FieldDuplicatorMessageModifier mmod = new FieldDuplicatorMessageModifier(55, 7632);
        FieldDuplicatorMessageModifierTest.assertTrue((boolean)mmod.modifyMessage(msg, null, (FIXMessageAugmentor)new NoOpFIXMessageAugmentor()));
        FieldDuplicatorMessageModifierTest.assertEquals((String)"ABC", (String)msg.getString(7632));
    }

    public void testFieldDNE() throws Exception {
        Message msg = FIXMessageUtilTest.createNOS((String)"ABC", (BigDecimal)new BigDecimal("23.33"), (BigDecimal)new BigDecimal("100"), (char)'1', (FIXMessageFactory)this.msgFactory);
        FieldDuplicatorMessageModifier mmod = new FieldDuplicatorMessageModifier(7631, 7632);
        FieldDuplicatorMessageModifierTest.assertFalse((boolean)mmod.modifyMessage(msg, null, (FIXMessageAugmentor)new NoOpFIXMessageAugmentor()));
        FieldDuplicatorMessageModifierTest.assertFalse((boolean)msg.isSetField(7632));
    }

    public void testNotStringField() throws Exception {
        Message msg = FIXMessageUtilTest.createNOS((String)"ABC", (BigDecimal)new BigDecimal("23.33"), (BigDecimal)new BigDecimal("100"), (char)'1', (FIXMessageFactory)this.msgFactory);
        FieldDuplicatorMessageModifier mmod = new FieldDuplicatorMessageModifier(44, 7632);
        FieldDuplicatorMessageModifierTest.assertTrue((boolean)mmod.modifyMessage(msg, null, (FIXMessageAugmentor)new NoOpFIXMessageAugmentor()));
        FieldDuplicatorMessageModifierTest.assertEquals((String)"23.33", (String)msg.getString(7632));
    }
}

