/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors.filters;

import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.marketcetera.core.LoggerConfiguration;
import org.marketcetera.module.ExpectedFailure;
import org.marketcetera.ors.filters.FieldRemoverMessageModifier;
import org.marketcetera.ors.filters.Messages;
import org.marketcetera.quickfix.FIXDataDictionary;
import org.marketcetera.quickfix.FIXDataDictionaryManager;
import org.marketcetera.quickfix.FIXVersion;
import quickfix.Message;

public class FieldRemoverMessageModifierTest {
    private static FIXVersion fixVersion = FIXVersion.FIX_SYSTEM;

    @BeforeClass
    public static void once() throws Exception {
        LoggerConfiguration.logSetup();
        FIXDataDictionary dataDictionary = FIXDataDictionaryManager.getFIXDataDictionary((FIXVersion)fixVersion);
        if (dataDictionary == null) {
            FIXDataDictionaryManager.initialize((FIXVersion)fixVersion, (String)fixVersion.getDataDictionaryURL());
            dataDictionary = FIXDataDictionaryManager.getFIXDataDictionary((FIXVersion)fixVersion);
        }
    }

    @Test
    public void testConstructor() throws Exception {
        FieldRemoverMessageModifier modifier = new FieldRemoverMessageModifier();
        this.verifyModifier(modifier, null, -1);
        modifier = new FieldRemoverMessageModifier(null);
        this.verifyModifier(modifier, null, -1);
        new ExpectedFailure<IllegalArgumentException>(Messages.NON_CONFORMING_FIELD_SPECIFICATION.getText()){

            protected void run() throws Exception {
                new FieldRemoverMessageModifier("this-won't-conform");
            }
        };
        new ExpectedFailure<IllegalArgumentException>(Messages.NON_CONFORMING_FIELD_SPECIFICATION.getText()){

            protected void run() throws Exception {
                new FieldRemoverMessageModifier("   this-won't-conform   ");
            }
        };
        new ExpectedFailure<IllegalArgumentException>(Messages.NON_CONFORMING_FIELD_SPECIFICATION.getText()){

            protected void run() throws Exception {
                new FieldRemoverMessageModifier("123456(A)");
            }
        };
        new ExpectedFailure<IllegalArgumentException>(Messages.NON_CONFORMING_FIELD_SPECIFICATION.getText()){

            protected void run() throws Exception {
                new FieldRemoverMessageModifier("12345(ABCD)");
            }
        };
        modifier = new FieldRemoverMessageModifier("256(A)");
        this.verifyModifier(modifier, "A", 256);
        modifier = new FieldRemoverMessageModifier("25678(ABC)");
        this.verifyModifier(modifier, "ABC", 25678);
        modifier = new FieldRemoverMessageModifier("123(*)");
        this.verifyModifier(modifier, "*", 123);
        modifier = new FieldRemoverMessageModifier("     25678(ABC)     ");
        this.verifyModifier(modifier, "ABC", 25678);
    }

    @Test
    public void testMessageMatching() throws Exception {
        Message message = fixVersion.getMessageFactory().createMessage("D");
        this.doCompleteMessageTest(message, "F");
        message = fixVersion.getMessageFactory().createMessage("F");
        this.doCompleteMessageTest(message, "D");
        message = fixVersion.getMessageFactory().createMessage("G");
        this.doCompleteMessageTest(message, "D");
    }

    private void doCompleteMessageTest(Message inMessage, String inDifferentMsgType) throws Exception {
        Assert.assertFalse((boolean)inMessage.getHeader().getString(35).equals(inDifferentMsgType));
        Assert.assertFalse((boolean)inMessage.isSetField(10000));
        inMessage.setString(10000, "field-value");
        Assert.assertTrue((boolean)inMessage.isSetField(10000));
        this.doOneMessageTest(inMessage, null, false);
        Assert.assertTrue((boolean)inMessage.isSetField(10000));
        this.doOneMessageTest(inMessage, "10001(*)", false);
        Assert.assertTrue((boolean)inMessage.isSetField(10000));
        this.doOneMessageTest(inMessage, "10000(" + inDifferentMsgType + ")", false);
        Assert.assertTrue((boolean)inMessage.isSetField(10000));
        this.doOneMessageTest(inMessage, "10001(" + inDifferentMsgType + ")", false);
        Assert.assertTrue((boolean)inMessage.isSetField(10000));
        this.doOneMessageTest(inMessage, "10000(" + inMessage.getHeader().getString(35) + ")", true);
        Assert.assertFalse((boolean)inMessage.isSetField(10000));
        inMessage.setString(10000, "field-value");
        Assert.assertTrue((boolean)inMessage.isSetField(10000));
        this.doOneMessageTest(inMessage, "10000(*)", true);
        Assert.assertFalse((boolean)inMessage.isSetField(10000));
    }

    private void doOneMessageTest(Message inMessage, String inModifierArgument, boolean inExpectedModified) throws Exception {
        FieldRemoverMessageModifier modifier = new FieldRemoverMessageModifier(inModifierArgument);
        Assert.assertEquals((Object)inExpectedModified, (Object)modifier.modifyMessage(inMessage, null, null));
    }

    private void verifyModifier(FieldRemoverMessageModifier inModifier, String inMsgType, int inField) throws Exception {
        Assert.assertNotNull((Object)inModifier.toString());
        Assert.assertEquals((Object)inMsgType, (Object)inModifier.getMsgType());
        Assert.assertEquals((long)inField, (long)inModifier.getField());
    }
}

