/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors.filters;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import junit.framework.Test;
import junit.framework.TestCase;
import org.marketcetera.core.CoreException;
import org.marketcetera.core.ExpectedTestFailure;
import org.marketcetera.core.LoggerConfiguration;
import org.marketcetera.core.MarketceteraTestSuite;
import org.marketcetera.ors.filters.MessageRouteManager;
import org.marketcetera.quickfix.CurrentFIXDataDictionary;
import org.marketcetera.quickfix.FIXDataDictionary;
import org.marketcetera.quickfix.FIXDataDictionaryManager;
import org.marketcetera.quickfix.FIXFieldConverterNotAvailable;
import org.marketcetera.quickfix.FIXMessageFactory;
import org.marketcetera.quickfix.FIXMessageUtilTest;
import org.marketcetera.quickfix.FIXVersion;
import org.marketcetera.quickfix.messagefactory.FIXMessageAugmentor;
import org.marketcetera.quickfix.messagefactory.NoOpFIXMessageAugmentor;
import org.marketcetera.trade.Equity;
import org.marketcetera.trade.Instrument;
import quickfix.CharField;
import quickfix.DecimalField;
import quickfix.FieldNotFound;
import quickfix.Message;
import quickfix.StringField;
import quickfix.field.ClOrdID;
import quickfix.field.ExDestination;
import quickfix.field.OrdType;
import quickfix.field.OrderQty;
import quickfix.field.SecurityType;
import quickfix.field.Side;
import quickfix.field.Symbol;
import quickfix.field.SymbolSfx;

public class MessageRouteManagerTest
extends TestCase {
    private FIXMessageFactory msgFactory = FIXVersion.FIX42.getMessageFactory();

    public MessageRouteManagerTest(String name) {
        super(name);
    }

    public static Test suite() {
        try {
            LoggerConfiguration.logSetup();
            CurrentFIXDataDictionary.setCurrentFIXDataDictionary((FIXDataDictionary)FIXDataDictionaryManager.initialize((FIXVersion)FIXVersion.FIX42, (String)FIXVersion.FIX42.getDataDictionaryURL()));
        }
        catch (FIXFieldConverterNotAvailable fIXFieldConverterNotAvailable) {
            // empty catch block
        }
        return new MarketceteraTestSuite(MessageRouteManagerTest.class);
    }

    public void testModifyOrderSeparateSuffix() throws BackingStoreException, CoreException, FieldNotFound {
        MessageRouteManager routeManager = MessageRouteManagerTest.getORMWithOrderRouting("field:100");
        Message message = this.msgFactory.newLimitOrder("12345", '1', new BigDecimal(1000), (Instrument)new Equity("BRK/A.N"), new BigDecimal("123.45"), '0', null);
        routeManager.modifyMessage(message, null);
        MessageRouteManagerTest.assertEquals((String)"12345", (String)message.getField((StringField)new ClOrdID()).getValue());
        MessageRouteManagerTest.assertEquals((char)'1', (char)message.getField((CharField)new Side()).getValue());
        MessageRouteManagerTest.assertEquals((Object)new BigDecimal(1000), (Object)message.getField((DecimalField)new OrderQty()).getValue());
        MessageRouteManagerTest.assertEquals((String)"BRK", (String)message.getField((StringField)new Symbol()).getValue());
        MessageRouteManagerTest.assertEquals((String)"A", (String)message.getField((StringField)new SymbolSfx()).getValue());
        MessageRouteManagerTest.assertEquals((String)"SIGMA", (String)message.getField((StringField)new ExDestination()).getValue());
        message = this.msgFactory.newLimitOrder("12346", '2', new BigDecimal(100), (Instrument)new Equity("BRK/B"), new BigDecimal("54.32"), '0', null);
        routeManager.modifyMessage(message, null);
        MessageRouteManagerTest.assertEquals((String)"12346", (String)message.getField((StringField)new ClOrdID()).getValue());
        MessageRouteManagerTest.assertEquals((char)'2', (char)message.getField((CharField)new Side()).getValue());
        MessageRouteManagerTest.assertEquals((Object)new BigDecimal(100), (Object)message.getField((DecimalField)new OrderQty()).getValue());
        MessageRouteManagerTest.assertEquals((String)"BRK", (String)message.getField((StringField)new Symbol()).getValue());
        MessageRouteManagerTest.assertEquals((String)"B", (String)message.getField((StringField)new SymbolSfx()).getValue());
        final Message outerMessage1 = message;
        new ExpectedTestFailure(FieldNotFound.class){

            protected void execute() throws Throwable {
                outerMessage1.getField((StringField)new ExDestination()).getValue();
            }
        }.run();
        message = this.msgFactory.newLimitOrder("12347", '5', new BigDecimal(2000), (Instrument)new Equity("VOD/.LN"), new BigDecimal("111.11"), '2', null);
        routeManager.modifyMessage(message, null);
        MessageRouteManagerTest.assertEquals((String)"12347", (String)message.getField((StringField)new ClOrdID()).getValue());
        MessageRouteManagerTest.assertEquals((char)'5', (char)message.getField((CharField)new Side()).getValue());
        MessageRouteManagerTest.assertEquals((Object)new BigDecimal(2000), (Object)message.getDecimal(38));
        MessageRouteManagerTest.assertEquals((String)"VOD/", (String)message.getField((StringField)new Symbol()).getValue());
        final Message outerMessage2 = message;
        new ExpectedTestFailure(FieldNotFound.class){

            protected void execute() throws Throwable {
                outerMessage2.getField((StringField)new SymbolSfx()).getValue();
            }
        }.run();
        new ExpectedTestFailure(FieldNotFound.class){

            protected void execute() throws Throwable {
                outerMessage2.getField((StringField)new ExDestination()).getValue();
            }
        }.run();
    }

    public void testModifyOrderAttachedSuffix() throws BackingStoreException, CoreException, FieldNotFound {
        MessageRouteManager routeManager = new MessageRouteManager();
        routeManager.setSeparateSuffix(false);
        routeManager.addOneRoute("N", "SIGMA");
        routeManager.setRouteMethod("field:100");
        Message message = this.msgFactory.newLimitOrder("12345", '1', new BigDecimal(1000), (Instrument)new Equity("BRK/A.N"), new BigDecimal("123.45"), '0', null);
        routeManager.modifyMessage(message, null);
        MessageRouteManagerTest.assertEquals((String)"12345", (String)message.getField((StringField)new ClOrdID()).getValue());
        MessageRouteManagerTest.assertEquals((char)'1', (char)message.getField((CharField)new Side()).getValue());
        MessageRouteManagerTest.assertEquals((Object)new BigDecimal(1000), (Object)message.getField((DecimalField)new OrderQty()).getValue());
        MessageRouteManagerTest.assertEquals((String)"BRK/A", (String)message.getField((StringField)new Symbol()).getValue());
        final Message outerMessage = message;
        new ExpectedTestFailure(FieldNotFound.class){

            protected void execute() throws Throwable {
                outerMessage.getField((StringField)new SymbolSfx()).getValue();
            }
        }.run();
        MessageRouteManagerTest.assertEquals((String)"SIGMA", (String)message.getField((StringField)new ExDestination()).getValue());
        message = this.msgFactory.newLimitOrder("12346", '2', new BigDecimal(100), (Instrument)new Equity("BRK/B"), new BigDecimal("54.32"), '0', null);
        routeManager.modifyMessage(message, null);
        MessageRouteManagerTest.assertEquals((String)"12346", (String)message.getField((StringField)new ClOrdID()).getValue());
        MessageRouteManagerTest.assertEquals((char)'2', (char)message.getField((CharField)new Side()).getValue());
        MessageRouteManagerTest.assertEquals((Object)new BigDecimal(100), (Object)message.getField((DecimalField)new OrderQty()).getValue());
        MessageRouteManagerTest.assertEquals((String)"BRK/B", (String)message.getField((StringField)new Symbol()).getValue());
        final Message outerMessage2 = message;
        new ExpectedTestFailure(FieldNotFound.class){

            protected void execute() throws Throwable {
                outerMessage2.getField((StringField)new SymbolSfx()).getValue();
            }
        }.run();
        new ExpectedTestFailure(FieldNotFound.class){

            protected void execute() throws Throwable {
                outerMessage2.getField((StringField)new ExDestination()).getValue();
            }
        }.run();
        message = this.msgFactory.newLimitOrder("12347", '5', new BigDecimal(2000), (Instrument)new Equity("IBM"), new BigDecimal("111.11"), '2', null);
        routeManager.modifyMessage(message, null);
        MessageRouteManagerTest.assertEquals((String)"12347", (String)message.getField((StringField)new ClOrdID()).getValue());
        MessageRouteManagerTest.assertEquals((char)'5', (char)message.getField((CharField)new Side()).getValue());
        MessageRouteManagerTest.assertEquals((Object)new BigDecimal(2000), (Object)message.getField((DecimalField)new OrderQty()).getValue());
        MessageRouteManagerTest.assertEquals((String)"IBM", (String)message.getField((StringField)new Symbol()).getValue());
        final Message outerMessage3 = message;
        new ExpectedTestFailure(FieldNotFound.class){

            protected void execute() throws Throwable {
                outerMessage3.getField((StringField)new SymbolSfx()).getValue();
            }
        }.run();
        new ExpectedTestFailure(FieldNotFound.class){

            protected void execute() throws Throwable {
                outerMessage3.getField((StringField)new ExDestination()).getValue();
            }
        }.run();
        message = this.msgFactory.newLimitOrder("12347", '5', new BigDecimal(2000), (Instrument)new Equity("VOD/"), new BigDecimal("111.11"), '2', null);
        routeManager.modifyMessage(message, null);
        MessageRouteManagerTest.assertEquals((String)"12347", (String)message.getField((StringField)new ClOrdID()).getValue());
        MessageRouteManagerTest.assertEquals((char)'5', (char)message.getField((CharField)new Side()).getValue());
        MessageRouteManagerTest.assertEquals((Object)new BigDecimal(2000), (Object)message.getField((DecimalField)new OrderQty()).getValue());
        MessageRouteManagerTest.assertEquals((String)"VOD/", (String)message.getField((StringField)new Symbol()).getValue());
        final Message outerMessage4 = message;
        new ExpectedTestFailure(FieldNotFound.class){

            protected void execute() throws Throwable {
                outerMessage4.getField((StringField)new SymbolSfx()).getValue();
            }
        }.run();
        new ExpectedTestFailure(FieldNotFound.class){

            protected void execute() throws Throwable {
                outerMessage4.getField((StringField)new ExDestination()).getValue();
            }
        }.run();
    }

    public void testAddOneRoute() throws Exception {
        MessageRouteManager orMgr = new MessageRouteManager();
        orMgr.addOneRoute("A", "B");
        orMgr.addOneRoute("S", "SIGMA");
        MessageRouteManagerTest.assertEquals((String)"A", (String)"B", (String)((String)orMgr.getRoutesMap().get("A")));
        MessageRouteManagerTest.assertEquals((String)"S", (String)"SIGMA", (String)((String)orMgr.getRoutesMap().get("S")));
    }

    public void testRouteParsingPropsBased() throws Exception {
        MessageRouteManager mgr = new MessageRouteManager();
        mgr.addOneRoute("A", "B");
        mgr.addOneRoute("S", "SIGMA");
        mgr.addOneRoute("N", "M");
        mgr.addOneRoute("NnoSpaceM", "");
        Map map = mgr.getRoutesMap();
        MessageRouteManagerTest.assertEquals((int)3, (int)map.size());
        MessageRouteManagerTest.assertEquals((String)"A", (String)"B", (String)((String)map.get("A")));
        MessageRouteManagerTest.assertEquals((String)"S", (String)"SIGMA", (String)((String)map.get("S")));
        MessageRouteManagerTest.assertEquals((String)"N", (String)"M", (String)((String)map.get("N")));
    }

    public void testUnrecognizedRoute() throws Exception {
        new ExpectedTestFailure(IllegalArgumentException.class, "bob"){

            protected void execute() throws Throwable {
                MessageRouteManager routeManager = new MessageRouteManager();
                routeManager.setSeparateSuffix(false);
                routeManager.setRouteMethod("bob");
            }
        }.run();
    }

    public void testOrderRouting() throws Exception {
        NoOpFIXMessageAugmentor augmentor = new NoOpFIXMessageAugmentor();
        MessageRouteManager routeManager = MessageRouteManagerTest.getORMWithOrderRouting("field:100");
        Message buy = FIXMessageUtilTest.createNOS((String)"IBM.N", (BigDecimal)new BigDecimal("10.1"), (BigDecimal)new BigDecimal("100"), (char)'1', (FIXMessageFactory)this.msgFactory);
        routeManager.modifyMessage(buy, (FIXMessageAugmentor)augmentor);
        MessageRouteManagerTest.assertEquals((String)"IBM", (String)buy.getString(55));
        MessageRouteManagerTest.assertEquals((String)"SIGMA", (String)buy.getString(100));
        Message crq = this.msgFactory.newCancelReplaceFromMessage(FIXMessageUtilTest.createNOS((String)"TOLI.N", (BigDecimal)new BigDecimal("10.1"), (BigDecimal)new BigDecimal("100"), (char)'1', (FIXMessageFactory)this.msgFactory));
        routeManager.modifyMessage(crq, (FIXMessageAugmentor)augmentor);
        MessageRouteManagerTest.assertEquals((String)"TOLI", (String)crq.getString(55));
        MessageRouteManagerTest.assertEquals((String)"SIGMA", (String)crq.getString(100));
        Message buyOrder = FIXMessageUtilTest.createNOS((String)"BOB.N", (BigDecimal)new BigDecimal("10.1"), (BigDecimal)new BigDecimal("100"), (char)'1', (FIXMessageFactory)this.msgFactory);
        buyOrder.setField((StringField)new SecurityType("CS"));
        Message cancel = this.msgFactory.newCancelFromMessage(buyOrder);
        routeManager.modifyMessage(cancel, (FIXMessageAugmentor)augmentor);
        MessageRouteManagerTest.assertEquals((String)"CS", (String)cancel.getString(167));
        MessageRouteManagerTest.assertEquals((String)"BOB", (String)cancel.getString(55));
        MessageRouteManagerTest.assertEquals((String)"SIGMA", (String)cancel.getString(100));
    }

    public void testOrderRouting_field57() throws Exception {
        NoOpFIXMessageAugmentor augmentor = new NoOpFIXMessageAugmentor();
        MessageRouteManager routeManager = MessageRouteManagerTest.getORMWithOrderRouting("field:57");
        Message buy = FIXMessageUtilTest.createNOS((String)"IBM.N", (BigDecimal)new BigDecimal("10.1"), (BigDecimal)new BigDecimal("100"), (char)'1', (FIXMessageFactory)this.msgFactory);
        routeManager.modifyMessage(buy, (FIXMessageAugmentor)augmentor);
        MessageRouteManagerTest.assertEquals((String)"IBM", (String)buy.getString(55));
        MessageRouteManagerTest.assertEquals((String)"SIGMA", (String)buy.getHeader().getString(57));
    }

    public void testOrderRouting_field128() throws Exception {
        NoOpFIXMessageAugmentor augmentor = new NoOpFIXMessageAugmentor();
        MessageRouteManager routeManager = MessageRouteManagerTest.getORMWithOrderRouting("field:128");
        Message buy = FIXMessageUtilTest.createNOS((String)"IBM.N", (BigDecimal)new BigDecimal("10.1"), (BigDecimal)new BigDecimal("100"), (char)'1', (FIXMessageFactory)this.msgFactory);
        routeManager.modifyMessage(buy, (FIXMessageAugmentor)augmentor);
        MessageRouteManagerTest.assertEquals((String)"IBM", (String)buy.getString(55));
        MessageRouteManagerTest.assertEquals((String)"SIGMA", (String)buy.getHeader().getString(128));
    }

    public void testModifyMessageNoSecurityType() throws Exception {
        MessageRouteManager routeManager = new MessageRouteManager();
        routeManager.setSeparateSuffix(true);
        Message msg = FIXVersion.FIX42.getMessageFactory().newMarketOrder("bob", '1', new BigDecimal(100), (Instrument)new Equity("ABCD"), '0', "bob");
        msg.removeField(167);
        MessageRouteManagerTest.assertFalse((String)"should not have modified message", (boolean)routeManager.modifyMessage(msg, (FIXMessageAugmentor)new NoOpFIXMessageAugmentor()));
    }

    public void testModifyMessageWithSecurityType() throws Exception {
        MessageRouteManager routeManager = new MessageRouteManager();
        routeManager.setSeparateSuffix(true);
        Message msg = FIXVersion.FIX42.getMessageFactory().newMarketOrder("bob", '1', new BigDecimal(100), (Instrument)new Equity("ABCD"), '0', "bob");
        msg.setField((StringField)new SecurityType("CS"));
        MessageRouteManagerTest.assertFalse((String)"should not have modified message", (boolean)routeManager.modifyMessage(msg, (FIXMessageAugmentor)new NoOpFIXMessageAugmentor()));
    }

    public void testModifyMessageForex() throws Exception {
        MessageRouteManager routeManager = new MessageRouteManager();
        routeManager.setSeparateSuffix(true);
        Message msg = FIXVersion.FIX42.getMessageFactory().newMarketOrder("bob", '1', new BigDecimal(100), (Instrument)new Equity("EUR/USD"), '0', "bob");
        msg.setField((StringField)new SecurityType("FOR"));
        msg.setField((CharField)new OrdType('C'));
        MessageRouteManagerTest.assertFalse((String)"should not have modified message", (boolean)routeManager.modifyMessage(msg, (FIXMessageAugmentor)new NoOpFIXMessageAugmentor()));
    }

    public void testModifyMessageStock() throws Exception {
        MessageRouteManager routeManager = new MessageRouteManager();
        routeManager.setSeparateSuffix(true);
        Message msg = FIXVersion.FIX42.getMessageFactory().newMarketOrder("bob", '1', new BigDecimal(100), (Instrument)new Equity("BRK/B"), '0', "bob");
        MessageRouteManagerTest.assertTrue((boolean)routeManager.modifyMessage(msg, (FIXMessageAugmentor)new NoOpFIXMessageAugmentor()));
        MessageRouteManagerTest.assertEquals((String)"BRK", (String)msg.getString(55));
        MessageRouteManagerTest.assertEquals((String)"B", (String)msg.getString(65));
        msg = FIXVersion.FIX42.getMessageFactory().newMarketOrder("bob", '1', new BigDecimal(100), (Instrument)new Equity("BRK/B"), '0', "bob");
        msg.setField((StringField)new SecurityType("CS"));
        MessageRouteManagerTest.assertTrue((boolean)routeManager.modifyMessage(msg, (FIXMessageAugmentor)new NoOpFIXMessageAugmentor()));
        MessageRouteManagerTest.assertEquals((String)"BRK", (String)msg.getString(55));
        MessageRouteManagerTest.assertEquals((String)"B", (String)msg.getString(65));
    }

    public static MessageRouteManager getORMWithOrderRouting(String routeMethod) {
        MessageRouteManager orm = new MessageRouteManager();
        orm.setRouteMethod(routeMethod);
        orm.setSeparateSuffix(true);
        HashMap<String, String> routesMap = new HashMap<String, String>();
        routesMap.put("N", "SIGMA");
        routesMap.put("IM", "Milan");
        routesMap.put("A", "B");
        orm.setRoutes(routesMap);
        return orm;
    }
}

