/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors.history;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.core.position.PositionKey;
import org.marketcetera.ors.history.ReportsTestBase;
import org.marketcetera.trade.Equity;
import org.marketcetera.trade.Instrument;
import org.marketcetera.trade.Option;
import org.marketcetera.trade.OptionType;
import org.marketcetera.trade.Side;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: DistinctInstrumentPositionsTest.java 16154 2012-07-14 16:34:05Z colin $")
public class DistinctInstrumentPositionsTest
extends ReportsTestBase {
    @Test
    public void distinctEquityOptionPositions() throws Exception {
        Equity equity = new Equity("A");
        Option option = new Option(equity.getSymbol(), "20001010", BigDecimal.ONE, OptionType.Call);
        String opx = "ord-";
        int orderid = 0;
        DistinctInstrumentPositionsTest.createAndSaveER(opx + ++orderid, null, (Instrument)equity, Side.Buy, BigDecimal.TEN);
        DistinctInstrumentPositionsTest.sleepForSignificantTime();
        Assert.assertEquals((Object)BigDecimal.TEN.setScale(5), (Object)DistinctInstrumentPositionsTest.getPosition(new Date(), equity));
        DistinctInstrumentPositionsTest.createAndSaveER(opx + ++orderid, null, (Instrument)equity, Side.Sell, BigDecimal.ONE);
        DistinctInstrumentPositionsTest.sleepForSignificantTime();
        BigDecimal finalEqPosition = BigDecimal.TEN.subtract(BigDecimal.ONE).setScale(5);
        Assert.assertEquals((Object)finalEqPosition, (Object)DistinctInstrumentPositionsTest.getPosition(new Date(), equity));
        DistinctInstrumentPositionsTest.createAndSaveER(opx + ++orderid, null, (Instrument)option, Side.Buy, BigDecimal.ONE);
        DistinctInstrumentPositionsTest.sleepForSignificantTime();
        Assert.assertEquals((Object)BigDecimal.ONE.setScale(5), (Object)DistinctInstrumentPositionsTest.getPosition(new Date(), option));
        DistinctInstrumentPositionsTest.createAndSaveER(opx + ++orderid, null, (Instrument)option, Side.Sell, BigDecimal.TEN);
        DistinctInstrumentPositionsTest.sleepForSignificantTime();
        Date date = new Date();
        BigDecimal finalOpPosition = BigDecimal.ONE.subtract(BigDecimal.TEN).setScale(5);
        Assert.assertEquals((Object)finalOpPosition, (Object)DistinctInstrumentPositionsTest.getPosition(date, option));
        Assert.assertEquals((Object)finalEqPosition, (Object)DistinctInstrumentPositionsTest.getPosition(date, equity));
        Map<PositionKey<Equity>, BigDecimal> eqPositions = DistinctInstrumentPositionsTest.getPositions(date);
        Assert.assertEquals((long)1L, (long)eqPositions.size());
        Assert.assertThat(eqPositions, (Matcher)Matchers.hasEntry(DistinctInstrumentPositionsTest.pos(equity), (Object)finalEqPosition));
        Map<PositionKey<Option>, BigDecimal> opPositions = DistinctInstrumentPositionsTest.getOptionPositions(date, option.getSymbol());
        Assert.assertEquals((long)1L, (long)opPositions.size());
        Assert.assertThat(opPositions, (Matcher)Matchers.hasEntry(DistinctInstrumentPositionsTest.pos(option), (Object)finalOpPosition));
        opPositions = DistinctInstrumentPositionsTest.getAllOptionPositions(date);
        Assert.assertEquals((long)1L, (long)opPositions.size());
        Assert.assertThat(opPositions, (Matcher)Matchers.hasEntry(DistinctInstrumentPositionsTest.pos(option), (Object)finalOpPosition));
    }
}

