/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors.history;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.core.position.PositionKey;
import org.marketcetera.module.ExpectedFailure;
import org.marketcetera.ors.history.ReportHistoryTestBase;
import org.marketcetera.ors.history.ReportsTestBase;
import org.marketcetera.ors.security.SimpleUser;
import org.marketcetera.trade.Equity;
import org.marketcetera.trade.ExecutionReport;
import org.marketcetera.trade.FIXMessageSupport;
import org.marketcetera.trade.Instrument;
import org.marketcetera.trade.OrderStatus;
import org.marketcetera.trade.ReportBase;
import org.marketcetera.trade.Side;
import org.marketcetera.util.misc.ClassVersion;
import quickfix.StringField;
import quickfix.field.SecurityType;

@ClassVersion(value="$Id: EquityReportsHistoryTest.java 16154 2012-07-14 16:34:05Z colin $")
public class EquityReportsHistoryTest
extends ReportHistoryTestBase<Equity> {
    @Test
    public void unhandledInstrument() throws Exception {
        final ExecutionReport report = EquityReportsHistoryTest.createExecReport("ord1", null, (Instrument)new Equity("green"), Side.Buy, OrderStatus.Filled, BigDecimal.TEN, BigDecimal.TEN, BigDecimal.TEN, BigDecimal.TEN);
        ((FIXMessageSupport)report).getMessage().setField((StringField)new SecurityType("BN"));
        Date before = new Date();
        EquityReportsHistoryTest.sleepForSignificantTime();
        new ExpectedFailure<IllegalArgumentException>(){

            protected void run() throws Exception {
                ReportsTestBase.sServices.save((ReportBase)report);
            }
        };
        Assert.assertEquals((long)0L, (long)sServices.getReportsSince(sViewer, before).length);
    }

    @Override
    protected Equity getInstrument() {
        return new Equity("ubm");
    }

    @Override
    protected BigDecimal getInstrumentPosition(Date inDate, Equity inInstrument) throws Exception {
        return EquityReportsHistoryTest.getPosition(inDate, inInstrument);
    }

    @Override
    protected BigDecimal getInstrumentPosition(Date inDate, Equity inInstrument, SimpleUser inUser) throws Exception {
        return EquityReportsHistoryTest.getPosition(inDate, inInstrument, inUser);
    }

    @Override
    protected Map<PositionKey<Equity>, BigDecimal> getInstrumentPositions(Date inDate) throws Exception {
        return EquityReportsHistoryTest.getPositions(inDate);
    }

    @Override
    protected Map<PositionKey<Equity>, BigDecimal> getInstrumentPositions(Date inDate, SimpleUser inUser) throws Exception {
        return EquityReportsHistoryTest.getPositions(inDate, inUser);
    }
}

