/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors.history;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import javax.persistence.TemporalType;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.event.HasFIXMessage;
import org.marketcetera.ors.history.ExecutionReportSummary;
import org.marketcetera.ors.history.MultiExecReportSummary;
import org.marketcetera.ors.history.MultiPersistentReportQuery;
import org.marketcetera.ors.history.PersistentReport;
import org.marketcetera.ors.history.ReportsTestBase;
import org.marketcetera.persist.PersistTestBase;
import org.marketcetera.trade.ExecutionReport;
import org.marketcetera.trade.Instrument;
import org.marketcetera.trade.OrderCancelReject;
import org.marketcetera.trade.OrderID;
import org.marketcetera.trade.OrderStatus;
import org.marketcetera.trade.ReportBase;
import org.marketcetera.trade.Side;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: ExecReportSummaryTestBase.java 16154 2012-07-14 16:34:05Z colin $")
public abstract class ExecReportSummaryTestBase<I extends Instrument>
extends ReportsTestBase {
    @Test
    public void emptyViewer() throws Exception {
        sServices.save((ReportBase)ExecReportSummaryTestBase.createExecReport("o1", null, this.getInstrument(), Side.Buy, OrderStatus.PartiallyFilled, BigDecimal.TEN, BigDecimal.TEN, BigDecimal.ONE, BigDecimal.ONE, BROKER, null, null));
        sServices.save((ReportBase)ExecReportSummaryTestBase.createExecReport("o1", null, this.getInstrument(), Side.Buy, OrderStatus.PartiallyFilled, BigDecimal.TEN, BigDecimal.TEN, BigDecimal.ONE, BigDecimal.ONE));
        MultiExecReportSummary query = MultiExecReportSummary.all();
        query.setEntityOrder(MultiExecReportSummary.BY_ID);
        List summary = query.fetch();
        Assert.assertEquals((long)2L, (long)summary.size());
        Assert.assertNull((Object)((ExecutionReportSummary)summary.get(0)).getViewer());
        Assert.assertNull((Object)((ExecutionReportSummary)summary.get(0)).getViewerID());
        Assert.assertEquals((Object)sViewer.getName(), (Object)((ExecutionReportSummary)summary.get(1)).getViewer().getName());
        Assert.assertEquals((Object)sViewerID, (Object)((ExecutionReportSummary)summary.get(1)).getViewerID());
    }

    @Test
    public void rejectNotSaved() throws Exception {
        OrderCancelReject reject = ExecReportSummaryTestBase.createCancelReject();
        sServices.save((ReportBase)reject);
        Assert.assertEquals((long)1L, (long)MultiPersistentReportQuery.all().fetchCount());
        MultiExecReportSummary query = MultiExecReportSummary.all();
        Assert.assertEquals((long)0L, (long)query.fetchCount());
        Assert.assertEquals((long)0L, (long)query.fetch().size());
    }

    @Test
    public void execReportSave() throws Exception {
        String orderID1 = "ord1";
        I instrument = this.getInstrument();
        ExecutionReport report1 = ExecReportSummaryTestBase.createExecReport(orderID1, null, instrument, Side.Buy, OrderStatus.PartiallyFilled, BigDecimal.TEN, BigDecimal.TEN, BigDecimal.ONE, BigDecimal.ONE);
        sServices.save((ReportBase)report1);
        MultiPersistentReportQuery reportQuery = MultiPersistentReportQuery.all();
        Assert.assertEquals((long)1L, (long)reportQuery.fetchCount());
        MultiExecReportSummary query = MultiExecReportSummary.all();
        query.setEntityOrder(MultiExecReportSummary.BY_ID);
        Assert.assertEquals((long)1L, (long)query.fetchCount());
        List summary = query.fetch();
        Assert.assertEquals((long)1L, (long)summary.size());
        this.assertSummary((ExecutionReportSummary)summary.get(0), report1.getAveragePrice(), report1.getCumulativeQuantity(), report1.getLastPrice(), report1.getLastQuantity(), report1.getOrderID(), report1.getOrderStatus(), null, (PersistentReport)reportQuery.fetch().get(0), report1.getOrderID(), report1.getSendingTime(), report1.getSide(), instrument);
        String orderID2 = "ord2";
        ExecutionReport report2 = ExecReportSummaryTestBase.createExecReport(orderID2, orderID1, instrument, Side.Buy, OrderStatus.PartiallyFilled, BigDecimal.TEN, BigDecimal.TEN, BigDecimal.ONE, BigDecimal.ONE);
        sServices.save((ReportBase)report2);
        Assert.assertEquals((long)2L, (long)reportQuery.fetchCount());
        Assert.assertEquals((long)2L, (long)query.fetchCount());
        summary = query.fetch();
        Assert.assertEquals((long)2L, (long)summary.size());
        this.assertSummary((ExecutionReportSummary)summary.get(1), report2.getAveragePrice(), report2.getCumulativeQuantity(), report2.getLastPrice(), report2.getLastQuantity(), report2.getOrderID(), report2.getOrderStatus(), report2.getOriginalOrderID(), (PersistentReport)reportQuery.fetch().get(1), report1.getOrderID(), report2.getSendingTime(), report2.getSide(), instrument);
        String orderID3 = "ord3";
        ExecutionReport report3 = ExecReportSummaryTestBase.createExecReport(orderID3, orderID2, instrument, Side.Buy, OrderStatus.PartiallyFilled, BigDecimal.TEN, BigDecimal.TEN, BigDecimal.ONE, BigDecimal.ONE);
        sServices.save((ReportBase)report3);
        Assert.assertEquals((long)3L, (long)reportQuery.fetchCount());
        Assert.assertEquals((long)3L, (long)query.fetchCount());
        summary = query.fetch();
        Assert.assertEquals((long)3L, (long)summary.size());
        this.assertSummary((ExecutionReportSummary)summary.get(2), report3.getAveragePrice(), report3.getCumulativeQuantity(), report3.getLastPrice(), report3.getLastQuantity(), report3.getOrderID(), report3.getOrderStatus(), report3.getOriginalOrderID(), (PersistentReport)reportQuery.fetch().get(2), report1.getOrderID(), report3.getSendingTime(), report3.getSide(), instrument);
    }

    @Test
    public void execReportOrigOrderNotPresent() throws Exception {
        I instrument = this.getInstrument();
        ExecutionReport report = ExecReportSummaryTestBase.createExecReport("ord1", "ord2", instrument, Side.Buy, OrderStatus.Replaced, BigDecimal.TEN, BigDecimal.TEN, BigDecimal.ONE, BigDecimal.ONE);
        sServices.save((ReportBase)report);
        MultiPersistentReportQuery reportQuery = MultiPersistentReportQuery.all();
        Assert.assertEquals((long)1L, (long)reportQuery.fetchCount());
        MultiExecReportSummary query = MultiExecReportSummary.all();
        Assert.assertEquals((long)1L, (long)query.fetchCount());
        List summary = query.fetch();
        Assert.assertEquals((long)1L, (long)summary.size());
        this.assertSummary((ExecutionReportSummary)summary.get(0), report.getAveragePrice(), report.getCumulativeQuantity(), report.getLastPrice(), report.getLastQuantity(), report.getOrderID(), report.getOrderStatus(), report.getOriginalOrderID(), (PersistentReport)reportQuery.fetch().get(0), report.getOrderID(), report.getSendingTime(), report.getSide(), instrument);
    }

    @Test
    public void nullAvgPriceFail() throws Exception {
        final ExecutionReport report = ExecReportSummaryTestBase.removeField(this.createDummyExecReport(), 6);
        Assert.assertNull((Object)report.getAveragePrice());
        ExecReportSummaryTestBase.nonNullCVCheck("avgPrice", new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ReportsTestBase.sServices.save((ReportBase)report);
                return null;
            }
        });
    }

    @Test
    public void nullCumQtyFail() throws Exception {
        final ExecutionReport report = ExecReportSummaryTestBase.removeField(this.createDummyExecReport(), 14);
        Assert.assertNull((Object)report.getCumulativeQuantity());
        ExecReportSummaryTestBase.nonNullCVCheck("cumQuantity", new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ReportsTestBase.sServices.save((ReportBase)report);
                return null;
            }
        });
    }

    @Test
    public void nullOrderIDFail() throws Exception {
        final ExecutionReport report = ExecReportSummaryTestBase.removeField(this.createDummyExecReport(), 11);
        Assert.assertNull((Object)report.getOrderID());
        ExecReportSummaryTestBase.nonNullCVCheck("orderID", new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ReportsTestBase.sServices.save((ReportBase)report);
                return null;
            }
        });
    }

    @Test
    public void nullOrderStatusFail() throws Exception {
        final ExecutionReport report = ExecReportSummaryTestBase.removeField(this.createDummyExecReport(), 39);
        Assert.assertNull((Object)report.getOrderStatus());
        ExecReportSummaryTestBase.nonNullCVCheck("orderStatus", new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ReportsTestBase.sServices.save((ReportBase)report);
                return null;
            }
        });
    }

    @Test
    public void nullSendingTimeFail() throws Exception {
        final ExecutionReport report = (ExecutionReport)ExecReportSummaryTestBase.removeSendingTime((ReportBase)this.createDummyExecReport());
        ExecReportSummaryTestBase.nonNullCVCheck("sendingTime", new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ReportsTestBase.sServices.save((ReportBase)report);
                return null;
            }
        });
    }

    @Test
    public void nullSideFail() throws Exception {
        final ExecutionReport report = ExecReportSummaryTestBase.removeField(this.createDummyExecReport(), 54);
        Assert.assertNull((Object)report.getSide());
        ExecReportSummaryTestBase.nonNullCVCheck("side", new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ReportsTestBase.sServices.save((ReportBase)report);
                return null;
            }
        });
    }

    @Test
    public void nullSymbolFail() throws Exception {
        final ExecutionReport report = ExecReportSummaryTestBase.removeField(this.createDummyExecReport(), 55);
        Assert.assertNull((Object)report.getInstrument());
        ExecReportSummaryTestBase.nonNullCVCheck("symbol", new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ReportsTestBase.sServices.save((ReportBase)report);
                return null;
            }
        });
    }

    @Test
    public void queryDefaults() {
        MultiExecReportSummary query = MultiExecReportSummary.all();
        Assert.assertEquals(null, (Object)query.getEntityOrder());
        Assert.assertEquals((long)-1L, (long)query.getFirstResult());
        Assert.assertEquals((long)-1L, (long)query.getMaxResult());
    }

    protected abstract I getInstrument();

    protected void assertSummary(ExecutionReportSummary inSummary, BigDecimal inAvgPrice, BigDecimal inCumQuantity, BigDecimal inLastPrice, BigDecimal inLastQuantity, OrderID inOrderID, OrderStatus inOrderStatus, OrderID inOrigOrderID, PersistentReport inReport, OrderID inRootID, Date inSendingTime, Side inSide, I inInstrument) throws Exception {
        ExecReportSummaryTestBase.assertBigDecimalEquals(inAvgPrice, inSummary.getAvgPrice());
        ExecReportSummaryTestBase.assertBigDecimalEquals(inCumQuantity, inSummary.getCumQuantity());
        ExecReportSummaryTestBase.assertBigDecimalEquals(inLastPrice, inSummary.getLastPrice());
        ExecReportSummaryTestBase.assertBigDecimalEquals(inLastQuantity, inSummary.getLastQuantity());
        Assert.assertEquals((Object)inOrderID, (Object)inSummary.getOrderID());
        Assert.assertEquals((Object)inOrderStatus, (Object)inSummary.getOrderStatus());
        Assert.assertEquals((Object)inOrigOrderID, (Object)inSummary.getOrigOrderID());
        ExecReportSummaryTestBase.assertReportEquals(inReport.toReport(), inSummary.getReport().toReport());
        Assert.assertEquals((Object)inReport.getViewerID(), (Object)inSummary.getViewerID());
        Assert.assertEquals((Object)inRootID, (Object)inSummary.getRootID());
        PersistTestBase.assertCalendarEquals((Date)inSendingTime, (Date)inSummary.getSendingTime(), (TemporalType)TemporalType.TIMESTAMP);
        Assert.assertEquals((Object)inSide, (Object)inSummary.getSide());
        this.assertInstrument(inSummary, inInstrument);
    }

    protected void assertInstrument(ExecutionReportSummary inSummary, I inInstrument) {
        Assert.assertEquals((Object)inInstrument.getSecurityType(), (Object)inSummary.getSecurityType());
        Assert.assertEquals((Object)inInstrument.getSymbol(), (Object)inSummary.getSymbol());
    }

    private static ExecutionReport removeField(ExecutionReport inReport, int inTag) {
        ((HasFIXMessage)inReport).getMessage().removeField(inTag);
        return inReport;
    }

    private ExecutionReport createDummyExecReport() throws Exception {
        return ExecReportSummaryTestBase.createExecReport("o1", null, this.getInstrument(), Side.Buy, OrderStatus.Filled, BigDecimal.ONE, BigDecimal.ONE, BigDecimal.ONE, BigDecimal.ONE);
    }
}

