/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors.history;

import java.math.BigDecimal;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.module.ExpectedFailure;
import org.marketcetera.ors.history.InstrumentSummaryFields;
import org.marketcetera.trade.Equity;
import org.marketcetera.trade.Instrument;
import org.marketcetera.trade.Option;
import org.marketcetera.trade.OptionType;
import org.marketcetera.trade.SecurityType;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: InstrumentSummaryFieldsTest.java 16154 2012-07-14 16:34:05Z colin $")
public class InstrumentSummaryFieldsTest {
    @Test
    public void equity() {
        Equity equity = new Equity("equity");
        InstrumentSummaryFields fields = (InstrumentSummaryFields)InstrumentSummaryFields.SELECTOR.forInstrument((Instrument)equity);
        Assert.assertNull((Object)fields.getOptionType((Instrument)equity));
        Assert.assertNull((Object)fields.getExpiry((Instrument)equity));
        Assert.assertNull((Object)fields.getStrikePrice((Instrument)equity));
    }

    @Test
    public void options() {
        Option option = new Option("option", "20101010", BigDecimal.TEN, OptionType.Put);
        InstrumentSummaryFields fields = (InstrumentSummaryFields)InstrumentSummaryFields.SELECTOR.forInstrument((Instrument)option);
        Assert.assertEquals((Object)option.getType(), (Object)fields.getOptionType((Instrument)option));
        Assert.assertEquals((Object)option.getExpiry(), (Object)fields.getExpiry((Instrument)option));
        Assert.assertEquals((Object)option.getStrikePrice(), (Object)fields.getStrikePrice((Instrument)option));
    }

    @Test
    public void unknown() throws Exception {
        new ExpectedFailure<IllegalArgumentException>(){

            protected void run() throws Exception {
                InstrumentSummaryFields.SELECTOR.forInstrument(new Instrument(){

                    public String getSymbol() {
                        return null;
                    }

                    public SecurityType getSecurityType() {
                        return null;
                    }
                });
            }
        };
    }
}

