/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors.history;

import java.math.BigDecimal;
import org.junit.Assert;
import org.marketcetera.ors.history.ExecReportSummaryTestBase;
import org.marketcetera.ors.history.ExecutionReportSummary;
import org.marketcetera.trade.Option;
import org.marketcetera.trade.OptionType;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: OptionExecReportSummaryTest.java 16154 2012-07-14 16:34:05Z colin $")
public class OptionExecReportSummaryTest
extends ExecReportSummaryTestBase<Option> {
    @Override
    protected Option getInstrument() {
        return new Option("sym", "20101010", BigDecimal.TEN, OptionType.Put);
    }

    @Override
    protected void assertInstrument(ExecutionReportSummary inSummary, Option inOption) {
        super.assertInstrument(inSummary, inOption);
        Assert.assertEquals((Object)inOption.getExpiry(), (Object)inSummary.getExpiry());
        OptionExecReportSummaryTest.assertBigDecimalEquals(inOption.getStrikePrice(), inSummary.getStrikePrice());
        Assert.assertEquals((Object)inOption.getType(), (Object)inSummary.getOptionType());
    }
}

