/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors.history;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.core.position.PositionKey;
import org.marketcetera.core.position.PositionKeyFactory;
import org.marketcetera.ors.history.PositionsTestBase;
import org.marketcetera.ors.security.SimpleUser;
import org.marketcetera.trade.Instrument;
import org.marketcetera.trade.Option;
import org.marketcetera.trade.OptionType;
import org.marketcetera.trade.Side;
import org.marketcetera.trade.UserID;
import org.marketcetera.util.log.SLF4JLoggerProxy;

public class OptionPositionsTest
extends PositionsTestBase<Option> {
    private static final Option OPTION_A = new Option("A", "20101010", BigDecimal.TEN, OptionType.Call);
    private static final Option OPTION_B = new Option("A", "20101010", BigDecimal.TEN, OptionType.Put);
    private static final Option TEST_OPTION = new Option("A", "20101010", BigDecimal.ONE, OptionType.Put);

    @Override
    protected Option getInstrument() {
        return TEST_OPTION;
    }

    @Override
    protected Option getInstrumentA() {
        return OPTION_A;
    }

    @Override
    protected Option getInstrumentB() {
        return OPTION_B;
    }

    @Override
    protected BigDecimal getInstrumentPosition(Date inDate, Option inOption) throws Exception {
        return OptionPositionsTest.getPosition(inDate, inOption);
    }

    @Override
    protected BigDecimal getInstrumentPosition(Date inDate, Option inOption, SimpleUser inUser) throws Exception {
        return OptionPositionsTest.getPosition(inDate, inOption, inUser);
    }

    @Override
    protected Map<PositionKey<Option>, BigDecimal> getInstrumentPositions(Date inDate) throws Exception {
        return OptionPositionsTest.getAllOptionPositions(inDate);
    }

    @Override
    protected Map<PositionKey<Option>, BigDecimal> getInstrumentPositions(Date inAfter, SimpleUser inUser) throws Exception {
        return OptionPositionsTest.getAllOptionPositions(inAfter, inUser);
    }

    @Test
    public void optionsDistinguished() throws Exception {
        Map<PositionKey<Option>, BigDecimal> positions;
        String[] symbols = new String[]{"abc", "pqr"};
        String[] expiries = new String[]{"201010", "20101010"};
        BigDecimal[] strikes = new BigDecimal[]{BigDecimal.ONE, BigDecimal.TEN};
        OptionType[] types = new OptionType[]{OptionType.Call, OptionType.Put};
        String[] accounts = new String[]{"blue", "green"};
        UserID superUserID = sActorID;
        UserID regularUserID = sViewerID;
        UserID[] actors = new UserID[]{superUserID, regularUserID};
        UserID[] viewers = new UserID[]{superUserID, regularUserID};
        BigDecimal individualPosition = BigDecimal.ONE;
        SimpleUser[] viewerUsers = new SimpleUser[]{sActor, sViewer};
        int orderID = 1;
        for (String symbol : symbols) {
            for (String expiry : expiries) {
                for (BigDecimal strike : strikes) {
                    for (OptionType opType : types) {
                        Option option = new Option(symbol, expiry, strike, opType);
                        for (String account : accounts) {
                            for (UserID actor : actors) {
                                for (UserID viewer : viewers) {
                                    OptionPositionsTest.createAndSaveER(String.valueOf(orderID++), null, (Instrument)option, Side.Buy, individualPosition, account, actor, viewer);
                                }
                            }
                        }
                    }
                }
            }
        }
        OptionPositionsTest.sleepForSignificantTime();
        Date date = new Date();
        for (String symbol : symbols) {
            for (String expiry : expiries) {
                for (BigDecimal strike : strikes) {
                    for (OptionType opType : types) {
                        Option option = new Option(symbol, expiry, strike, opType);
                        for (SimpleUser viewer : viewerUsers) {
                            BigDecimal position = OptionPositionsTest.getPosition(date, option, viewer);
                            SLF4JLoggerProxy.error((Object)((Object)this), (String)"Option:{}: Viewer: {}: Position: {}", (Object[])new Object[]{option, viewer, position});
                            OptionPositionsTest.assertBigDecimalEquals(individualPosition.multiply(BigDecimal.valueOf(superUserID.equals((Object)viewer.getUserID()) ? (long)(accounts.length * actors.length * viewers.length) : (long)(accounts.length * actors.length))), position);
                        }
                    }
                }
            }
        }
        for (String string : symbols) {
            for (SimpleUser viewer : viewerUsers) {
                int numExpectedEntries = 0;
                positions = OptionPositionsTest.getOptionPositions(date, viewer, string);
                SLF4JLoggerProxy.error((Object)((Object)this), (String)"Symbol:{}: Viewer: {}: Positions: {}", (Object[])new Object[]{string, viewer, positions});
                for (String expiry : expiries) {
                    for (BigDecimal strike : strikes) {
                        for (OptionType opType : types) {
                            for (String account : accounts) {
                                BigDecimal expectedPosition = superUserID.equals((Object)viewer.getUserID()) ? individualPosition.multiply(BigDecimal.valueOf(viewers.length)) : individualPosition;
                                for (UserID actor : actors) {
                                    ++numExpectedEntries;
                                    Assert.assertThat(positions, (Matcher)Matchers.hasEntry((Object)PositionKeyFactory.createOptionKey((String)string, (String)expiry, (BigDecimal)strike, (OptionType)opType, (String)account, (String)String.valueOf(actor.getValue())), (Object)expectedPosition.setScale(5)));
                                }
                            }
                        }
                    }
                }
                Assert.assertEquals((long)numExpectedEntries, (long)positions.size());
            }
        }
        for (String string : viewerUsers) {
            int numExpectedEntries = 0;
            positions = OptionPositionsTest.getAllOptionPositions(date, (SimpleUser)string);
            SLF4JLoggerProxy.error((Object)((Object)this), (String)"Viewer: {}: Positions: {}", (Object[])new Object[]{string, positions});
            for (String symbol : symbols) {
                for (String expiry : expiries) {
                    for (BigDecimal strike : strikes) {
                        for (OptionType opType : types) {
                            for (String account : accounts) {
                                BigDecimal expectedPosition = superUserID.equals((Object)string.getUserID()) ? individualPosition.multiply(BigDecimal.valueOf(viewers.length)) : individualPosition;
                                for (UserID actor : actors) {
                                    ++numExpectedEntries;
                                    Assert.assertThat(positions, (Matcher)Matchers.hasEntry((Object)PositionKeyFactory.createOptionKey((String)symbol, (String)expiry, (BigDecimal)strike, (OptionType)opType, (String)account, (String)String.valueOf(actor.getValue())), (Object)expectedPosition.setScale(5)));
                                }
                            }
                        }
                    }
                }
            }
            Assert.assertEquals((long)numExpectedEntries, (long)positions.size());
        }
    }
}

