/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors.history;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.marketcetera.core.position.PositionKey;
import org.marketcetera.ors.history.ReportHistoryTestBase;
import org.marketcetera.ors.security.SimpleUser;
import org.marketcetera.trade.Option;
import org.marketcetera.trade.OptionType;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: OptionReportsHistoryTest.java 16154 2012-07-14 16:34:05Z colin $")
public class OptionReportsHistoryTest
extends ReportHistoryTestBase<Option> {
    @Override
    public void instrument() throws Exception {
        Date before = new Date();
        Option option = this.getInstrument();
        super.instrument();
        Date after = new Date();
        Assert.assertThat(OptionReportsHistoryTest.getOptionPositions(after, option.getSymbol()), (Matcher)Matchers.allOf((Matcher[])new Matcher[]{OptionReportsHistoryTest.isOfSize(1), Matchers.hasEntry(OptionReportsHistoryTest.pos(option), (Object)this.getExpectedPosition().setScale(5))}));
        Assert.assertThat(OptionReportsHistoryTest.getOptionPositions(after, sActor, option.getSymbol()), (Matcher)Matchers.allOf((Matcher[])new Matcher[]{OptionReportsHistoryTest.isOfSize(1), Matchers.hasEntry(OptionReportsHistoryTest.pos(option), (Object)this.getExpectedActorPosition().setScale(5))}));
        Assert.assertThat(OptionReportsHistoryTest.getOptionPositions(after, sExtraUser, option.getSymbol()), (Matcher)Matchers.allOf((Matcher[])new Matcher[]{OptionReportsHistoryTest.isOfSize(1), Matchers.hasEntry(OptionReportsHistoryTest.pos(option), (Object)this.getExpectedExtraPosition().setScale(5))}));
        Assert.assertThat(OptionReportsHistoryTest.getOptionPositions(before, option.getSymbol()), OptionReportsHistoryTest.isOfSize(0));
        Assert.assertThat(OptionReportsHistoryTest.getOptionPositions(before, sActor, option.getSymbol()), OptionReportsHistoryTest.isOfSize(0));
        Assert.assertThat(OptionReportsHistoryTest.getOptionPositions(before, sExtraUser, option.getSymbol()), OptionReportsHistoryTest.isOfSize(0));
    }

    @Override
    protected Option getInstrument() {
        return new Option("ubm", "20101010", BigDecimal.TEN, OptionType.Call);
    }

    @Override
    protected BigDecimal getInstrumentPosition(Date inDate, Option inInstrument) throws Exception {
        return OptionReportsHistoryTest.getPosition(inDate, inInstrument);
    }

    @Override
    protected BigDecimal getInstrumentPosition(Date inDate, Option inInstrument, SimpleUser inUser) throws Exception {
        return OptionReportsHistoryTest.getPosition(inDate, inInstrument, inUser);
    }

    @Override
    protected Map<PositionKey<Option>, BigDecimal> getInstrumentPositions(Date inDate) throws Exception {
        return OptionReportsHistoryTest.getAllOptionPositions(inDate);
    }

    @Override
    protected Map<PositionKey<Option>, BigDecimal> getInstrumentPositions(Date inDate, SimpleUser inUser) throws Exception {
        return OptionReportsHistoryTest.getAllOptionPositions(inDate, inUser);
    }
}

