/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors.history;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.marketcetera.ors.Principals;
import org.marketcetera.ors.history.MultiPersistentReportQuery;
import org.marketcetera.ors.history.PersistentReport;
import org.marketcetera.ors.history.ReportsTestBase;
import org.marketcetera.trade.Equity;
import org.marketcetera.trade.ExecutionReport;
import org.marketcetera.trade.Instrument;
import org.marketcetera.trade.Option;
import org.marketcetera.trade.OptionType;
import org.marketcetera.trade.OrderCancelReject;
import org.marketcetera.trade.OrderID;
import org.marketcetera.trade.OrderStatus;
import org.marketcetera.trade.ReportBase;
import org.marketcetera.trade.Side;

@RunWith(value=Parameterized.class)
public class PersistentReportTest
extends ReportsTestBase {
    private final Instrument mInstrument;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({new Equity("sym")}, {new Option("sym", "20101010", BigDecimal.TEN, OptionType.Put)});
    }

    public PersistentReportTest(Instrument inInstrument) {
        this.mInstrument = inInstrument;
    }

    @Test
    public void emptyBrokerActorViewer() throws Exception {
        PersistentReport report = new PersistentReport((ReportBase)PersistentReportTest.createCancelReject(null, null, null));
        Assert.assertNull((Object)report.getBrokerID());
        Assert.assertNull((Object)report.getActor());
        Assert.assertNull((Object)report.getActorID());
        Assert.assertNull((Object)report.getViewer());
        Assert.assertNull((Object)report.getViewerID());
        report = new PersistentReport((ReportBase)PersistentReportTest.createCancelReject(BROKER, sActorID, null));
        Assert.assertEquals((Object)BROKER, (Object)report.getBrokerID());
        Assert.assertEquals((long)sActor.getId(), (long)report.getActor().getId());
        Assert.assertEquals((Object)sActorID, (Object)report.getActorID());
        Assert.assertNull((Object)report.getViewer());
        Assert.assertNull((Object)report.getViewerID());
        report = new PersistentReport((ReportBase)PersistentReportTest.createCancelReject());
        Assert.assertEquals((Object)BROKER, (Object)report.getBrokerID());
        Assert.assertEquals((long)sActor.getId(), (long)report.getActor().getId());
        Assert.assertEquals((Object)sActorID, (Object)report.getActorID());
        Assert.assertEquals((long)sViewer.getId(), (long)report.getViewer().getId());
        Assert.assertEquals((Object)sViewerID, (Object)report.getViewerID());
    }

    @Test
    public void rejectSaveAndRetrieve() throws Exception {
        OrderCancelReject reject = PersistentReportTest.createCancelReject();
        Assert.assertNull((Object)reject.getReportID());
        sServices.save((ReportBase)reject);
        Assert.assertNotNull((Object)reject.getReportID());
        MultiPersistentReportQuery query = MultiPersistentReportQuery.all();
        Assert.assertEquals((long)1L, (long)query.fetchCount());
        List reports = query.fetch();
        Assert.assertEquals((long)1L, (long)reports.size());
        OrderCancelReject retrieved = (OrderCancelReject)((PersistentReport)reports.get(0)).toReport();
        PersistentReportTest.assertReportEquals((ReportBase)reject, (ReportBase)retrieved);
        Assert.assertSame((Object)Principals.UNKNOWN, (Object)PersistentReport.getPrincipals((OrderID)new OrderID("nonexistent")));
        Principals p = PersistentReport.getPrincipals((OrderID)reject.getOrderID());
        Assert.assertEquals((Object)sActorID, (Object)p.getActorID());
        Assert.assertEquals((Object)sViewerID, (Object)p.getViewerID());
    }

    @Test
    public void execReportSaveAndRetrieve() throws Exception {
        ExecutionReport report = PersistentReportTest.createExecReport("o1", null, this.getInstrument(), Side.Buy, OrderStatus.New, BigDecimal.ONE, BigDecimal.ONE, BigDecimal.ONE, BigDecimal.ONE);
        Assert.assertNull((Object)report.getReportID());
        sServices.save((ReportBase)report);
        Assert.assertNotNull((Object)report.getReportID());
        MultiPersistentReportQuery query = MultiPersistentReportQuery.all();
        Assert.assertEquals((long)1L, (long)query.fetchCount());
        List reports = query.fetch();
        Assert.assertEquals((long)1L, (long)reports.size());
        ExecutionReport retrieved = (ExecutionReport)((PersistentReport)reports.get(0)).toReport();
        PersistentReportTest.assertReportEquals((ReportBase)report, (ReportBase)retrieved);
        Principals p = PersistentReport.getPrincipals((OrderID)report.getOrderID());
        Assert.assertEquals((Object)sActorID, (Object)p.getActorID());
        Assert.assertEquals((Object)sViewerID, (Object)p.getViewerID());
    }

    @Test
    public void nullSendingTimeFailure() throws Exception {
        PersistentReportTest.nonNullCVCheck("sendingTime", new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ReportsTestBase.sServices.save(ReportsTestBase.removeSendingTime((ReportBase)ReportsTestBase.createCancelReject()));
                return null;
            }
        });
        PersistentReportTest.nonNullCVCheck("sendingTime", new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ReportsTestBase.sServices.save(ReportsTestBase.removeSendingTime((ReportBase)ReportsTestBase.createExecReport("o1", null, PersistentReportTest.this.getInstrument(), Side.Buy, OrderStatus.DoneForDay, BigDecimal.ONE, BigDecimal.ONE, BigDecimal.ONE, BigDecimal.ONE)));
                return null;
            }
        });
        MultiPersistentReportQuery query = MultiPersistentReportQuery.all();
        Assert.assertEquals((long)0L, (long)query.fetchCount());
        Assert.assertEquals((long)0L, (long)query.fetch().size());
    }

    @Test
    public void verifyIDSequential() throws Exception {
        OrderCancelReject reject1 = PersistentReportTest.createCancelReject();
        ExecutionReport report2 = PersistentReportTest.createExecReport("o1", null, this.getInstrument(), Side.Sell, OrderStatus.Filled, BigDecimal.ONE, BigDecimal.ONE, BigDecimal.ONE, BigDecimal.ONE);
        ExecutionReport report3 = PersistentReportTest.createExecReport("o2", null, this.getInstrument(), Side.Buy, OrderStatus.PartiallyFilled, BigDecimal.ONE, BigDecimal.ONE, BigDecimal.ONE, BigDecimal.ONE);
        OrderCancelReject reject4 = PersistentReportTest.createCancelReject();
        sServices.save((ReportBase)reject1);
        sServices.save((ReportBase)report2);
        sServices.save((ReportBase)report3);
        sServices.save((ReportBase)reject4);
        Assert.assertTrue((reject4.getReportID().compareTo(report3.getReportID()) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((report3.getReportID().compareTo(report2.getReportID()) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((report2.getReportID().compareTo(reject1.getReportID()) > 0 ? 1 : 0) != 0);
        MultiPersistentReportQuery query = MultiPersistentReportQuery.all();
        Assert.assertEquals((long)4L, (long)query.fetchCount());
        PersistentReportTest.assertRetrievedReports(query.fetch(), new ReportBase[]{reject1, report2, report3, reject4});
    }

    @Test
    public void sendingTimeFiltering() throws Exception {
        Date time1 = new Date();
        PersistentReportTest.sleepForSignificantTime();
        OrderCancelReject reject1 = PersistentReportTest.createCancelReject();
        PersistentReportTest.sleepForSignificantTime();
        Date time2 = new Date();
        PersistentReportTest.sleepForSignificantTime();
        ExecutionReport report2 = PersistentReportTest.createExecReport("o1", null, this.getInstrument(), Side.Sell, OrderStatus.Filled, BigDecimal.ONE, BigDecimal.ONE, BigDecimal.ONE, BigDecimal.ONE);
        PersistentReportTest.sleepForSignificantTime();
        Date time3 = new Date();
        PersistentReportTest.sleepForSignificantTime();
        ExecutionReport report3 = PersistentReportTest.createExecReport("o2", null, this.getInstrument(), Side.Buy, OrderStatus.PartiallyFilled, BigDecimal.ONE, BigDecimal.ONE, BigDecimal.ONE, BigDecimal.ONE);
        PersistentReportTest.sleepForSignificantTime();
        Date time4 = new Date();
        PersistentReportTest.sleepForSignificantTime();
        OrderCancelReject reject4 = PersistentReportTest.createCancelReject();
        PersistentReportTest.sleepForSignificantTime();
        Date time5 = new Date();
        sServices.save((ReportBase)reject1);
        sServices.save((ReportBase)report2);
        sServices.save((ReportBase)report3);
        sServices.save((ReportBase)reject4);
        MultiPersistentReportQuery query = MultiPersistentReportQuery.all();
        query.setSendingTimeAfterFilter(time1);
        Assert.assertEquals((long)4L, (long)query.fetchCount());
        PersistentReportTest.assertRetrievedReports(query.fetch(), new ReportBase[]{reject1, report2, report3, reject4});
        query.setSendingTimeAfterFilter(time2);
        Assert.assertEquals((long)3L, (long)query.fetchCount());
        PersistentReportTest.assertRetrievedReports(query.fetch(), new ReportBase[]{report2, report3, reject4});
        query.setSendingTimeAfterFilter(time3);
        Assert.assertEquals((long)2L, (long)query.fetchCount());
        PersistentReportTest.assertRetrievedReports(query.fetch(), new ReportBase[]{report3, reject4});
        query.setSendingTimeAfterFilter(time4);
        Assert.assertEquals((long)1L, (long)query.fetchCount());
        PersistentReportTest.assertRetrievedReports(query.fetch(), new ReportBase[]{reject4});
        query.setSendingTimeAfterFilter(time5);
        Assert.assertEquals((long)0L, (long)query.fetchCount());
        PersistentReportTest.assertRetrievedReports(query.fetch(), new ReportBase[0]);
    }

    @Test
    public void viewerFiltering() throws Exception {
        OrderCancelReject r1 = PersistentReportTest.createCancelReject();
        sServices.save((ReportBase)r1);
        OrderCancelReject r2 = PersistentReportTest.createCancelReject(BROKER, sActorID, null);
        sServices.save((ReportBase)r2);
        OrderCancelReject r3 = PersistentReportTest.createCancelReject(BROKER, sActorID, sExtraUserID);
        sServices.save((ReportBase)r3);
        MultiPersistentReportQuery query = MultiPersistentReportQuery.all();
        PersistentReportTest.assertRetrievedReports(query.fetch(), new ReportBase[]{r1, r2, r3});
        query.setViewerFilter(sViewer);
        PersistentReportTest.assertRetrievedReports(query.fetch(), new ReportBase[]{r1});
        query.setViewerFilter(sExtraUser);
        PersistentReportTest.assertRetrievedReports(query.fetch(), new ReportBase[]{r3});
        query.setViewerFilter(sActor);
        PersistentReportTest.assertRetrievedReports(query.fetch(), new ReportBase[0]);
    }

    @Test
    public void queryDefaults() throws Exception {
        MultiPersistentReportQuery query = MultiPersistentReportQuery.all();
        Assert.assertEquals((Object)MultiPersistentReportQuery.BY_ID, (Object)query.getEntityOrder());
        Assert.assertNull((Object)query.getSendingTimeAfterFilter());
        Assert.assertEquals((long)-1L, (long)query.getFirstResult());
        Assert.assertEquals((long)-1L, (long)query.getMaxResult());
    }

    @Test
    public void querySetters() throws Exception {
        MultiPersistentReportQuery query = MultiPersistentReportQuery.all();
        query.setEntityOrder(null);
        Assert.assertEquals(null, (Object)query.getEntityOrder());
        query.setEntityOrder(MultiPersistentReportQuery.BY_ID);
        Assert.assertEquals((Object)MultiPersistentReportQuery.BY_ID, (Object)query.getEntityOrder());
        query.setSendingTimeAfterFilter(null);
        Assert.assertEquals(null, (Object)query.getSendingTimeAfterFilter());
        Date d = new Date();
        query.setSendingTimeAfterFilter(d);
        Assert.assertEquals((Object)d, (Object)query.getSendingTimeAfterFilter());
    }

    @Test
    public void delete() {
    }

    private static void assertRetrievedReports(List<PersistentReport> inList, ReportBase ... inReports) throws Exception {
        Assert.assertEquals((long)inReports.length, (long)inList.size());
        int idx = 0;
        for (PersistentReport report : inList) {
            PersistentReportTest.assertReportEquals(inReports[idx++], report.toReport());
        }
    }

    private Instrument getInstrument() {
        return this.mInstrument;
    }
}

