/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors.history;

import java.math.BigDecimal;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.core.position.PositionKey;
import org.marketcetera.ors.history.ReportsTestBase;
import org.marketcetera.ors.security.SimpleUser;
import org.marketcetera.trade.ExecutionReport;
import org.marketcetera.trade.Instrument;
import org.marketcetera.trade.OrderStatus;
import org.marketcetera.trade.ReportBase;
import org.marketcetera.trade.Side;
import org.marketcetera.trade.UserID;

public abstract class PositionsTestBase<T extends Instrument>
extends ReportsTestBase {
    private static final BigDecimal POSITION_BUY_A = new BigDecimal("246.82");
    private static final BigDecimal POSITION_SELL_A = new BigDecimal("23.54");
    private static final BigDecimal POSITION_SELL_SHORT_A = new BigDecimal("89.45");
    private static final BigDecimal POSITION_SELL_SHORTE_A = new BigDecimal("43.54");
    private static final BigDecimal POSITION_SELL_B1 = new BigDecimal("8795.45");
    private static final BigDecimal POSITION_SELL_B2 = new BigDecimal("238.34");
    private static final BigDecimal POSITION_BUY_B1 = new BigDecimal("900");
    private static final BigDecimal POSITION_BUY_B2 = new BigDecimal("743.43");
    private static final BigDecimal POSITION_SELL_SHORT_B = new BigDecimal("280.101");
    private static final BigDecimal FINAL_POSITION_A = POSITION_BUY_A.subtract(POSITION_SELL_A).subtract(POSITION_SELL_SHORT_A).subtract(POSITION_SELL_SHORTE_A);
    private static final BigDecimal FINAL_POSITION_B = POSITION_SELL_B1.negate().subtract(POSITION_SELL_B2).add(POSITION_BUY_B1).subtract(POSITION_SELL_SHORT_B).add(POSITION_BUY_B2);

    @Test
    public void noRecords() throws Exception {
        PositionsTestBase.assertBigDecimalEquals(BigDecimal.ZERO, this.getInstrumentPosition(new Date(), this.getInstrument()));
        Date date = new Date();
        Assert.assertThat(this.getInstrumentPositions(date), PositionsTestBase.isOfSize(0));
    }

    @Test
    public void singleReportBuy() throws Exception {
        this.createBackgroundNoise();
        BigDecimal value = new BigDecimal("135.79");
        Date before = new Date();
        PositionsTestBase.createAndSaveER("o1", null, this.getInstrument(), Side.Buy, value, sExtraUserID);
        Date after = new Date();
        PositionsTestBase.assertBigDecimalEquals(value, this.getInstrumentPosition(after, this.getInstrument(), sExtraUser));
        Assert.assertThat(this.getInstrumentPositions(after, sExtraUser), (Matcher)Matchers.allOf((Matcher[])new Matcher[]{PositionsTestBase.isOfSize(1), Matchers.hasEntry(PositionsTestBase.pos(this.getInstrument()), (Object)value.setScale(5))}));
        PositionsTestBase.assertBigDecimalEquals(BigDecimal.ZERO, this.getInstrumentPosition(before, this.getInstrument(), sExtraUser));
        Assert.assertThat(this.getInstrumentPositions(before, sExtraUser), (Matcher)Matchers.allOf((Matcher[])new Matcher[]{PositionsTestBase.isOfSize(0)}));
    }

    @Test
    public void singleReportSell() throws Exception {
        this.createBackgroundNoise();
        BigDecimal value = new BigDecimal("135.79");
        Date before = new Date();
        PositionsTestBase.createAndSaveER("o1", null, this.getInstrument(), Side.Sell, value);
        Date after = new Date();
        this.verifyShortPosition(value, before, after);
    }

    @Test
    public void singleReportSellShort() throws Exception {
        this.createBackgroundNoise();
        BigDecimal value = new BigDecimal("135.79");
        Date before = new Date();
        PositionsTestBase.createAndSaveER("o1", null, this.getInstrument(), Side.SellShort, value);
        Date after = new Date();
        this.verifyShortPosition(value, before, after);
    }

    @Test
    public void singleReportSellShortExempt() throws Exception {
        this.createBackgroundNoise();
        BigDecimal value = new BigDecimal("135.79");
        Date before = new Date();
        PositionsTestBase.createAndSaveER("o1", null, this.getInstrument(), Side.SellShortExempt, value);
        Date after = new Date();
        this.verifyShortPosition(value, before, after);
    }

    @Test
    public void positionExcludedWhenZero() throws Exception {
        this.createBackgroundNoise();
        BigDecimal value = new BigDecimal("34895.434");
        Date before = new Date();
        PositionsTestBase.createAndSaveER("o1", null, this.getInstrument(), Side.Buy, value);
        Date after1 = new Date();
        PositionsTestBase.createAndSaveER("o2", null, this.getInstrument(), Side.Sell, value);
        Date after2 = new Date();
        PositionsTestBase.assertBigDecimalEquals(BigDecimal.ZERO, this.getInstrumentPosition(before, this.getInstrument()));
        Assert.assertThat(this.getInstrumentPositions(before), (Matcher)Matchers.allOf((Matcher[])new Matcher[]{PositionsTestBase.isOfSize(2), this.hasAandB()}));
        PositionsTestBase.assertBigDecimalEquals(value, this.getInstrumentPosition(after1, this.getInstrument()));
        Assert.assertThat(this.getInstrumentPositions(after1), (Matcher)Matchers.allOf((Matcher[])new Matcher[]{PositionsTestBase.isOfSize(3), Matchers.hasEntry(PositionsTestBase.pos(this.getInstrument()), (Object)value.setScale(5)), this.hasAandB()}));
        PositionsTestBase.assertBigDecimalEquals(BigDecimal.ZERO, this.getInstrumentPosition(after2, this.getInstrument()));
        Assert.assertThat(this.getInstrumentPositions(after2), (Matcher)Matchers.allOf((Matcher[])new Matcher[]{PositionsTestBase.isOfSize(2), this.hasAandB()}));
    }

    @Test
    public void chainReportsBuyAndSell() throws Exception {
        Date before = new Date();
        this.createChainReportsForBuyA();
        Date after1 = new Date();
        this.createChainReportsForSellA();
        Date after2 = new Date();
        this.createChainReportsForSellShortA();
        Date after3 = new Date();
        this.createChainReportsForSellShortExemptA();
        Date after4 = new Date();
        BigDecimal position = BigDecimal.ZERO;
        PositionsTestBase.assertBigDecimalEquals(position, this.getInstrumentPosition(before, this.getInstrumentA()));
        Assert.assertThat(this.getInstrumentPositions(before), PositionsTestBase.isOfSize(0));
        position = POSITION_BUY_A;
        PositionsTestBase.assertBigDecimalEquals(position, this.getInstrumentPosition(after1, this.getInstrumentA()));
        Assert.assertThat(this.getInstrumentPositions(after1), (Matcher)Matchers.allOf((Matcher[])new Matcher[]{PositionsTestBase.isOfSize(1), Matchers.hasEntry(PositionsTestBase.pos(this.getInstrumentA()), (Object)position.setScale(5))}));
        position = POSITION_BUY_A.subtract(POSITION_SELL_A);
        PositionsTestBase.assertBigDecimalEquals(position, this.getInstrumentPosition(after2, this.getInstrumentA()));
        Assert.assertThat(this.getInstrumentPositions(after2), (Matcher)Matchers.allOf((Matcher[])new Matcher[]{PositionsTestBase.isOfSize(1), Matchers.hasEntry(PositionsTestBase.pos(this.getInstrumentA()), (Object)position.setScale(5))}));
        position = POSITION_BUY_A.subtract(POSITION_SELL_A).subtract(POSITION_SELL_SHORT_A);
        PositionsTestBase.assertBigDecimalEquals(position, this.getInstrumentPosition(after3, this.getInstrumentA()));
        Assert.assertThat(this.getInstrumentPositions(after3), (Matcher)Matchers.allOf((Matcher[])new Matcher[]{PositionsTestBase.isOfSize(1), Matchers.hasEntry(PositionsTestBase.pos(this.getInstrumentA()), (Object)position.setScale(5))}));
        position = FINAL_POSITION_A;
        PositionsTestBase.assertBigDecimalEquals(position, this.getInstrumentPosition(after4, this.getInstrumentA()));
        Assert.assertThat(this.getInstrumentPositions(after4), (Matcher)Matchers.allOf((Matcher[])new Matcher[]{PositionsTestBase.isOfSize(1), Matchers.hasEntry(PositionsTestBase.pos(this.getInstrumentA()), (Object)position.setScale(5))}));
    }

    @Test
    public void chainReportsBuyAndSellMultiAccountsActors() throws Exception {
        String oAccount = "accounta";
        BigDecimal one = BigDecimal.ONE;
        BigDecimal two = one.add(new BigDecimal(1));
        BigDecimal three = two.add(new BigDecimal(1));
        BigDecimal four = three.add(new BigDecimal(1));
        BigDecimal five = four.add(new BigDecimal(1));
        this.createChainReportsForBuyA("1a", "account", sViewerID, sViewerID, one);
        this.createChainReportsForBuyA("1b", "account", sViewerID, sViewerID, one);
        this.createChainReportsForBuyA("2a", "account", sExtraUserID, sViewerID, one);
        this.createChainReportsForBuyA("2b", "account", sExtraUserID, sViewerID, two);
        this.createChainReportsForBuyA("3a", oAccount, sViewerID, sViewerID, one);
        this.createChainReportsForBuyA("3b", oAccount, sViewerID, sViewerID, three);
        this.createChainReportsForBuyA("4a", oAccount, null, sViewerID, one);
        this.createChainReportsForBuyA("4b", oAccount, null, sViewerID, four);
        this.createChainReportsForSellB1("1a", null, sViewerID, sExtraUserID, four);
        this.createChainReportsForSellB1("1b", null, sViewerID, sExtraUserID, one);
        this.createChainReportsForSellB1("2a", "account", sExtraUserID, sExtraUserID, three);
        this.createChainReportsForSellB1("2b", "account", sExtraUserID, sExtraUserID, one);
        this.createChainReportsForSellB1("3a", null, null, sExtraUserID, two);
        this.createChainReportsForSellB1("3b", null, null, sExtraUserID, one);
        this.createChainReportsForSellB1("4a", oAccount, null, sExtraUserID, one);
        this.createChainReportsForSellB1("4b", oAccount, null, sExtraUserID, one);
        Date after = new Date();
        Assert.assertThat(this.getInstrumentPositions(after), (Matcher)Matchers.allOf((Matcher[])new Matcher[]{PositionsTestBase.isOfSize(4), Matchers.hasEntry(PositionsTestBase.pos(this.getInstrumentA(), "account", sViewerID), (Object)two.setScale(5)), Matchers.hasEntry(PositionsTestBase.pos(this.getInstrumentA(), "account", sExtraUserID), (Object)three.setScale(5)), Matchers.hasEntry(PositionsTestBase.pos(this.getInstrumentA(), oAccount, sViewerID), (Object)four.setScale(5)), Matchers.hasEntry(PositionsTestBase.pos(this.getInstrumentA(), oAccount, (String)null), (Object)five.setScale(5))}));
        Assert.assertThat(this.getInstrumentPositions(after, sActor), (Matcher)Matchers.allOf((Matcher[])new Matcher[]{PositionsTestBase.isOfSize(8), Matchers.hasEntry(PositionsTestBase.pos(this.getInstrumentA(), "account", sViewerID), (Object)two.setScale(5)), Matchers.hasEntry(PositionsTestBase.pos(this.getInstrumentA(), "account", sExtraUserID), (Object)three.setScale(5)), Matchers.hasEntry(PositionsTestBase.pos(this.getInstrumentA(), oAccount, sViewerID), (Object)four.setScale(5)), Matchers.hasEntry(PositionsTestBase.pos(this.getInstrumentA(), oAccount, (String)null), (Object)five.setScale(5)), Matchers.hasEntry(PositionsTestBase.pos(this.getInstrumentB(), null, sViewerID), (Object)five.negate().setScale(5)), Matchers.hasEntry(PositionsTestBase.pos(this.getInstrumentB(), "account", sExtraUserID), (Object)four.negate().setScale(5)), Matchers.hasEntry(PositionsTestBase.pos(this.getInstrumentB(), null, (String)null), (Object)three.negate().setScale(5)), Matchers.hasEntry(PositionsTestBase.pos(this.getInstrumentB(), oAccount, (String)null), (Object)two.negate().setScale(5))}));
    }

    @Test
    public void chainReportsInterLeaved() throws Exception {
        Date before = new Date();
        this.createChainReportsForBuyA();
        this.createChainReportsForSellB1();
        Date after1 = new Date();
        this.createChainReportsForSellA();
        this.createChainReportsForSellB2();
        Date after2 = new Date();
        this.createChainReportsForSellShortA();
        this.createChainReportsForBuyB1();
        Date after3 = new Date();
        this.createChainReportsForSellShortExemptA();
        this.createChainReportsForSellShortB();
        Date after4 = new Date();
        this.createChainReportsForBuyB2();
        Date after5 = new Date();
        PositionsTestBase.assertBigDecimalEquals(BigDecimal.ZERO, this.getInstrumentPosition(before, this.getInstrumentA()));
        PositionsTestBase.assertBigDecimalEquals(BigDecimal.ZERO, this.getInstrumentPosition(before, this.getInstrumentB()));
        Assert.assertThat(this.getInstrumentPositions(before), PositionsTestBase.isOfSize(0));
        BigDecimal positionA = POSITION_BUY_A;
        BigDecimal positionB = POSITION_SELL_B1.negate();
        PositionsTestBase.assertBigDecimalEquals(positionA, this.getInstrumentPosition(after1, this.getInstrumentA()));
        PositionsTestBase.assertBigDecimalEquals(positionB, this.getInstrumentPosition(after1, this.getInstrumentB()));
        Assert.assertThat(this.getInstrumentPositions(after1), (Matcher)Matchers.allOf((Matcher[])new Matcher[]{PositionsTestBase.isOfSize(2), Matchers.hasEntry(PositionsTestBase.pos(this.getInstrumentA()), (Object)positionA.setScale(5)), Matchers.hasEntry(PositionsTestBase.pos(this.getInstrumentB()), (Object)positionB.setScale(5))}));
        positionA = POSITION_BUY_A.subtract(POSITION_SELL_A);
        positionB = POSITION_SELL_B1.negate().subtract(POSITION_SELL_B2);
        PositionsTestBase.assertBigDecimalEquals(positionA, this.getInstrumentPosition(after2, this.getInstrumentA()));
        PositionsTestBase.assertBigDecimalEquals(positionB, this.getInstrumentPosition(after2, this.getInstrumentB()));
        Assert.assertThat(this.getInstrumentPositions(after2), (Matcher)Matchers.allOf((Matcher[])new Matcher[]{PositionsTestBase.isOfSize(2), Matchers.hasEntry(PositionsTestBase.pos(this.getInstrumentA()), (Object)positionA.setScale(5)), Matchers.hasEntry(PositionsTestBase.pos(this.getInstrumentB()), (Object)positionB.setScale(5))}));
        positionA = POSITION_BUY_A.subtract(POSITION_SELL_A).subtract(POSITION_SELL_SHORT_A);
        positionB = POSITION_SELL_B1.negate().subtract(POSITION_SELL_B2).add(POSITION_BUY_B1);
        PositionsTestBase.assertBigDecimalEquals(positionA, this.getInstrumentPosition(after3, this.getInstrumentA()));
        PositionsTestBase.assertBigDecimalEquals(positionB, this.getInstrumentPosition(after3, this.getInstrumentB()));
        Assert.assertThat(this.getInstrumentPositions(after3), (Matcher)Matchers.allOf((Matcher[])new Matcher[]{PositionsTestBase.isOfSize(2), Matchers.hasEntry(PositionsTestBase.pos(this.getInstrumentA()), (Object)positionA.setScale(5)), Matchers.hasEntry(PositionsTestBase.pos(this.getInstrumentB()), (Object)positionB.setScale(5))}));
        positionA = FINAL_POSITION_A;
        positionB = POSITION_SELL_B1.negate().subtract(POSITION_SELL_B2).add(POSITION_BUY_B1).subtract(POSITION_SELL_SHORT_B);
        PositionsTestBase.assertBigDecimalEquals(positionA, this.getInstrumentPosition(after4, this.getInstrumentA()));
        PositionsTestBase.assertBigDecimalEquals(positionB, this.getInstrumentPosition(after4, this.getInstrumentB()));
        Assert.assertThat(this.getInstrumentPositions(after4), (Matcher)Matchers.allOf((Matcher[])new Matcher[]{PositionsTestBase.isOfSize(2), Matchers.hasEntry(PositionsTestBase.pos(this.getInstrumentA()), (Object)positionA.setScale(5)), Matchers.hasEntry(PositionsTestBase.pos(this.getInstrumentB()), (Object)positionB.setScale(5))}));
        positionA = FINAL_POSITION_A;
        positionB = FINAL_POSITION_B;
        PositionsTestBase.assertBigDecimalEquals(positionA, this.getInstrumentPosition(after5, this.getInstrumentA()));
        PositionsTestBase.assertBigDecimalEquals(positionB, this.getInstrumentPosition(after5, this.getInstrumentB()));
        Assert.assertThat(this.getInstrumentPositions(after5), (Matcher)Matchers.allOf((Matcher[])new Matcher[]{PositionsTestBase.isOfSize(2), Matchers.hasEntry(PositionsTestBase.pos(this.getInstrumentA()), (Object)positionA.setScale(5)), Matchers.hasEntry(PositionsTestBase.pos(this.getInstrumentB()), (Object)positionB.setScale(5))}));
    }

    @Test
    public void partialFillOfReplaced() throws Exception {
        PositionsTestBase.assertBigDecimalEquals(BigDecimal.ZERO, this.getInstrumentPosition(new Date(), this.getInstrument()));
        String ordId1 = "order-" + System.nanoTime();
        ExecutionReport newReport = PositionsTestBase.createExecReport(ordId1, null, "execId", this.getInstrument(), Side.Buy, OrderStatus.New, BigDecimal.TEN, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BROKER, "account", "text", sActorID, sViewerID);
        sServices.save((ReportBase)newReport);
        PositionsTestBase.assertBigDecimalEquals(BigDecimal.ZERO, this.getInstrumentPosition(new Date(), this.getInstrument()));
        ExecutionReport partialReport1 = PositionsTestBase.createExecReport(ordId1, null, "execId", this.getInstrument(), Side.Buy, OrderStatus.PartiallyFilled, BigDecimal.TEN, BigDecimal.ONE, BigDecimal.ONE, BigDecimal.ONE, BigDecimal.ONE, BigDecimal.ONE, BROKER, "account", "text", sActorID, sViewerID);
        sServices.save((ReportBase)partialReport1);
        PositionsTestBase.assertBigDecimalEquals(BigDecimal.ONE, this.getInstrumentPosition(new Date(), this.getInstrument()));
        String ordId2 = "order-" + System.nanoTime();
        Assert.assertFalse((boolean)ordId1.equals(ordId2));
        ExecutionReport replacedReport1 = PositionsTestBase.createExecReport(ordId2, ordId1, "execId", this.getInstrument(), Side.Buy, OrderStatus.Replaced, BigDecimal.TEN, new BigDecimal(2), BigDecimal.ONE, BigDecimal.ONE, BigDecimal.ONE, BigDecimal.ONE, BROKER, "account", "text", sActorID, sViewerID);
        sServices.save((ReportBase)replacedReport1);
        PositionsTestBase.assertBigDecimalEquals(BigDecimal.ONE, this.getInstrumentPosition(new Date(), this.getInstrument()));
        String ordId3 = "order-" + System.nanoTime();
        Assert.assertFalse((boolean)ordId2.equals(ordId3));
        ExecutionReport replacedReport2 = PositionsTestBase.createExecReport(ordId3, ordId2, "execId", this.getInstrument(), Side.Buy, OrderStatus.Replaced, BigDecimal.TEN, new BigDecimal(3), BigDecimal.ONE, BigDecimal.ONE, BigDecimal.ONE, BigDecimal.ONE, BROKER, "account", "text", sActorID, sViewerID);
        sServices.save((ReportBase)replacedReport2);
        PositionsTestBase.assertBigDecimalEquals(BigDecimal.ONE, this.getInstrumentPosition(new Date(), this.getInstrument()));
        ExecutionReport partialReport2 = PositionsTestBase.createExecReport(ordId3, null, "execId", this.getInstrument(), Side.Buy, OrderStatus.PartiallyFilled, BigDecimal.TEN, new BigDecimal(3), new BigDecimal(2), new BigDecimal("1.5"), BigDecimal.ONE, new BigDecimal(3), BROKER, "account", "text", sActorID, sViewerID);
        sServices.save((ReportBase)partialReport2);
        PositionsTestBase.assertBigDecimalEquals(new BigDecimal(2), this.getInstrumentPosition(new Date(), this.getInstrument()));
    }

    protected abstract T getInstrument();

    protected abstract T getInstrumentA();

    protected abstract T getInstrumentB();

    protected abstract BigDecimal getInstrumentPosition(Date var1, T var2) throws Exception;

    protected abstract BigDecimal getInstrumentPosition(Date var1, T var2, SimpleUser var3) throws Exception;

    protected abstract Map<PositionKey<T>, BigDecimal> getInstrumentPositions(Date var1) throws Exception;

    protected abstract Map<PositionKey<T>, BigDecimal> getInstrumentPositions(Date var1, SimpleUser var2) throws Exception;

    private void verifyShortPosition(BigDecimal inValue, Date inBefore, Date inAfter) throws Exception {
        PositionsTestBase.assertBigDecimalEquals(inValue.negate(), this.getInstrumentPosition(inAfter, this.getInstrument()));
        Assert.assertThat(this.getInstrumentPositions(inAfter), (Matcher)Matchers.allOf((Matcher[])new Matcher[]{PositionsTestBase.isOfSize(3), Matchers.hasEntry(PositionsTestBase.pos(this.getInstrument()), (Object)inValue.negate().setScale(5)), this.hasAandB()}));
        PositionsTestBase.assertBigDecimalEquals(BigDecimal.ZERO, this.getInstrumentPosition(inBefore, this.getInstrument()));
        Assert.assertThat(this.getInstrumentPositions(inBefore), (Matcher)Matchers.allOf((Matcher[])new Matcher[]{PositionsTestBase.isOfSize(2), this.hasAandB()}));
    }

    private Matcher<Map<PositionKey<T>, BigDecimal>> hasAandB() {
        return Matchers.allOf((Matcher[])new Matcher[]{Matchers.hasEntry(PositionsTestBase.pos(this.getInstrumentA()), (Object)FINAL_POSITION_A.setScale(5)), Matchers.hasEntry(PositionsTestBase.pos(this.getInstrumentB()), (Object)FINAL_POSITION_B.setScale(5))});
    }

    private List<ExecutionReport> createChainReportsForBuyA() throws Exception {
        return this.createChainReportsForBuyA("", "account", sActorID, sViewerID, POSITION_BUY_A);
    }

    private List<ExecutionReport> createChainReportsForBuyA(String prefix, String inAccount, UserID inActorID, UserID inViewerID, BigDecimal finalPosition) throws Exception {
        LinkedList<ExecutionReport> reports = new LinkedList<ExecutionReport>();
        reports.add(PositionsTestBase.createAndSaveER(prefix + "a1", null, this.getInstrumentA(), Side.Buy, BigDecimal.ONE, inAccount, inActorID, inViewerID));
        reports.add(PositionsTestBase.createAndSaveER(prefix + "a1", null, this.getInstrumentA(), Side.Buy, BigDecimal.ONE, inAccount, inActorID, inViewerID, OrderStatus.PendingCancel));
        reports.add(PositionsTestBase.createAndSaveER(prefix + "a2", prefix + "a1", this.getInstrumentA(), Side.Buy, BigDecimal.TEN, inAccount, inActorID, inViewerID));
        reports.add(PositionsTestBase.createAndSaveER(prefix + "a2", prefix + "a1", this.getInstrumentA(), Side.Buy, BigDecimal.TEN, inAccount, inActorID, inViewerID, OrderStatus.PendingNew));
        reports.add(PositionsTestBase.createAndSaveER(prefix + "a3", prefix + "a2", this.getInstrumentA(), Side.Buy, POSITION_SELL_SHORTE_A, inAccount, inActorID, inViewerID));
        reports.add(PositionsTestBase.createAndSaveER(prefix + "a3", prefix + "a2", this.getInstrumentA(), Side.Buy, POSITION_SELL_SHORTE_A, inAccount, inActorID, inViewerID, OrderStatus.PendingReplace));
        reports.add(PositionsTestBase.createAndSaveER(prefix + "a4", prefix + "a3", this.getInstrumentA(), Side.Buy, finalPosition, inAccount, inActorID, inViewerID));
        reports.add(PositionsTestBase.createAndSaveER(prefix + "a4", prefix + "a3", this.getInstrumentA(), Side.Buy, finalPosition, inAccount, inActorID, inViewerID, OrderStatus.PendingNew));
        return reports;
    }

    private List<ExecutionReport> createChainReportsForSellA() throws Exception {
        LinkedList<ExecutionReport> reports = new LinkedList<ExecutionReport>();
        reports.add(PositionsTestBase.createAndSaveER("a5", null, this.getInstrumentA(), Side.Sell, BigDecimal.ONE));
        reports.add(PositionsTestBase.createAndSaveER("a5", null, this.getInstrumentA(), Side.Sell, BigDecimal.ONE, OrderStatus.PendingCancel));
        reports.add(PositionsTestBase.createAndSaveER("a6", "a5", this.getInstrumentA(), Side.Sell, BigDecimal.TEN));
        reports.add(PositionsTestBase.createAndSaveER("a6", "a5", this.getInstrumentA(), Side.Sell, BigDecimal.TEN, OrderStatus.PendingNew));
        reports.add(PositionsTestBase.createAndSaveER("a7", "a6", this.getInstrumentA(), Side.Sell, POSITION_SELL_A));
        reports.add(PositionsTestBase.createAndSaveER("a7", "a6", this.getInstrumentA(), Side.Sell, POSITION_SELL_A, OrderStatus.PendingReplace));
        return reports;
    }

    private List<ExecutionReport> createChainReportsForSellShortA() throws Exception {
        LinkedList<ExecutionReport> reports = new LinkedList<ExecutionReport>();
        reports.add(PositionsTestBase.createAndSaveER("a8", null, this.getInstrumentA(), Side.SellShort, BigDecimal.ONE));
        reports.add(PositionsTestBase.createAndSaveER("a8", null, this.getInstrumentA(), Side.SellShort, BigDecimal.ONE, OrderStatus.PendingCancel));
        reports.add(PositionsTestBase.createAndSaveER("a9", "a8", this.getInstrumentA(), Side.SellShort, POSITION_SELL_SHORT_A));
        reports.add(PositionsTestBase.createAndSaveER("a9", "a8", this.getInstrumentA(), Side.SellShort, POSITION_SELL_SHORT_A, OrderStatus.PendingNew));
        return reports;
    }

    private List<ExecutionReport> createChainReportsForSellShortExemptA() throws Exception {
        LinkedList<ExecutionReport> reports = new LinkedList<ExecutionReport>();
        reports.add(PositionsTestBase.createAndSaveER("a10", null, this.getInstrumentA(), Side.SellShortExempt, POSITION_SELL_SHORTE_A));
        reports.add(PositionsTestBase.createAndSaveER("a10", null, this.getInstrumentA(), Side.SellShortExempt, POSITION_SELL_SHORTE_A, OrderStatus.PendingCancel));
        return reports;
    }

    private List<ExecutionReport> createChainReportsForSellB1() throws Exception {
        return this.createChainReportsForSellB1("", "account", sActorID, sViewerID, POSITION_SELL_B1);
    }

    private List<ExecutionReport> createChainReportsForSellB1(String prefix, String inAccount, UserID inActorID, UserID inViewerID, BigDecimal finalPosition) throws Exception {
        LinkedList<ExecutionReport> reports = new LinkedList<ExecutionReport>();
        reports.add(PositionsTestBase.createAndSaveER(prefix + "b1", null, this.getInstrumentB(), Side.Sell, BigDecimal.ONE, inAccount, inActorID, inViewerID));
        reports.add(PositionsTestBase.createAndSaveER(prefix + "b1", null, this.getInstrumentB(), Side.Sell, BigDecimal.ONE, inAccount, inActorID, inViewerID, OrderStatus.PendingCancel));
        reports.add(PositionsTestBase.createAndSaveER(prefix + "b2", prefix + "b1", this.getInstrumentB(), Side.Sell, BigDecimal.TEN, inAccount, inActorID, inViewerID));
        reports.add(PositionsTestBase.createAndSaveER(prefix + "b2", prefix + "b1", this.getInstrumentB(), Side.Sell, BigDecimal.TEN, inAccount, inActorID, inViewerID, OrderStatus.PendingNew));
        reports.add(PositionsTestBase.createAndSaveER(prefix + "b3", prefix + "b2", this.getInstrumentB(), Side.Sell, finalPosition, inAccount, inActorID, inViewerID));
        reports.add(PositionsTestBase.createAndSaveER(prefix + "b3", prefix + "b2", this.getInstrumentB(), Side.Sell, finalPosition, inAccount, inActorID, inViewerID, OrderStatus.PendingReplace));
        return reports;
    }

    private List<ExecutionReport> createChainReportsForSellB2() throws Exception {
        LinkedList<ExecutionReport> reports = new LinkedList<ExecutionReport>();
        reports.add(PositionsTestBase.createAndSaveER("b4", null, this.getInstrumentB(), Side.Sell, new BigDecimal("23.34")));
        reports.add(PositionsTestBase.createAndSaveER("b4", null, this.getInstrumentB(), Side.Sell, new BigDecimal("23.34"), OrderStatus.PendingCancel));
        reports.add(PositionsTestBase.createAndSaveER("b5", "b4", this.getInstrumentB(), Side.Sell, new BigDecimal("34.56")));
        reports.add(PositionsTestBase.createAndSaveER("b5", "b4", this.getInstrumentB(), Side.Sell, new BigDecimal("34.56"), OrderStatus.PendingNew));
        reports.add(PositionsTestBase.createAndSaveER("b6", "b5", this.getInstrumentB(), Side.Sell, POSITION_SELL_B2));
        reports.add(PositionsTestBase.createAndSaveER("b6", "b5", this.getInstrumentB(), Side.Sell, POSITION_SELL_B2, OrderStatus.PendingReplace));
        return reports;
    }

    private List<ExecutionReport> createChainReportsForBuyB1() throws Exception {
        LinkedList<ExecutionReport> reports = new LinkedList<ExecutionReport>();
        reports.add(PositionsTestBase.createAndSaveER("b7", null, this.getInstrumentB(), Side.Buy, POSITION_BUY_B1));
        reports.add(PositionsTestBase.createAndSaveER("b7", null, this.getInstrumentB(), Side.Buy, POSITION_BUY_B1, OrderStatus.PendingCancel));
        return reports;
    }

    private List<ExecutionReport> createChainReportsForBuyB2() throws Exception {
        LinkedList<ExecutionReport> reports = new LinkedList<ExecutionReport>();
        reports.add(PositionsTestBase.createAndSaveER("b8", null, this.getInstrumentB(), Side.Buy, new BigDecimal("38")));
        reports.add(PositionsTestBase.createAndSaveER("b8", null, this.getInstrumentB(), Side.Buy, new BigDecimal("38"), OrderStatus.PendingNew));
        reports.add(PositionsTestBase.createAndSaveER("b9", "b8", this.getInstrumentB(), Side.Buy, POSITION_BUY_B2));
        reports.add(PositionsTestBase.createAndSaveER("b9", "b8", this.getInstrumentB(), Side.Buy, POSITION_BUY_B2, OrderStatus.PendingCancel));
        return reports;
    }

    private List<ExecutionReport> createChainReportsForSellShortB() throws Exception {
        LinkedList<ExecutionReport> reports = new LinkedList<ExecutionReport>();
        reports.add(PositionsTestBase.createAndSaveER("b10", null, this.getInstrumentB(), Side.SellShort, new BigDecimal("23.34")));
        reports.add(PositionsTestBase.createAndSaveER("b10", null, this.getInstrumentB(), Side.SellShort, new BigDecimal("23.34"), OrderStatus.PendingCancel));
        reports.add(PositionsTestBase.createAndSaveER("b11", "b10", this.getInstrumentB(), Side.SellShort, new BigDecimal("34.56")));
        reports.add(PositionsTestBase.createAndSaveER("b11", "b10", this.getInstrumentB(), Side.SellShort, new BigDecimal("34.56"), OrderStatus.PendingNew));
        reports.add(PositionsTestBase.createAndSaveER("b12", "b11", this.getInstrumentB(), Side.SellShort, new BigDecimal("67.45")));
        reports.add(PositionsTestBase.createAndSaveER("b12", "b11", this.getInstrumentB(), Side.SellShort, new BigDecimal("67.45"), OrderStatus.PendingReplace));
        reports.add(PositionsTestBase.createAndSaveER("b13", "b12", this.getInstrumentB(), Side.SellShort, new BigDecimal("95.34")));
        reports.add(PositionsTestBase.createAndSaveER("b13", "b12", this.getInstrumentB(), Side.SellShort, new BigDecimal("95.34"), OrderStatus.PendingReplace));
        reports.add(PositionsTestBase.createAndSaveER("b14", "b13", this.getInstrumentB(), Side.SellShort, POSITION_SELL_SHORT_B));
        reports.add(PositionsTestBase.createAndSaveER("b14", "b13", this.getInstrumentB(), Side.SellShort, POSITION_SELL_SHORT_B, OrderStatus.PendingNew));
        return reports;
    }

    private void createBackgroundNoise() throws Exception {
        this.createChainReportsForBuyA();
        this.createChainReportsForBuyB1();
        this.createChainReportsForBuyB2();
        this.createChainReportsForSellA();
        this.createChainReportsForSellB1();
        this.createChainReportsForSellB2();
        this.createChainReportsForSellShortA();
        this.createChainReportsForSellShortB();
        this.createChainReportsForSellShortExemptA();
    }
}

