/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors.history;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.core.position.PositionKey;
import org.marketcetera.ors.history.ReportsTestBase;
import org.marketcetera.ors.security.SimpleUser;
import org.marketcetera.trade.Instrument;
import org.marketcetera.trade.ReportBase;
import org.marketcetera.trade.Side;

public abstract class ReportHistoryTestBase<I extends Instrument>
extends ReportsTestBase {
    private BigDecimal mExpectedPosition;
    private BigDecimal mExpectedActorPosition;
    private BigDecimal mExpectedExtraPosition;

    @Test
    public void instrument() throws Exception {
        String idPrefix = "ord";
        Date before = new Date();
        ReportHistoryTestBase.sleepForSignificantTime();
        this.mExpectedPosition = BigDecimal.TEN;
        String origOrderID = null;
        I instrument = this.getInstrument();
        for (int i = 0; i < 10; ++i) {
            sServices.save((ReportBase)ReportHistoryTestBase.createCancelReject());
            String orderID = "ord" + i;
            this.mExpectedPosition = this.mExpectedPosition.add(BigDecimal.ONE);
            ReportHistoryTestBase.createAndSaveER(orderID, origOrderID, instrument, Side.Buy, this.mExpectedPosition);
            origOrderID = orderID;
        }
        sServices.save((ReportBase)ReportHistoryTestBase.createCancelReject(sExtraUserID));
        this.mExpectedExtraPosition = this.mExpectedPosition.add(BigDecimal.ONE);
        ReportHistoryTestBase.createAndSaveER("ord10", null, instrument, Side.Buy, this.mExpectedExtraPosition, sExtraUserID);
        this.mExpectedActorPosition = this.mExpectedExtraPosition.add(this.mExpectedPosition);
        ReportHistoryTestBase.sleepForSignificantTime();
        Date after = new Date();
        Assert.assertEquals((long)20L, (long)sServices.getReportsSince(sViewer, before).length);
        Assert.assertEquals((long)22L, (long)sServices.getReportsSince(sActor, before).length);
        Assert.assertEquals((long)2L, (long)sServices.getReportsSince(sExtraUser, before).length);
        Assert.assertEquals((long)0L, (long)sServices.getReportsSince(sViewer, after).length);
        Assert.assertEquals((long)0L, (long)sServices.getReportsSince(sActor, after).length);
        Assert.assertEquals((long)0L, (long)sServices.getReportsSince(sExtraUser, after).length);
        ReportHistoryTestBase.assertBigDecimalEquals(this.mExpectedPosition, this.getInstrumentPosition(after, instrument));
        ReportHistoryTestBase.assertBigDecimalEquals(this.mExpectedActorPosition, this.getInstrumentPosition(after, instrument, sActor));
        ReportHistoryTestBase.assertBigDecimalEquals(this.mExpectedExtraPosition, this.getInstrumentPosition(after, instrument, sExtraUser));
        ReportHistoryTestBase.assertBigDecimalEquals(BigDecimal.ZERO, this.getInstrumentPosition(before, instrument));
        ReportHistoryTestBase.assertBigDecimalEquals(BigDecimal.ZERO, this.getInstrumentPosition(before, instrument, sActor));
        ReportHistoryTestBase.assertBigDecimalEquals(BigDecimal.ZERO, this.getInstrumentPosition(before, instrument, sExtraUser));
        Assert.assertThat(this.getInstrumentPositions(after), (Matcher)Matchers.allOf((Matcher[])new Matcher[]{ReportHistoryTestBase.isOfSize(1), Matchers.hasEntry(ReportHistoryTestBase.pos(instrument), (Object)this.mExpectedPosition.setScale(5))}));
        Assert.assertThat(this.getInstrumentPositions(after, sActor), (Matcher)Matchers.allOf((Matcher[])new Matcher[]{ReportHistoryTestBase.isOfSize(1), Matchers.hasEntry(ReportHistoryTestBase.pos(instrument), (Object)this.mExpectedActorPosition.setScale(5))}));
        Assert.assertThat(this.getInstrumentPositions(after, sExtraUser), (Matcher)Matchers.allOf((Matcher[])new Matcher[]{ReportHistoryTestBase.isOfSize(1), Matchers.hasEntry(ReportHistoryTestBase.pos(instrument), (Object)this.mExpectedExtraPosition.setScale(5))}));
        Assert.assertThat(ReportHistoryTestBase.getPositions(before), ReportHistoryTestBase.isOfSize(0));
        Assert.assertThat(ReportHistoryTestBase.getPositions(before, sActor), ReportHistoryTestBase.isOfSize(0));
        Assert.assertThat(ReportHistoryTestBase.getPositions(before, sExtraUser), ReportHistoryTestBase.isOfSize(0));
    }

    protected abstract I getInstrument();

    protected abstract BigDecimal getInstrumentPosition(Date var1, I var2) throws Exception;

    protected abstract BigDecimal getInstrumentPosition(Date var1, I var2, SimpleUser var3) throws Exception;

    protected abstract Map<PositionKey<I>, BigDecimal> getInstrumentPositions(Date var1) throws Exception;

    protected abstract Map<PositionKey<I>, BigDecimal> getInstrumentPositions(Date var1, SimpleUser var2) throws Exception;

    protected BigDecimal getExpectedPosition() {
        return this.mExpectedPosition;
    }

    protected BigDecimal getExpectedActorPosition() {
        return this.mExpectedActorPosition;
    }

    protected BigDecimal getExpectedExtraPosition() {
        return this.mExpectedExtraPosition;
    }
}

