/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors.history;

import java.io.File;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.Callable;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.marketcetera.core.IDFactory;
import org.marketcetera.core.InMemoryIDFactory;
import org.marketcetera.core.position.PositionKey;
import org.marketcetera.core.position.impl.PositionKeyImpl;
import org.marketcetera.event.HasFIXMessage;
import org.marketcetera.module.ExpectedFailure;
import org.marketcetera.ors.history.BasicReportHistoryServices;
import org.marketcetera.ors.history.MultiExecReportSummary;
import org.marketcetera.ors.history.MultiPersistentReportQuery;
import org.marketcetera.ors.history.ReportHistoryServices;
import org.marketcetera.ors.security.MultiSimpleUserQuery;
import org.marketcetera.ors.security.SimpleUser;
import org.marketcetera.persist.PersistTestBase;
import org.marketcetera.persist.PersistenceException;
import org.marketcetera.quickfix.FIXMessageFactory;
import org.marketcetera.quickfix.FIXVersion;
import org.marketcetera.trade.BrokerID;
import org.marketcetera.trade.Equity;
import org.marketcetera.trade.ExecutionReport;
import org.marketcetera.trade.Factory;
import org.marketcetera.trade.Instrument;
import org.marketcetera.trade.MessageCreationException;
import org.marketcetera.trade.Option;
import org.marketcetera.trade.OrderCancelReject;
import org.marketcetera.trade.OrderStatus;
import org.marketcetera.trade.Originator;
import org.marketcetera.trade.ReportBase;
import org.marketcetera.trade.Side;
import org.marketcetera.trade.TypesTestBase;
import org.marketcetera.trade.UserID;
import org.marketcetera.util.test.TestCaseBase;
import quickfix.Message;
import quickfix.StringField;
import quickfix.UtcTimeStampField;
import quickfix.field.ClOrdID;
import quickfix.field.OrigClOrdID;
import quickfix.field.SendingTime;

public class ReportsTestBase
extends TestCaseBase {
    protected static final BrokerID BROKER = new BrokerID("TestBroker");
    protected static final String ACCOUNT = "account";
    protected static final String TEXT = "text";
    protected static SimpleUser sActor;
    protected static UserID sActorID;
    protected static SimpleUser sViewer;
    protected static UserID sViewerID;
    protected static SimpleUser sExtraUser;
    protected static UserID sExtraUserID;
    private static FIXMessageFactory sMessageFactory;
    protected static ReportHistoryServices sServices;
    protected static final int SCALE = 5;

    @BeforeClass
    public static void springSetup() throws Exception {
        PersistTestBase.springSetup((String[])ReportsTestBase.getSpringFiles());
        sMessageFactory = FIXVersion.FIX_SYSTEM.getMessageFactory();
        InMemoryIDFactory idFactory = new InMemoryIDFactory(0L);
        idFactory.init();
        sServices = new BasicReportHistoryServices();
        sServices.init((IDFactory)idFactory, null, null);
        sActor = new SimpleUser();
        sActor.setName("actor");
        sActor.setPassword("pass".toCharArray());
        sActor.setActive(true);
        sActor.setSuperuser(true);
        sActor.save();
        sActorID = new UserID(sActor.getId());
        sViewer = new SimpleUser();
        sViewer.setName("viewer");
        sViewer.setPassword("pass2".toCharArray());
        sViewer.setActive(true);
        sViewer.setSuperuser(false);
        sViewer.save();
        sViewerID = new UserID(sViewer.getId());
        sExtraUser = new SimpleUser();
        sExtraUser.setName("extra");
        sExtraUser.setPassword("pass2".toCharArray());
        sExtraUser.setActive(true);
        sExtraUser.setSuperuser(false);
        sExtraUser.save();
        sExtraUserID = new UserID(sExtraUser.getId());
    }

    @AfterClass
    public static void cleanUser() throws Exception {
        MultiSimpleUserQuery suQuery = MultiSimpleUserQuery.all();
        suQuery.delete();
        Assert.assertEquals((long)0L, (long)suQuery.fetchCount());
        Assert.assertEquals((long)0L, (long)suQuery.fetch().size());
    }

    @Before
    @After
    public void cleanTables() throws Exception {
        MultiExecReportSummary erQuery = MultiExecReportSummary.all();
        MultiPersistentReportQuery prQuery = MultiPersistentReportQuery.all();
        erQuery.delete();
        prQuery.delete();
        Assert.assertEquals((long)0L, (long)erQuery.fetchCount());
        Assert.assertEquals((long)0L, (long)erQuery.fetch().size());
        Assert.assertEquals((long)0L, (long)prQuery.fetchCount());
        Assert.assertEquals((long)0L, (long)prQuery.fetch().size());
    }

    static OrderCancelReject createCancelReject() throws MessageCreationException {
        return ReportsTestBase.createCancelReject(sViewerID);
    }

    static OrderCancelReject createCancelReject(UserID inViewerID) throws MessageCreationException {
        return ReportsTestBase.createCancelReject(BROKER, inViewerID);
    }

    static OrderCancelReject createCancelReject(BrokerID inBrokerID, UserID inViewerID) throws MessageCreationException {
        return ReportsTestBase.createCancelReject(inBrokerID, sActorID, inViewerID);
    }

    static OrderCancelReject createCancelReject(BrokerID inBrokerID, UserID inActorID, UserID inViewerID) throws MessageCreationException {
        Message msg = sMessageFactory.newOrderCancelReject();
        msg.setField((StringField)new ClOrdID("rejord1"));
        msg.setField((StringField)new OrigClOrdID("rejorigord1"));
        ReportsTestBase.setSendingTime(msg);
        return Factory.getInstance().createOrderCancelReject(msg, inBrokerID, Originator.Server, inActorID, inViewerID);
    }

    static ExecutionReport createExecReport(String inOrderID, String inOrigOrderID, Instrument inInstrument, Side inSide, OrderStatus inOrderStatus, BigDecimal inCumQuantity, BigDecimal inAvgPrice, BigDecimal inLastQty, BigDecimal inLastPrice) throws Exception {
        return ReportsTestBase.createExecReport(inOrderID, inOrigOrderID, inInstrument, inSide, inOrderStatus, inCumQuantity, inAvgPrice, inLastQty, inLastPrice, sViewerID);
    }

    static ExecutionReport createExecReport(String inOrderID, String inOrigOrderID, Instrument inInstrument, Side inSide, OrderStatus inOrderStatus, BigDecimal inCumQuantity, BigDecimal inAvgPrice, BigDecimal inLastQty, BigDecimal inLastPrice, UserID inViewerID) throws Exception {
        return ReportsTestBase.createExecReport(inOrderID, inOrigOrderID, inInstrument, inSide, inOrderStatus, inCumQuantity, inAvgPrice, inLastQty, inLastPrice, BROKER, inViewerID);
    }

    static ExecutionReport createExecReport(String inOrderID, String inOrigOrderID, Instrument inInstrument, Side inSide, OrderStatus inOrderStatus, BigDecimal inCumQuantity, BigDecimal inAvgPrice, BigDecimal inLastQty, BigDecimal inLastPrice, BrokerID inBrokerID, UserID inViewerID) throws Exception {
        return ReportsTestBase.createExecReport(inOrderID, inOrigOrderID, inInstrument, inSide, inOrderStatus, inCumQuantity, inAvgPrice, inLastQty, inLastPrice, inBrokerID, sActorID, inViewerID);
    }

    static ExecutionReport createExecReport(String inOrderID, String inOrigOrderID, Instrument inInstrument, Side inSide, OrderStatus inOrderStatus, BigDecimal inCumQuantity, BigDecimal inAvgPrice, BigDecimal inLastQty, BigDecimal inLastPrice, BrokerID inBrokerID, UserID inActorID, UserID inViewerID) throws Exception {
        return ReportsTestBase.createExecReport(inOrderID, inOrigOrderID, inInstrument, inSide, inOrderStatus, inCumQuantity, inAvgPrice, inLastQty, inLastPrice, inBrokerID, ACCOUNT, TEXT, inActorID, inViewerID);
    }

    static ExecutionReport createExecReport(String inOrderID, String inOrigOrderID, Instrument inInstrument, Side inSide, OrderStatus inOrderStatus, BigDecimal inCumQuantity, BigDecimal inAvgPrice, BigDecimal inLastQty, BigDecimal inLastPrice, BrokerID inBrokerID, String inAccount, String inText, UserID inActorID, UserID inViewerID) throws Exception {
        return ReportsTestBase.createExecReport(inOrderID, inOrigOrderID, "exec1", inInstrument, inSide, inOrderStatus, new BigDecimal("23.234"), new BigDecimal("343.343"), inCumQuantity, inAvgPrice, inLastQty, inLastPrice, inBrokerID, inAccount, inText, inActorID, inViewerID);
    }

    static ExecutionReport createExecReport(String inOrderID, String inOrigOrderID, String inExecID, Instrument inInstrument, Side inSide, OrderStatus inOrderStatus, BigDecimal inOrderQty, BigDecimal inOrderPrice, BigDecimal inCumQuantity, BigDecimal inAvgPrice, BigDecimal inLastQty, BigDecimal inLastPrice, BrokerID inBrokerID, String inAccount, String inText, UserID inActorID, UserID inViewerID) throws Exception {
        Message msg = sMessageFactory.newExecutionReport(inOrderID, inOrderID, inExecID, inOrderStatus.getFIXValue(), inSide.getFIXValue(), inOrderQty, inOrderPrice, inLastQty, inLastPrice, inCumQuantity, inAvgPrice, inInstrument, inAccount, inText);
        if (inOrigOrderID != null) {
            msg.setField((StringField)new OrigClOrdID(inOrigOrderID));
        }
        ReportsTestBase.setSendingTime(msg);
        return Factory.getInstance().createExecutionReport(msg, inBrokerID, Originator.Server, inActorID, inViewerID);
    }

    private static void setSendingTime(Message inMsg) {
        inMsg.getHeader().setField((UtcTimeStampField)new SendingTime(new Date()));
    }

    static String[] getSpringFiles() {
        return new String[]{"file:" + DIR_ROOT + File.separator + "conf" + File.separator + "persist_tests.xml"};
    }

    static void assertReportEquals(ReportBase inReport1, ReportBase inReport2) {
        if (inReport1 instanceof ExecutionReport) {
            TypesTestBase.assertExecReportEquals((ExecutionReport)((ExecutionReport)inReport1), (ExecutionReport)((ExecutionReport)inReport2));
        } else {
            TypesTestBase.assertCancelRejectEquals((OrderCancelReject)((OrderCancelReject)inReport1), (OrderCancelReject)((OrderCancelReject)inReport2));
        }
        TypesTestBase.assertFIXEquals((ReportBase)inReport1, (ReportBase)inReport2);
        Assert.assertEquals((Object)inReport1.getReportID(), (Object)inReport2.getReportID());
    }

    protected static void nonNullCVCheck(String inFieldName, final Callable<?> inTest) throws Exception {
        String exceptMsg = ((PersistenceException)new ExpectedFailure<PersistenceException>(){

            protected void run() throws Exception {
                inTest.call();
            }
        }.getException()).getLocalizedDetail();
        Assert.assertTrue((String)exceptMsg, (boolean)exceptMsg.contains(inFieldName));
    }

    protected static ReportBase removeSendingTime(ReportBase inReport) {
        HasFIXMessage fix = (HasFIXMessage)inReport;
        fix.getMessage().getHeader().removeField(52);
        Assert.assertEquals(null, (Object)inReport.getSendingTime());
        return inReport;
    }

    static void assertBigDecimalEquals(BigDecimal inValue1, BigDecimal inValue2) {
        if (inValue1 == null ^ inValue2 == null) {
            Assert.fail((String)ReportsTestBase.getFailString(inValue1, inValue2));
        }
        if (inValue1 == null) {
            return;
        }
        Assert.assertTrue((String)ReportsTestBase.getFailString(inValue1, inValue2), (inValue1.compareTo(inValue2) == 0 ? 1 : 0) != 0);
    }

    private static String getFailString(Object inValue1, Object inValue2) {
        return "expected<" + inValue1 + ">, actual<" + inValue2 + ">";
    }

    protected static void sleepForSignificantTime() throws InterruptedException {
        PersistTestBase.sleepForSignificantTime();
    }

    protected static BigDecimal getPosition(Date inDate, Equity inEquity) throws Exception {
        return ReportsTestBase.getPosition(inDate, inEquity, sViewer);
    }

    protected static BigDecimal getPosition(Date inDate, Equity inEquity, SimpleUser inViewer) throws Exception {
        return sServices.getEquityPositionAsOf(inViewer, inDate, inEquity);
    }

    protected static Map<PositionKey<Equity>, BigDecimal> getPositions(Date inDate) throws Exception {
        return ReportsTestBase.getPositions(inDate, sViewer);
    }

    protected static BigDecimal getPosition(Date inDate, Option inOption) throws Exception {
        return ReportsTestBase.getPosition(inDate, inOption, sViewer);
    }

    protected static BigDecimal getPosition(Date inDate, Option inOption, SimpleUser inViewer) throws Exception {
        return sServices.getOptionPositionAsOf(inViewer, inDate, inOption);
    }

    protected static Map<PositionKey<Option>, BigDecimal> getAllOptionPositions(Date inDate) throws PersistenceException {
        return ReportsTestBase.getAllOptionPositions(inDate, sViewer);
    }

    protected static Map<PositionKey<Option>, BigDecimal> getAllOptionPositions(Date inDate, SimpleUser inViewer) throws PersistenceException {
        return sServices.getAllOptionPositionsAsOf(inViewer, inDate);
    }

    protected static Map<PositionKey<Option>, BigDecimal> getOptionPositions(Date inDate, String ... inSymbols) throws PersistenceException {
        return ReportsTestBase.getOptionPositions(inDate, sViewer, inSymbols);
    }

    protected static Map<PositionKey<Option>, BigDecimal> getOptionPositions(Date inDate, SimpleUser inViewer, String ... inSymbols) throws PersistenceException {
        return sServices.getOptionPositionsAsOf(inViewer, inDate, inSymbols);
    }

    protected static Map<PositionKey<Equity>, BigDecimal> getPositions(Date inDate, SimpleUser inViewer) throws Exception {
        return sServices.getAllEquityPositionsAsOf(inViewer, inDate);
    }

    protected static ExecutionReport createAndSaveER(String inOrderID, String inOrigOrderID, Instrument inInstrument, Side inSide, BigDecimal inCumQty) throws Exception {
        return ReportsTestBase.createAndSaveER(inOrderID, inOrigOrderID, inInstrument, inSide, inCumQty, sViewerID);
    }

    protected static ExecutionReport createAndSaveER(String inOrderID, String inOrigOrderID, Instrument inInstrument, Side inSide, BigDecimal inCumQty, OrderStatus inOrderStatus) throws Exception {
        return ReportsTestBase.createAndSaveER(inOrderID, inOrigOrderID, inInstrument, inSide, inCumQty, sViewerID, inOrderStatus);
    }

    protected static ExecutionReport createAndSaveER(String inOrderID, String inOrigOrderID, Instrument inInstrument, Side inSide, BigDecimal inCumQty, UserID inViewerID) throws Exception {
        return ReportsTestBase.createAndSaveER(inOrderID, inOrigOrderID, inInstrument, inSide, inCumQty, sActorID, inViewerID);
    }

    protected static ExecutionReport createAndSaveER(String inOrderID, String inOrigOrderID, Instrument inInstrument, Side inSide, BigDecimal inCumQty, UserID inViewerID, OrderStatus inOrderStatus) throws Exception {
        return ReportsTestBase.createAndSaveER(inOrderID, inOrigOrderID, inInstrument, inSide, inCumQty, sActorID, inViewerID, inOrderStatus);
    }

    protected static ExecutionReport createAndSaveER(String inOrderID, String inOrigOrderID, Instrument inInstrument, Side inSide, BigDecimal inCumQty, UserID inActorID, UserID inViewerID) throws Exception {
        return ReportsTestBase.createAndSaveER(inOrderID, inOrigOrderID, inInstrument, inSide, inCumQty, ACCOUNT, inActorID, inViewerID);
    }

    protected static ExecutionReport createAndSaveER(String inOrderID, String inOrigOrderID, Instrument inInstrument, Side inSide, BigDecimal inCumQty, UserID inActorID, UserID inViewerID, OrderStatus inOrderStatus) throws Exception {
        return ReportsTestBase.createAndSaveER(inOrderID, inOrigOrderID, inInstrument, inSide, inCumQty, ACCOUNT, inActorID, inViewerID, inOrderStatus);
    }

    protected static ExecutionReport createAndSaveER(String inOrderID, String inOrigOrderID, Instrument inInstrument, Side inSide, BigDecimal inCumQty, String inAccount, UserID inActorID, UserID inViewerID) throws Exception {
        return ReportsTestBase.createAndSaveER(inOrderID, inOrigOrderID, inInstrument, inSide, inCumQty, inAccount, inActorID, inViewerID, OrderStatus.PartiallyFilled);
    }

    protected static ExecutionReport createAndSaveER(String inOrderID, String inOrigOrderID, Instrument inInstrument, Side inSide, BigDecimal inCumQty, String inAccount, UserID inActorID, UserID inViewerID, OrderStatus inOrderStatus) throws Exception {
        ReportsTestBase.sleepForSignificantTime();
        ExecutionReport report = ReportsTestBase.createExecReport(inOrderID, inOrigOrderID, inInstrument, inSide, inOrderStatus, inCumQty, BigDecimal.TEN, BigDecimal.TEN, BigDecimal.TEN, BROKER, inAccount, TEXT, inActorID, inViewerID);
        sServices.save((ReportBase)report);
        ReportsTestBase.sleepForSignificantTime();
        return report;
    }

    protected static <T extends Instrument> PositionKey<T> pos(T inInstrument) {
        return ReportsTestBase.pos(inInstrument, ACCOUNT, sActorID);
    }

    protected static <T extends Instrument> PositionKey<T> pos(T inInstrument, String inAccount, UserID inActor) {
        return new PositionKeyImpl(inInstrument, inAccount, Long.toString(inActor.getValue()));
    }

    protected static <T extends Instrument> PositionKey<T> pos(T inSymbol, String inAccount, String inActor) {
        return new PositionKeyImpl(inSymbol, inAccount, inActor);
    }

    protected static Matcher<Map> isOfSize(int inLength) {
        return new SizeMatcher(inLength);
    }

    private static class SizeMatcher
    extends TypeSafeMatcher<Map> {
        private final int mExpectedSize;

        SizeMatcher(int inExpectedSize) {
            this.mExpectedSize = inExpectedSize;
        }

        public void describeTo(Description inDescription) {
            inDescription.appendText("map of length ").appendValue((Object)this.mExpectedSize);
        }

        public boolean matchesSafely(Map inMap) {
            return inMap.size() == this.mExpectedSize;
        }
    }
}

