/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors.info;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.Assert;
import org.marketcetera.ors.info.InfoException;
import org.marketcetera.ors.info.InfoRuntimeException;
import org.marketcetera.ors.info.Messages;
import org.marketcetera.ors.info.ReadInfo;
import org.marketcetera.ors.info.ReadInfoImpl;
import org.marketcetera.ors.info.ReadWriteInfo;
import org.marketcetera.ors.info.ReadWriteInfoImpl;
import org.marketcetera.ors.info.RequestInfoImpl;
import org.marketcetera.ors.info.SessionInfo;
import org.marketcetera.ors.info.SessionInfoImpl;
import org.marketcetera.ors.info.SystemInfo;
import org.marketcetera.ors.info.SystemInfoImpl;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.log.I18NBoundMessage3P;
import org.marketcetera.util.test.TestCaseBase;

public class InfoTestBase
extends TestCaseBase {
    protected static final String KEY_INT_1 = "Hello";
    protected static final Integer VALUE_INT_1 = new Integer(1);
    protected static final String KEY_NULL_VALUE = "\u0645\u0646\u0632\u0644";
    private static final String KEY_UNSET_VALUE = "\u3055\u3088\u3046\u306a\u3089";
    private static final String KEY_INT_2 = "\ud800\udc88 \ud800\udc89";
    private static final Integer VALUE_INT_2 = new Integer(2);
    private static final I18NBoundMessage MSG_NULL_KEY = Messages.NULL_KEY;
    private static final I18NBoundMessage MSG_MISSING_VALUE = new I18NBoundMessage1P(Messages.MISSING_VALUE, (Serializable)((Object)"\u3055\u3088\u3046\u306a\u3089"));
    private static final I18NBoundMessage MSG_NULL_VALUE = new I18NBoundMessage1P(Messages.NULL_VALUE, (Serializable)((Object)"\u0645\u0646\u0632\u0644"));
    private static final I18NBoundMessage MSG_BAD_CLASS_VALUE = new I18NBoundMessage3P(Messages.BAD_CLASS_VALUE, (Serializable)((Object)"Hello"), (Serializable)((Object)VALUE_INT_1.toString()), Long.class);
    private static final I18NBoundMessage MSG_VALUE_EXISTS = new I18NBoundMessage3P(Messages.VALUE_EXISTS, (Serializable)((Object)"Hello"), (Serializable)((Object)VALUE_INT_1.toString()), (Serializable)((Object)VALUE_INT_2.toString()));
    protected static final SystemInfoImpl SYSTEM_INFO = new SystemInfoImpl();
    protected static final SessionInfoImpl SESSION_INFO = new SessionInfoImpl((SystemInfo)SYSTEM_INFO);
    protected static final RequestInfoImpl REQUEST_INFO = new RequestInfoImpl((SessionInfo)SESSION_INFO);
    protected static final String SYSTEM_INFO_NAME = "SystemInfo_0000000001";
    protected static final String SESSION_INFO_NAME = "SessionInfo_0000000001";
    protected static final String REQUEST_INFO_NAME = "RequestInfo_0000000001";
    protected static final String TEST_NAME = "StoreName";
    private static final String LOG_GET_LOCATION = ReadInfoImpl.class.getName();
    private static final String LOG_SET_LOCATION = ReadWriteInfoImpl.class.getName();

    protected void read(ReadInfo info, String name, String path) throws Exception {
        String category = info.getClass().getName();
        InfoTestBase.setLevel((String)category, (Level)Level.OFF);
        this.getAppender().clear();
        Assert.assertEquals((Object)name, (Object)info.getName());
        Assert.assertEquals((Object)path, (Object)info.getPath());
        Assert.assertTrue((String)info.toString(), (boolean)info.toString().startsWith(path));
        Assert.assertTrue((boolean)info.contains(KEY_INT_1));
        try {
            info.contains(null);
            Assert.fail();
        }
        catch (InfoRuntimeException ex) {
            Assert.assertEquals((String)ex.getDetail(), (Object)MSG_NULL_KEY, (Object)ex.getI18NBoundMessage());
        }
        Assert.assertFalse((boolean)info.contains(KEY_UNSET_VALUE));
        Assert.assertTrue((boolean)info.contains(KEY_NULL_VALUE));
        Assert.assertSame((Object)VALUE_INT_1, (Object)info.getValue(KEY_INT_1));
        try {
            info.getValue(null);
            Assert.fail();
        }
        catch (InfoRuntimeException ex) {
            Assert.assertEquals((String)ex.getDetail(), (Object)MSG_NULL_KEY, (Object)ex.getI18NBoundMessage());
        }
        Assert.assertNull((Object)info.getValue(KEY_UNSET_VALUE));
        Assert.assertNull((Object)info.getValue(KEY_NULL_VALUE));
        Assert.assertSame((Object)VALUE_INT_1, (Object)info.getValueIfSet(KEY_INT_1));
        try {
            info.getValueIfSet(null);
            Assert.fail();
        }
        catch (InfoRuntimeException ex) {
            Assert.assertEquals((String)ex.getDetail(), (Object)MSG_NULL_KEY, (Object)ex.getI18NBoundMessage());
        }
        try {
            info.getValueIfSet(KEY_UNSET_VALUE);
            Assert.fail();
        }
        catch (InfoException ex) {
            Assert.assertEquals((String)ex.getDetail(), (Object)MSG_MISSING_VALUE, (Object)ex.getI18NBoundMessage());
        }
        Assert.assertNull((Object)info.getValueIfSet(KEY_NULL_VALUE));
        Assert.assertSame((Object)VALUE_INT_1, (Object)info.getValueIfNonNull(KEY_INT_1));
        try {
            info.getValueIfNonNull(null);
            Assert.fail();
        }
        catch (InfoRuntimeException ex) {
            Assert.assertEquals((String)ex.getDetail(), (Object)MSG_NULL_KEY, (Object)ex.getI18NBoundMessage());
        }
        try {
            info.getValueIfNonNull(KEY_UNSET_VALUE);
            Assert.fail();
        }
        catch (InfoException ex) {
            Assert.assertEquals((String)ex.getDetail(), (Object)MSG_MISSING_VALUE, (Object)ex.getI18NBoundMessage());
        }
        try {
            info.getValueIfNonNull(KEY_NULL_VALUE);
            Assert.fail();
        }
        catch (InfoException ex) {
            Assert.assertEquals((String)ex.getDetail(), (Object)MSG_NULL_VALUE, (Object)ex.getI18NBoundMessage());
        }
        Assert.assertSame((Object)VALUE_INT_1, (Object)info.getValueIfInstanceOf(KEY_INT_1, Integer.class));
        try {
            info.getValueIfInstanceOf(null, Integer.class);
            Assert.fail();
        }
        catch (InfoRuntimeException ex) {
            Assert.assertEquals((String)ex.getDetail(), (Object)MSG_NULL_KEY, (Object)ex.getI18NBoundMessage());
        }
        try {
            info.getValueIfInstanceOf(KEY_INT_1, Long.class);
            Assert.fail();
        }
        catch (InfoException ex) {
            Assert.assertEquals((String)ex.getDetail(), (Object)MSG_BAD_CLASS_VALUE, (Object)ex.getI18NBoundMessage());
        }
        try {
            info.getValueIfInstanceOf(KEY_UNSET_VALUE, Object.class);
            Assert.fail();
        }
        catch (InfoException ex) {
            Assert.assertEquals((String)ex.getDetail(), (Object)MSG_MISSING_VALUE, (Object)ex.getI18NBoundMessage());
        }
        Assert.assertNull((Object)info.getValueIfInstanceOf(KEY_NULL_VALUE, Integer.class));
        Assert.assertNull((Object)info.getValueIfInstanceOf(KEY_NULL_VALUE, Object.class));
        Assert.assertSame((Object)VALUE_INT_1, (Object)info.getValueIfNonNullInstanceOf(KEY_INT_1, Integer.class));
        try {
            info.getValueIfNonNullInstanceOf(null, Integer.class);
            Assert.fail();
        }
        catch (InfoRuntimeException ex) {
            Assert.assertEquals((String)ex.getDetail(), (Object)MSG_NULL_KEY, (Object)ex.getI18NBoundMessage());
        }
        try {
            info.getValueIfNonNullInstanceOf(KEY_INT_1, Long.class);
            Assert.fail();
        }
        catch (InfoException ex) {
            Assert.assertEquals((String)ex.getDetail(), (Object)MSG_BAD_CLASS_VALUE, (Object)ex.getI18NBoundMessage());
        }
        try {
            info.getValueIfNonNullInstanceOf(KEY_UNSET_VALUE, Object.class);
            Assert.fail();
        }
        catch (InfoException ex) {
            Assert.assertEquals((String)ex.getDetail(), (Object)MSG_MISSING_VALUE, (Object)ex.getI18NBoundMessage());
        }
        try {
            info.getValueIfNonNullInstanceOf(KEY_NULL_VALUE, Integer.class);
            Assert.fail();
        }
        catch (InfoException ex) {
            Assert.assertEquals((String)ex.getDetail(), (Object)MSG_NULL_VALUE, (Object)ex.getI18NBoundMessage());
        }
        this.assertNoEvents();
        InfoTestBase.setLevel((String)category, (Level)Level.DEBUG);
        info.contains(KEY_NULL_VALUE);
        this.assertSingleEvent(Level.DEBUG, category, "Store '" + info.getPath() + "': key '" + KEY_NULL_VALUE + "' is present.", LOG_GET_LOCATION);
        info.contains(KEY_UNSET_VALUE);
        this.assertSingleEvent(Level.DEBUG, category, "Store '" + info.getPath() + "': key '" + KEY_UNSET_VALUE + "' is absent.", LOG_GET_LOCATION);
        info.getValue(KEY_INT_1);
        this.assertSingleEvent(Level.DEBUG, category, "Store '" + info.getPath() + "': got key '" + KEY_INT_1 + "' with value '" + VALUE_INT_1 + "'.", LOG_GET_LOCATION);
        info.getValue(KEY_NULL_VALUE);
        this.assertSingleEvent(Level.DEBUG, category, "Store '" + info.getPath() + "': got key '" + KEY_NULL_VALUE + "' with value 'null'.", LOG_GET_LOCATION);
        info.getValueIfSet(KEY_INT_1);
        Iterator events = this.getAppender().getEvents().iterator();
        InfoTestBase.assertEvent((LoggingEvent)((LoggingEvent)events.next()), (Level)Level.DEBUG, (String)category, (String)("Store '" + info.getPath() + "': key '" + KEY_INT_1 + "' is present."), (String)LOG_GET_LOCATION);
        InfoTestBase.assertEvent((LoggingEvent)((LoggingEvent)events.next()), (Level)Level.DEBUG, (String)category, (String)("Store '" + info.getPath() + "': got key '" + KEY_INT_1 + "' with value '" + VALUE_INT_1 + "'."), (String)LOG_GET_LOCATION);
        Assert.assertFalse((boolean)events.hasNext());
        this.getAppender().clear();
        info.getValueIfNonNull(KEY_INT_1);
        events = this.getAppender().getEvents().iterator();
        InfoTestBase.assertEvent((LoggingEvent)((LoggingEvent)events.next()), (Level)Level.DEBUG, (String)category, (String)("Store '" + info.getPath() + "': key '" + KEY_INT_1 + "' is present."), (String)LOG_GET_LOCATION);
        InfoTestBase.assertEvent((LoggingEvent)((LoggingEvent)events.next()), (Level)Level.DEBUG, (String)category, (String)("Store '" + info.getPath() + "': got key '" + KEY_INT_1 + "' with value '" + VALUE_INT_1 + "'."), (String)LOG_GET_LOCATION);
        Assert.assertFalse((boolean)events.hasNext());
        this.getAppender().clear();
        info.getValueIfInstanceOf(KEY_INT_1, Integer.class);
        events = this.getAppender().getEvents().iterator();
        InfoTestBase.assertEvent((LoggingEvent)((LoggingEvent)events.next()), (Level)Level.DEBUG, (String)category, (String)("Store '" + info.getPath() + "': key '" + KEY_INT_1 + "' is present."), (String)LOG_GET_LOCATION);
        InfoTestBase.assertEvent((LoggingEvent)((LoggingEvent)events.next()), (Level)Level.DEBUG, (String)category, (String)("Store '" + info.getPath() + "': got key '" + KEY_INT_1 + "' with value '" + VALUE_INT_1 + "'."), (String)LOG_GET_LOCATION);
        Assert.assertFalse((boolean)events.hasNext());
        this.getAppender().clear();
        info.getValueIfNonNullInstanceOf(KEY_INT_1, Integer.class);
        events = this.getAppender().getEvents().iterator();
        InfoTestBase.assertEvent((LoggingEvent)((LoggingEvent)events.next()), (Level)Level.DEBUG, (String)category, (String)("Store '" + info.getPath() + "': key '" + KEY_INT_1 + "' is present."), (String)LOG_GET_LOCATION);
        InfoTestBase.assertEvent((LoggingEvent)((LoggingEvent)events.next()), (Level)Level.DEBUG, (String)category, (String)("Store '" + info.getPath() + "': got key '" + KEY_INT_1 + "' with value '" + VALUE_INT_1 + "'."), (String)LOG_GET_LOCATION);
        Assert.assertFalse((boolean)events.hasNext());
        this.getAppender().clear();
        InfoTestBase.setLevel((String)category, (Level)Level.OFF);
    }

    protected void readWrite(ReadWriteInfo info, String name, String path) throws Exception {
        String category = info.getClass().getName();
        InfoTestBase.setLevel((String)category, (Level)Level.OFF);
        this.getAppender().clear();
        info.setValue(KEY_INT_1, (Object)VALUE_INT_1);
        Assert.assertSame((Object)VALUE_INT_1, (Object)info.getValue(KEY_INT_1));
        try {
            info.setValue(null, (Object)VALUE_INT_1);
            Assert.fail();
        }
        catch (InfoRuntimeException ex) {
            Assert.assertEquals((String)ex.getDetail(), (Object)MSG_NULL_KEY, (Object)ex.getI18NBoundMessage());
        }
        info.setValue(KEY_NULL_VALUE, null);
        Assert.assertNull((Object)info.getValue(KEY_NULL_VALUE));
        this.read((ReadInfo)info, name, path);
        info.setValueIfUnset(KEY_INT_2, (Object)VALUE_INT_2);
        Assert.assertSame((Object)VALUE_INT_2, (Object)info.getValue(KEY_INT_2));
        try {
            info.setValueIfUnset(null, (Object)VALUE_INT_1);
            Assert.fail();
        }
        catch (InfoRuntimeException ex) {
            Assert.assertEquals((String)ex.getDetail(), (Object)MSG_NULL_KEY, (Object)ex.getI18NBoundMessage());
        }
        try {
            info.setValueIfUnset(KEY_INT_1, (Object)VALUE_INT_2);
            Assert.fail();
        }
        catch (InfoException ex) {
            Assert.assertEquals((String)ex.getDetail(), (Object)MSG_VALUE_EXISTS, (Object)ex.getI18NBoundMessage());
        }
        info.removeValue(KEY_NULL_VALUE);
        info.setValueIfUnset(KEY_NULL_VALUE, null);
        Assert.assertNull((Object)info.getValue(KEY_NULL_VALUE));
        info.setValue(KEY_INT_2, (Object)VALUE_INT_2);
        info.removeValue(KEY_INT_2);
        Assert.assertFalse((boolean)info.contains(KEY_INT_2));
        info.removeValue(KEY_UNSET_VALUE);
        try {
            info.removeValue(null);
            Assert.fail();
        }
        catch (InfoRuntimeException ex) {
            Assert.assertEquals((String)ex.getDetail(), (Object)MSG_NULL_KEY, (Object)ex.getI18NBoundMessage());
        }
        info.setValue(KEY_INT_2, (Object)VALUE_INT_2);
        info.removeValueIfSet(KEY_INT_2);
        Assert.assertFalse((boolean)info.contains(KEY_INT_2));
        try {
            info.removeValueIfSet(null);
            Assert.fail();
        }
        catch (InfoRuntimeException ex) {
            Assert.assertEquals((String)ex.getDetail(), (Object)MSG_NULL_KEY, (Object)ex.getI18NBoundMessage());
        }
        try {
            info.removeValueIfSet(KEY_UNSET_VALUE);
        }
        catch (InfoException ex) {
            Assert.assertEquals((String)ex.getDetail(), (Object)MSG_MISSING_VALUE, (Object)ex.getI18NBoundMessage());
        }
        this.assertNoEvents();
        InfoTestBase.setLevel((String)category, (Level)Level.DEBUG);
        info.setValue(KEY_INT_1, (Object)VALUE_INT_1);
        this.assertSingleEvent(Level.DEBUG, category, "Store '" + info.getPath() + "': set key '" + KEY_INT_1 + "' to value '" + VALUE_INT_1 + "'.", LOG_SET_LOCATION);
        info.removeValue(KEY_INT_1);
        this.assertSingleEvent(Level.DEBUG, category, "Store '" + info.getPath() + "': removed key '" + KEY_INT_1 + "'.", LOG_SET_LOCATION);
        info.setValueIfUnset(KEY_INT_2, (Object)VALUE_INT_2);
        Iterator events = this.getAppender().getEvents().iterator();
        InfoTestBase.assertEvent((LoggingEvent)((LoggingEvent)events.next()), (Level)Level.DEBUG, (String)category, (String)("Store '" + info.getPath() + "': key '" + KEY_INT_2 + "' is absent."), (String)LOG_GET_LOCATION);
        InfoTestBase.assertEvent((LoggingEvent)((LoggingEvent)events.next()), (Level)Level.DEBUG, (String)category, (String)("Store '" + info.getPath() + "': set key '" + KEY_INT_2 + "' to value '" + VALUE_INT_2 + "'."), (String)LOG_SET_LOCATION);
        Assert.assertFalse((boolean)events.hasNext());
        this.getAppender().clear();
        info.removeValueIfSet(KEY_INT_2);
        events = this.getAppender().getEvents().iterator();
        InfoTestBase.assertEvent((LoggingEvent)((LoggingEvent)events.next()), (Level)Level.DEBUG, (String)category, (String)("Store '" + info.getPath() + "': key '" + KEY_INT_2 + "' is present."), (String)LOG_GET_LOCATION);
        InfoTestBase.assertEvent((LoggingEvent)((LoggingEvent)events.next()), (Level)Level.DEBUG, (String)category, (String)("Store '" + info.getPath() + "': removed key '" + KEY_INT_2 + "'."), (String)LOG_SET_LOCATION);
        Assert.assertFalse((boolean)events.hasNext());
        this.getAppender().clear();
    }
}

