/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors.security;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.regex.Pattern;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.UnrecognizedOptionException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.marketcetera.core.ClassVersion;
import org.marketcetera.ors.security.ORSAdminCLI;
import org.marketcetera.ors.security.ORSLoginModuleTest;
import org.marketcetera.ors.security.SimpleUser;
import org.marketcetera.persist.EntityExistsException;
import org.marketcetera.persist.PersistTestBase;
import org.marketcetera.util.except.I18NException;
import org.marketcetera.util.log.SLF4JLoggerProxy;

@ClassVersion(value="$Id: ORSCLITest.java 16154 2012-07-14 16:34:05Z colin $")
public class ORSCLITest
extends PersistTestBase {
    private static final String ENCODING = "UTF-8";
    private static ORSAdminCLI instance;
    private static ByteArrayOutputStream bOut;
    private static PrintStream pOut;
    private static ByteArrayOutputStream bErr;
    private static PrintStream pErr;

    @BeforeClass
    public static void setup() throws Exception {
        if (pOut == null) {
            pOut = new PrintStream((OutputStream)bOut, false, ENCODING);
        }
        if (pErr == null) {
            pErr = new PrintStream((OutputStream)bErr, false, ENCODING);
        }
        try {
            instance = new ORSAdminCLI(pOut, pErr){

                protected String[] getConfigurations() {
                    return ORSLoginModuleTest.getSpringFiles();
                }

                protected char[] readPasswordFromConsole(String message) {
                    return null;
                }
            };
        }
        catch (Exception e) {
            SLF4JLoggerProxy.error(ORSCLITest.class, (Throwable)e);
            throw e;
        }
    }

    @Test
    public void parsingFailures() throws Exception {
        ORSCLITest.runCLI(UnrecognizedOptionException.class, "-b");
        ORSCLITest.runCLI(MissingOptionException.class, new String[0]);
        ORSCLITest.runCLI(MissingOptionException.class, "--listUsers");
        ORSCLITest.runCLI(MissingOptionException.class, "-u", "name");
        ORSCLITest.runCLI(MissingArgumentException.class, "-u", "--listUsers");
        ORSCLITest.runCLI(MissingArgumentException.class, "-u", "name", "-p", "--listUsers");
        ORSCLITest.runCLI(MissingArgumentException.class, "-u", "name", "--listUsers", "-n");
        ORSCLITest.runCLI(MissingArgumentException.class, "-u", "name", "--listUsers", "-w");
        ORSCLITest.runCLI(MissingArgumentException.class, "-u", "name", "--listUsers", "-s");
        ORSCLITest.runCLI(MissingArgumentException.class, "-u", "name", "--listUsers", "-a");
        ORSCLITest.runCLI(I18NException.class, "-u", "name", "--addUser", "-n", "name", "-w", "pass");
        ORSCLITest.runCLI(I18NException.class, "-u", "name", "-p", "pass", "--addUser", "-w", "pass");
        ORSCLITest.runCLI(I18NException.class, "-u", "name", "-p", "pass", "--addUser", "-n", "name");
        ORSCLITest.runCLI(I18NException.class, "-u", "name", "--deleteUser", "-n", "name");
        ORSCLITest.runCLI(I18NException.class, "-u", "name", "-p", "pass", "--deleteUser");
        ORSCLITest.runCLI(I18NException.class, "-u", "name", "--restoreUser", "-n", "name");
        ORSCLITest.runCLI(I18NException.class, "-u", "name", "-p", "pass", "--restoreUser");
        ORSCLITest.runCLI(I18NException.class, "-u", "name", "--listUsers");
        ORSCLITest.runCLI(I18NException.class, "-u", "name", "--changePassword", "-w", "pass");
        ORSCLITest.runCLI(I18NException.class, "-u", "name", "-p", "pass", "--changePassword");
        ORSCLITest.runCLI(I18NException.class, "-u", "name", "--changeSuperuser", "-n", "name", "-s", "y");
        ORSCLITest.runCLI(I18NException.class, "-u", "name", "-p", "pass", "--changeSuperuser", "-s", "y");
        ORSCLITest.runCLI(I18NException.class, "-u", "name", "-p", "pass", "--changeSuperuser", "-n", "name");
    }

    @Test
    public void commands() throws Exception {
        SimpleUser admin = new SimpleUser();
        admin.setName("admin");
        String password = "admin";
        admin.setPassword("admin".toCharArray());
        admin.setSuperuser(true);
        admin.save();
        ORSCLITest.runCLI("-u", admin.getName(), "-p", "admin", "--listUsers");
        ORSCLITest.matchOut("^\\s*admin \\[sa\\]\\s*$");
        ORSCLITest.runCLI(EntityExistsException.class, "-u", admin.getName(), "-p", "admin", "--addUser", "-n", "admin", "-w", "pssst");
        ORSCLITest.matchOut("^$");
        ORSCLITest.runCLI("-u", admin.getName(), "-p", "admin", "--addUser", "-n", "blah", "-w", "meh", "-s", "n");
        ORSCLITest.matchOut("^[\\p{L}\\s]*'blah'[\\p{L}\\s]*$");
        ORSCLITest.runCLI("-u", admin.getName(), "-p", "admin", "--listUsers");
        ORSCLITest.matchOut("^\\s*admin \\[sa\\]\\s*blah \\[a\\]\\s*$");
        ORSCLITest.runCLI("-u", "blah", "-p", "meh", "--listUsers");
        ORSCLITest.matchOut("^\\s*admin \\[sa\\]\\s*blah \\[a\\]\\s*$");
        ORSCLITest.runCLI("-u", "blah", "-p", "meh", "--listUsers", "-n", "*dm*");
        ORSCLITest.matchOut("^\\s*admin \\[sa\\]\\s*$");
        ORSCLITest.runCLI("-u", "blah", "-p", "meh", "--listUsers", "-n", "?la?");
        ORSCLITest.matchOut("^\\s*blah \\[a\\]\\s*$");
        ORSCLITest.runCLI("-u", "blah", "-p", "meh", "--listUsers", "-n", "*a*");
        ORSCLITest.matchOut("^\\s*admin \\[sa\\]\\s*blah \\[a\\]\\s*$");
        ORSCLITest.runCLI(I18NException.class, "-u", "wah", "-p", "meh", "--listUsers");
        ORSCLITest.matchOut("^$");
        ORSCLITest.runCLI(I18NException.class, "-u", "blah", "-p", "wha?", "--listUsers");
        ORSCLITest.matchOut("^$");
        ORSCLITest.runCLI("-u", "blah", "-p", "meh", "--changePassword", "-w", "mgh");
        ORSCLITest.matchOut("[\\p{L}\\s]*'blah'[\\p{L}\\s]*");
        ORSCLITest.runCLI("-u", "blah", "-p", "mgh", "--listUsers");
        ORSCLITest.matchOut("^\\s*admin \\[sa\\]\\s*blah \\[a\\]\\s*$");
        ORSCLITest.runCLI("-u", "blah", "-p", "mgh", "--changePassword", "-w", "ugh", "n", "blah");
        ORSCLITest.matchOut("[\\p{L}\\s]*'blah'[\\p{L}\\s]*");
        ORSCLITest.runCLI("-u", "blah", "-p", "ugh", "--listUsers");
        ORSCLITest.matchOut("^\\s*admin \\[sa\\]\\s*blah \\[a\\]\\s*$");
        ORSCLITest.runCLI(I18NException.class, "-u", "blah", "-p", "ugh", "--changePassword", "-w", "meh", "-n", "admin");
        ORSCLITest.matchOut("^$");
        ORSCLITest.runCLI("-u", "admin", "-p", "admin", "--changePassword", "-w", "meh", "-n", "blah");
        ORSCLITest.matchOut("[\\p{L}\\s]*'blah'[\\p{L}\\s]*");
        ORSCLITest.runCLI("-u", "blah", "-p", "meh", "--listUsers");
        ORSCLITest.matchOut("^\\s*admin \\[sa\\]\\s*blah \\[a\\]\\s*$");
        ORSCLITest.runCLI(I18NException.class, "-u", "blah", "-p", "meh", "--deleteUser", "-n", "admin");
        ORSCLITest.matchOut("^$");
        ORSCLITest.runCLI("-u", "admin", "-p", "admin", "--deleteUser", "-n", "blah");
        ORSCLITest.matchOut("[\\p{L}\\s]*'blah'[\\p{L}\\s]*");
        ORSCLITest.runCLI(I18NException.class, "-u", "blah", "-p", "meh", "--listUsers");
        ORSCLITest.matchOut("^$");
        ORSCLITest.runCLI("-u", "admin", "-p", "admin", "--listUsers", "-a", "y");
        ORSCLITest.matchOut("^\\s*admin \\[s\\]\\s*$");
        ORSCLITest.runCLI("-u", "admin", "-p", "admin", "--listUsers", "-a", "n");
        ORSCLITest.matchOut("^\\s*blah\\s*$");
        ORSCLITest.runCLI("-u", "admin", "-p", "admin", "--listUsers", "-a", "x");
        ORSCLITest.matchOut("^\\s*blah\\s*$");
        ORSCLITest.runCLI("-u", "admin", "-p", "admin", "--listUsers");
        ORSCLITest.matchOut("^\\s*admin \\[sa\\]\\s*blah\\s*$");
        ORSCLITest.runCLI("-u", "admin", "-p", "admin", "--listUsers", "-a", "y");
        ORSCLITest.matchOut("^\\s*admin \\[s\\]\\s*$");
        ORSCLITest.runCLI("-u", "admin", "-p", "admin", "--listUsers", "-a", " y");
        ORSCLITest.matchOut("^\\s*admin \\[s\\]\\s*$");
        ORSCLITest.runCLI(I18NException.class, "-u", "admin", "-p", "wrong", "--changePassword", "-w", "ugh");
        ORSCLITest.matchOut("^$");
        ORSCLITest.runCLI("-u", "admin", "-p", "admin", "--changePassword", "-w", "ugh");
        ORSCLITest.matchOut("[\\p{L}\\s]*'admin'[\\p{L}\\s]*");
        ORSCLITest.runCLI("-u", "admin", "-p", "ugh", "--listUsers", "-a", "y");
        ORSCLITest.matchOut("^\\s*admin \\[s\\]\\s*$");
        ORSCLITest.runCLI(I18NException.class, "-u", "admin", "-p", "ugh", "--deleteUser", "-n", "admin");
        ORSCLITest.matchOut("^$");
        ORSCLITest.runCLI(I18NException.class, "-u", "admin", "-p", "ugh", "--restoreUser", "-n", "admin");
        ORSCLITest.matchOut("^$");
        ORSCLITest.runCLI(I18NException.class, "-u", "admin", "-p", "ugh", "--changeSuperuser", "-n", "admin", "-s", "n");
        ORSCLITest.matchOut("^$");
        ORSCLITest.runCLI(I18NException.class, "-u", "admin", "-p", "ugh", "--changePassword", "-w", "ugh", "-n", "who");
        ORSCLITest.matchOut("^$");
        ORSCLITest.runCLI(I18NException.class, "-u", "admin", "-p", "ugh", "--changePassword", "-w", "ugh", "-n", "blah");
        ORSCLITest.matchOut("^$");
        ORSCLITest.runCLI(I18NException.class, "-u", "admin", "-p", "ugh", "--changeSuperuser", "-n", "blah", "-s", "y");
        ORSCLITest.matchOut("^$");
        ORSCLITest.runCLI("-u", admin.getName(), "-p", "ugh", "--addUser", "-n", "\u0393\u0395\u0399\u0391 \u03a3\u039f\u03a5", "-w", "Hello Spr\u00e5k \u0393\u0395\u0399\u0391 \u03a3\u039f\u03a5 \u0645\u0646\u0632\u0644 \u3055\u3088\u3046\u306a\u3089 \ud800\udc88 \ud800\udc89 \ud834\udd1e", "-s", " y");
        ORSCLITest.matchOut("^[\\p{L}\\s]*'\u0393\u0395\u0399\u0391 \u03a3\u039f\u03a5'[\\p{L}\\s]*$");
        ORSCLITest.runCLI("-u", admin.getName(), "-p", "ugh", "--listUsers", "-a", "y");
        ORSCLITest.matchOut("^\\s*admin \\[s\\]\\s*\u0393\u0395\u0399\u0391 \u03a3\u039f\u03a5 \\[s\\]\\s*$");
        ORSCLITest.runCLI("-u", "\u0393\u0395\u0399\u0391 \u03a3\u039f\u03a5", "-p", "Hello Spr\u00e5k \u0393\u0395\u0399\u0391 \u03a3\u039f\u03a5 \u0645\u0646\u0632\u0644 \u3055\u3088\u3046\u306a\u3089 \ud800\udc88 \ud800\udc89 \ud834\udd1e", "--listUsers", "-a", "y");
        ORSCLITest.matchOut("^\\s*admin \\[s\\]\\s*\u0393\u0395\u0399\u0391 \u03a3\u039f\u03a5 \\[s\\]\\s*$");
        ORSCLITest.runCLI("-u", "admin", "-p", "ugh", "--restoreUser", "-n", "blah");
        ORSCLITest.matchOut("[\\p{L}\\s]*'blah'[\\p{L}\\s]*");
        ORSCLITest.runCLI("-u", "admin", "-p", "ugh", "--changeSuperuser", "-n", "blah", "-s", "y");
        ORSCLITest.matchOut("[\\p{L}\\s]*'blah'[\\p{L}\\s]*");
        ORSCLITest.runCLI("-u", "admin", "-p", "ugh", "--listUsers", "-a", "y");
        ORSCLITest.matchOut("^\\s*admin \\[s\\]\\s*blah \\[s\\]\\s*\u0393\u0395\u0399\u0391 \u03a3\u039f\u03a5 \\[s\\]\\s*$");
        ORSCLITest.runCLI(I18NException.class, "-u", "\u0393\u0395\u0399\u0391 \u03a3\u039f\u03a5", "-p", "Hello Spr\u00e5k \u0393\u0395\u0399\u0391 \u03a3\u039f\u03a5 \u0645\u0646\u0632\u0644 \u3055\u3088\u3046\u306a\u3089 \ud800\udc88 \ud800\udc89 \ud834\udd1e", "--deleteUser", "-n", "blah");
        ORSCLITest.matchOut("^$");
    }

    static void matchOut(String regex) throws Exception {
        ORSCLITest.matchStream(regex, bOut);
    }

    static void matchErr(String regex) throws Exception {
        ORSCLITest.matchStream(regex, bErr);
    }

    static void matchStream(String regex, ByteArrayOutputStream baos) throws Exception {
        String str = baos.toString(ENCODING);
        Assert.assertTrue((String)(str + "~" + regex), (boolean)Pattern.matches(regex, str));
    }

    static void runCLI(String ... args) throws Exception {
        ORSCLITest.runCLI(null, args);
    }

    static void runCLI(Class<? extends Exception> expectedFailure, String ... args) throws Exception {
        bOut.reset();
        bErr.reset();
        try {
            instance.parseAndRun(args);
            pOut.flush();
            pErr.flush();
            Assert.assertNull(expectedFailure);
            ORSCLITest.matchErr("^$");
        }
        catch (Exception e) {
            Assert.assertNotNull((String)e.toString(), expectedFailure);
            Assert.assertTrue((String)e.toString(), (boolean)expectedFailure.isInstance(e));
            String err = bErr.toString(ENCODING);
            Assert.assertTrue((String)(e.getLocalizedMessage() + " in " + err), (err.indexOf(e.getLocalizedMessage()) >= 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)err, (err.indexOf("orsadmin") >= 0 ? 1 : 0) != 0);
        }
    }

    static {
        bOut = new ByteArrayOutputStream();
        bErr = new ByteArrayOutputStream();
    }
}

