/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors.security;

import com.sun.security.auth.UserPrincipal;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.log4j.Level;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.marketcetera.core.ClassVersion;
import org.marketcetera.ors.security.Messages;
import org.marketcetera.ors.security.ORSLoginModule;
import org.marketcetera.ors.security.SimpleUser;
import org.marketcetera.persist.PersistTestBase;
import org.marketcetera.util.test.TestCaseBase;

@ClassVersion(value="$Id: ORSLoginModuleTest.java 16154 2012-07-14 16:34:05Z colin $")
public class ORSLoginModuleTest
extends TestCaseBase {
    private static SimpleUser user;
    private static char[] password;
    private static boolean doNotHandleCallbacks;
    private static IOException callbackException;
    private LoginContext loginContext;

    @Test
    public void loginTest() throws Exception {
        ORSLoginModuleTest.setLevel((String)ORSLoginModule.class.getName(), (Level)Level.INFO);
        this.attemptLogin(null, password, AccountNotFoundException.class, Messages.EMPTY_USERNAME.getText());
        this.attemptLogin("", password, AccountNotFoundException.class, Messages.EMPTY_USERNAME.getText());
        String u = ORSLoginModuleTest.randomString();
        this.attemptLogin(u, password, AccountNotFoundException.class, Messages.USER_LOGIN_ERROR.getText());
        this.assertLastEvent(Level.WARN, ORSLoginModule.class.getName(), Messages.USER_LOGIN_ERROR_LOG.getText((Object)u), ORSLoginModule.class.getName());
        this.attemptLogin(user.getName(), null, FailedLoginException.class, Messages.USER_LOGIN_ERROR.getText());
        this.assertLastEvent(Level.WARN, ORSLoginModule.class.getName(), Messages.USER_LOGIN_ERROR_LOG.getText((Object)user.getName()), ORSLoginModule.class.getName());
        this.attemptLogin(user.getName(), "".toCharArray(), FailedLoginException.class, Messages.USER_LOGIN_ERROR.getText());
        this.assertLastEvent(Level.WARN, ORSLoginModule.class.getName(), Messages.USER_LOGIN_ERROR_LOG.getText((Object)user.getName()), ORSLoginModule.class.getName());
        this.attemptLogin(user.getName(), ORSLoginModuleTest.randomString().toCharArray(), FailedLoginException.class, Messages.USER_LOGIN_ERROR.getText());
        this.assertLastEvent(Level.WARN, ORSLoginModule.class.getName(), Messages.USER_LOGIN_ERROR_LOG.getText((Object)user.getName()), ORSLoginModule.class.getName());
        this.attemptLogin(user.getName(), password, null, null);
        this.assertLastEvent(Level.INFO, ORSLoginModule.class.getName(), Messages.USER_LOGIN_LOG.getText((Object)user.getName()), ORSLoginModule.class.getName());
        this.loginContext.logout();
        Assert.assertTrue((boolean)this.loginContext.getSubject().getPrincipals().isEmpty());
        this.assertLastEvent(Level.INFO, ORSLoginModule.class.getName(), Messages.USER_LOGOUT_LOG.getText((Object)user.getName()), ORSLoginModule.class.getName());
    }

    @Test
    public void unsupportedCallback() throws Exception {
        doNotHandleCallbacks = true;
        UnsupportedCallbackException uce = new UnsupportedCallbackException(new NameCallback(Messages.PROMPT_USERNAME.getText()));
        LoginException ex = this.attemptLogin(user.getName(), password, LoginException.class, uce.getMessage());
        Assert.assertNotNull((Object)ex.getCause());
        Assert.assertTrue((boolean)(ex.getCause() instanceof UnsupportedCallbackException));
        Callback callback = ((UnsupportedCallbackException)ex.getCause()).getCallback();
        Assert.assertNotNull((Object)callback);
        Assert.assertTrue((String)callback.getClass().toString(), (boolean)(callback instanceof NameCallback));
        Assert.assertEquals((Object)Messages.PROMPT_USERNAME.getText(), (Object)((NameCallback)callback).getPrompt());
    }

    @Test
    public void callbackIOFailure() throws Exception {
        callbackException = new IOException("ioeoeoe");
        LoginException ex = this.attemptLogin(user.getName(), password, LoginException.class, callbackException.getMessage());
        Assert.assertNotNull((Object)ex.getCause());
        Assert.assertTrue((boolean)(ex.getCause() instanceof IOException));
        Assert.assertSame((Object)callbackException, (Object)ex.getCause());
    }

    @BeforeClass
    public static void setup() throws Exception {
        ORSLoginModuleTest.springSetup();
        user = new SimpleUser();
        user.setName(ORSLoginModuleTest.randomString());
        password = ORSLoginModuleTest.randomString().toCharArray();
        user.setPassword(password);
        user.save();
        Configuration.setConfiguration(new MockConfiguration());
    }

    @AfterClass
    public static void cleanup() throws Exception {
        user.delete();
        user = null;
    }

    @After
    public void reset() throws Exception {
        doNotHandleCallbacks = false;
        callbackException = null;
    }

    public static void springSetup() throws Exception {
        PersistTestBase.springSetup((String[])ORSLoginModuleTest.getSpringFiles());
    }

    static String[] getSpringFiles() {
        return new String[]{"file:" + DIR_ROOT + File.separator + "conf" + File.separator + "persist_tests.xml"};
    }

    private static String randomString() {
        return PersistTestBase.randomString();
    }

    private LoginException attemptLogin(String name, char[] password, Class<? extends LoginException> failure, String failureMsg) throws Exception {
        MockCallbackHandler ch = null;
        this.loginContext = null;
        try {
            ch = new MockCallbackHandler(name, password);
            this.loginContext = new LoginContext("ors_test", ch);
            this.loginContext.login();
            Assert.assertNull((String)("Expected failure:" + failure + failureMsg), failure);
            Assert.assertTrue((String)this.loginContext.getSubject().getPrincipals().toString(), (boolean)this.loginContext.getSubject().getPrincipals().contains(new UserPrincipal(user.getName())));
        }
        catch (LoginException e) {
            Assert.assertNotNull((String)("Unexpected failure:" + e), failure);
            Assert.assertTrue((String)("Expected:" + failure + ":Actual:" + e.getClass().getName() + e.toString()), (boolean)failure.isInstance(e));
            if (failureMsg != null) {
                Assert.assertEquals((Object)failureMsg, (Object)e.getMessage());
            }
            Assert.assertNotNull((Object)this.loginContext);
            if (this.loginContext.getSubject() != null && this.loginContext.getSubject().getPrincipals() != null) {
                Assert.assertFalse((String)this.loginContext.getSubject().getPrincipals().toString(), (boolean)this.loginContext.getSubject().getPrincipals().contains(new UserPrincipal(user.getName())));
            }
            Assert.assertEquals((long)2L, (long)ch.getNumCallbacks());
            if (callbackException == null && !doNotHandleCallbacks) {
                Assert.assertEquals((Object)Messages.PROMPT_USERNAME.getText(), (Object)ch.getNamePrompt());
                Assert.assertEquals((Object)Messages.PROMPT_PASSWORD.getText(), (Object)ch.getPasswordPrompt());
                Assert.assertNull((Object)ch.getDefaultName());
            }
            return e;
        }
        return null;
    }

    static {
        doNotHandleCallbacks = false;
        callbackException = null;
    }

    private static class MockConfiguration
    extends Configuration {
        private MockConfiguration() {
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            return new AppConfigurationEntry[]{new AppConfigurationEntry(ORSLoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, new HashMap())};
        }
    }

    private static class MockCallbackHandler
    implements CallbackHandler {
        private int numCallbacks;
        private String namePrompt;
        private String defaultName;
        private String nameValue;
        private String passwordPrompt;
        private char[] passwordValue;

        MockCallbackHandler(String nameValue, char[] passwordValue) {
            this.nameValue = nameValue;
            this.passwordValue = passwordValue;
        }

        public String getNamePrompt() {
            return this.namePrompt;
        }

        public String getPasswordPrompt() {
            return this.passwordPrompt;
        }

        public String getDefaultName() {
            return this.defaultName;
        }

        public int getNumCallbacks() {
            return this.numCallbacks;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            if (callbacks == null) {
                return;
            }
            this.numCallbacks = callbacks.length;
            for (Callback c : callbacks) {
                if (doNotHandleCallbacks) {
                    throw new UnsupportedCallbackException(c);
                }
                if (callbackException != null) {
                    throw callbackException;
                }
                if (c instanceof NameCallback) {
                    NameCallback nc = (NameCallback)c;
                    this.namePrompt = nc.getPrompt();
                    this.defaultName = nc.getName();
                    nc.setName(this.nameValue);
                    continue;
                }
                if (c instanceof PasswordCallback) {
                    PasswordCallback pc = (PasswordCallback)c;
                    this.passwordPrompt = pc.getPrompt();
                    pc.setPassword(this.passwordValue);
                    continue;
                }
                throw new UnsupportedCallbackException(c);
            }
        }
    }
}

