/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors.security;

import java.util.List;
import java.util.Properties;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.marketcetera.core.ClassVersion;
import org.marketcetera.core.Util;
import org.marketcetera.ors.security.Messages;
import org.marketcetera.ors.security.MultiSimpleUserQuery;
import org.marketcetera.ors.security.ORSLoginModuleTest;
import org.marketcetera.ors.security.SimpleUser;
import org.marketcetera.ors.security.SingleSimpleUserQuery;
import org.marketcetera.persist.EntityBase;
import org.marketcetera.persist.MultiQueryFilterTestHelper;
import org.marketcetera.persist.MultipleEntityQuery;
import org.marketcetera.persist.NDEntityTestBase;
import org.marketcetera.persist.ValidationException;
import org.marketcetera.util.log.I18NMessage;

@ClassVersion(value="$Id: SimpleUserTest.java 16154 2012-07-14 16:34:05Z colin $")
public class SimpleUserTest
extends NDEntityTestBase<SimpleUser, SimpleUser> {
    @Test
    public void nameAndPassword() throws Exception {
        SimpleUser u = new SimpleUser();
        this.doNamePasswordTests(u);
        u.validate();
        u.save();
        Assert.assertTrue((boolean)u.isPasswordSet());
        u.setName(null);
        this.doNamePasswordTests(u);
        u.validate();
        u.save();
        u.delete();
    }

    @Test
    public void userProperties() throws Exception {
        SimpleUser u = new SimpleUser();
        String name = "colin-" + System.nanoTime();
        u.setName(name);
        u.setPassword("password".toCharArray());
        u.setUserData((String)null);
        Assert.assertNull((Object)u.getUserData());
        u.validate();
        u.save();
        u = this.fetchByName(name);
        Assert.assertNull((Object)u.getUserData());
        u.delete();
        u = new SimpleUser();
        u.setName(name);
        u.setPassword("password".toCharArray());
        u.setUserData("");
        Assert.assertEquals((Object)"", (Object)u.getUserData());
        u.validate();
        u.save();
        u = this.fetchByName(name);
        Assert.assertEquals((Object)"", (Object)u.getUserData());
        u.delete();
        Properties properties = new Properties();
        properties.setProperty("key1", "value1");
        properties.setProperty("key2", "value2");
        u = new SimpleUser();
        u.setName(name);
        u.setPassword("password".toCharArray());
        u.setUserData(Util.propertiesToString((Properties)properties));
        Assert.assertEquals((Object)properties, (Object)Util.propertiesFromString((String)u.getUserData()));
        u.validate();
        u.save();
        u = this.fetchByName(name);
        u.delete();
    }

    @Test
    public void superuser() throws Exception {
        SimpleUser u = new SimpleUser();
        String name = "TESTUSER";
        u.setName("TESTUSER");
        Assert.assertFalse((boolean)u.isSuperuser());
        u.setSuperuser(true);
        Assert.assertTrue((boolean)u.isSuperuser());
        this.save(u);
        u = this.fetchByName("TESTUSER");
        Assert.assertTrue((boolean)u.isSuperuser());
        u.setSuperuser(false);
        this.save(u);
        u = this.fetchByName("TESTUSER");
        Assert.assertFalse((boolean)u.isSuperuser());
        u.delete();
    }

    @Test
    public void active() throws Exception {
        SimpleUser u = new SimpleUser();
        String name = "TESTUSER";
        u.setName("TESTUSER");
        Assert.assertTrue((boolean)u.isActive());
        u.setActive(false);
        Assert.assertFalse((boolean)u.isActive());
        this.save(u);
        u = this.fetchByName("TESTUSER");
        Assert.assertFalse((boolean)u.isActive());
        u.setActive(true);
        this.save(u);
        u = this.fetchByName("TESTUSER");
        Assert.assertTrue((boolean)u.isActive());
        u.delete();
    }

    private void doNamePasswordTests(SimpleUser u) throws Exception {
        SimpleUserTest.assertValidateAndSaveFailure(u, (I18NMessage)org.marketcetera.persist.Messages.UNSPECIFIED_NAME_ATTRIBUTE, new Object[0]);
        try {
            u.setPassword(SimpleUserTest.randomString().toCharArray());
        }
        catch (ValidationException e) {
            Assert.assertEquals((Object)org.marketcetera.persist.Messages.UNSPECIFIED_NAME_ATTRIBUTE, (Object)e.getI18NBoundMessage());
        }
        u.setName(SimpleUserTest.randomString());
        Assert.assertFalse((boolean)u.isPasswordSet());
        SimpleUserTest.assertValidateAndSaveFailure(u, (I18NMessage)Messages.EMPTY_PASSWORD, new Object[0]);
        u.setPassword(SimpleUserTest.randomString().toCharArray());
        Assert.assertTrue((boolean)u.isPasswordSet());
        try {
            u.setPassword(SimpleUserTest.randomString().toCharArray());
        }
        catch (ValidationException ex) {
            Assert.assertEquals((Object)Messages.CANNOT_SET_PASSWORD, (Object)ex.getI18NBoundMessage().getMessage());
            Assert.assertArrayEquals((Object[])new Object[]{u.getName()}, (Object[])ex.getI18NBoundMessage().getParams());
        }
        u.setName(SimpleUserTest.randomString());
        Assert.assertFalse((boolean)u.isPasswordSet());
        SimpleUserTest.assertValidateAndSaveFailure(u, (I18NMessage)Messages.EMPTY_PASSWORD, new Object[0]);
        u.setPassword(SimpleUserTest.randomString().toCharArray());
        Assert.assertTrue((boolean)u.isPasswordSet());
    }

    @Test
    public void validateAndChangePassword() throws Exception {
        SimpleUser u = new SimpleUser();
        u.validatePassword(null);
        u.validatePassword("".toCharArray());
        u.validatePassword(SimpleUserTest.randomString().toCharArray());
        char[] pass = this.doValidateChangePassTests(u);
        u.save();
        u.validatePassword(pass);
        SimpleUser fetched = this.fetchByID(u.getId());
        this.assertEntityEquals((EntityBase)u, (EntityBase)fetched);
        fetched.validatePassword(pass);
        pass = this.doValidateChangePassTests(u);
        u.save();
        u.validatePassword(pass);
        fetched = this.fetchByID(u.getId());
        this.assertEntityEquals((EntityBase)u, (EntityBase)fetched);
        fetched.validatePassword(pass);
    }

    private char[] doValidateChangePassTests(SimpleUser u) throws ValidationException {
        String pass = SimpleUserTest.randomString();
        u.setName(SimpleUserTest.randomString());
        u.validatePassword(null);
        u.validatePassword("".toCharArray());
        u.validatePassword(pass.toCharArray());
        u.setPassword(pass.toCharArray());
        SimpleUserTest.assertPasswordValidateFailure(u, null, (I18NMessage)Messages.EMPTY_PASSWORD);
        SimpleUserTest.assertPasswordValidateFailure(u, "".toCharArray(), (I18NMessage)Messages.EMPTY_PASSWORD);
        SimpleUserTest.assertPasswordValidateFailure(u, SimpleUserTest.randomString().toCharArray(), (I18NMessage)Messages.INVALID_PASSWORD);
        SimpleUserTest.assertChangePasswordFailure(u, SimpleUserTest.randomString().toCharArray(), SimpleUserTest.randomString().toCharArray(), (I18NMessage)Messages.INVALID_PASSWORD);
        u.validatePassword(pass.toCharArray());
        SimpleUserTest.assertChangePasswordFailure(u, pass.toCharArray(), null, (I18NMessage)Messages.EMPTY_PASSWORD);
        SimpleUserTest.assertChangePasswordFailure(u, pass.toCharArray(), "".toCharArray(), (I18NMessage)Messages.EMPTY_PASSWORD);
        char[] newPass = SimpleUserTest.randomString().toCharArray();
        u.changePassword(pass.toCharArray(), newPass);
        u.validatePassword(newPass);
        u.setName(SimpleUserTest.randomString());
        u.changePassword(SimpleUserTest.randomString().toCharArray(), newPass);
        u.validatePassword(newPass);
        return newPass;
    }

    private static void assertPasswordValidateFailure(SimpleUser u, char[] password, I18NMessage msg) {
        try {
            u.validatePassword(password);
            Assert.fail((String)"Password validation should fail");
        }
        catch (ValidationException e) {
            Assert.assertEquals((Object)msg, (Object)e.getI18NBoundMessage());
        }
    }

    private static void assertChangePasswordFailure(SimpleUser u, char[] oldPassword, char[] newPassword, I18NMessage msg) {
        try {
            u.changePassword(oldPassword, newPassword);
            Assert.fail((String)"Password validation should fail");
        }
        catch (ValidationException e) {
            Assert.assertEquals((Object)msg, (Object)e.getI18NBoundMessage());
        }
    }

    private static void assertValidateAndSaveFailure(SimpleUser u, I18NMessage expectedMsg, Object ... params) throws Exception {
        try {
            u.validate();
            Assert.fail((String)"Validation should fail");
        }
        catch (ValidationException ex) {
            Assert.assertEquals((Object)expectedMsg, (Object)ex.getI18NBoundMessage().getMessage());
            Assert.assertArrayEquals((Object[])params, (Object[])ex.getI18NBoundMessage().getParams());
        }
        try {
            u.save();
            Assert.fail((String)"Save should fail");
        }
        catch (ValidationException ex) {
            Assert.assertEquals((Object)expectedMsg, (Object)ex.getI18NBoundMessage().getMessage());
            Assert.assertArrayEquals((Object[])params, (Object[])ex.getI18NBoundMessage().getParams());
        }
    }

    protected SimpleUser fetchByName(String name) throws Exception {
        return (SimpleUser)new SingleSimpleUserQuery(name).fetch();
    }

    protected boolean fetchExistsByName(String name) throws Exception {
        return new SingleSimpleUserQuery(name).exists();
    }

    protected SimpleUser fetchSummaryByName(String name) throws Exception {
        return (SimpleUser)new SingleSimpleUserQuery(name).fetchSummary();
    }

    protected void save(SimpleUser simpleUser) throws Exception {
        if (!simpleUser.isPasswordSet()) {
            simpleUser.setPassword(SimpleUserTest.randomString().toCharArray());
        }
        simpleUser.save();
    }

    protected void delete(SimpleUser simpleUser) throws Exception {
        simpleUser.delete();
    }

    protected void deleteAll() throws Exception {
        MultiSimpleUserQuery.all().delete();
    }

    protected SimpleUser fetchByID(long id) throws Exception {
        return (SimpleUser)new SingleSimpleUserQuery(id).fetch();
    }

    protected boolean fetchExistsByID(long id) throws Exception {
        return new SingleSimpleUserQuery(id).exists();
    }

    protected SimpleUser fetchSummaryByID(long id) throws Exception {
        return (SimpleUser)new SingleSimpleUserQuery(id).fetchSummary();
    }

    protected List<SimpleUser> fetchSummaryQuery(MultipleEntityQuery query) throws Exception {
        return ((MultiSimpleUserQuery)query).fetch();
    }

    protected List<SimpleUser> fetchQuery(MultipleEntityQuery query) throws Exception {
        return ((MultiSimpleUserQuery)query).fetch();
    }

    protected MultipleEntityQuery getAllQuery() throws Exception {
        return MultiSimpleUserQuery.all();
    }

    protected SimpleUser createEmpty() throws Exception {
        return new SimpleUser();
    }

    protected Class<SimpleUser> getEntityClass() {
        return SimpleUser.class;
    }

    protected Class<? extends MultipleEntityQuery> getMultiQueryClass() {
        return MultiSimpleUserQuery.class;
    }

    protected List<MultiQueryFilterTestHelper<SimpleUser, SimpleUser>> getFilterTestHelpers() throws Exception {
        List l = super.getFilterTestHelpers();
        l.add(this.booleanFilterHelper("active", "activeFilter"));
        return l;
    }

    protected String getUserFriendlyName() {
        return Messages.SIMPLE_USER_NAME.getText();
    }

    @BeforeClass
    public static void setup() throws Exception {
        ORSLoginModuleTest.springSetup();
    }
}

