/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors.ws;

import java.io.Serializable;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.client.IncompatibleComponentsException;
import org.marketcetera.core.ApplicationVersion;
import org.marketcetera.core.Util;
import org.marketcetera.module.ExpectedFailure;
import org.marketcetera.ors.ws.DBAuthenticator;
import org.marketcetera.ors.ws.Messages;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage2P;
import org.marketcetera.util.log.I18NBoundMessage3P;
import org.marketcetera.util.test.TestCaseBase;
import org.marketcetera.util.ws.stateless.StatelessClientContext;

public class DBAuthenticatorTest
extends TestCaseBase {
    @Test
    public void basics() {
        Assert.assertFalse((boolean)DBAuthenticator.compatibleVersions(null, (String)"x"));
        Assert.assertFalse((boolean)DBAuthenticator.compatibleVersions((String)"x", null));
        Assert.assertFalse((boolean)DBAuthenticator.compatibleVersions((String)"x", (String)"y"));
        Assert.assertFalse((boolean)"No Version".equals("x"));
        Assert.assertTrue((boolean)DBAuthenticator.compatibleVersions((String)"x", (String)"x"));
        Assert.assertTrue((boolean)DBAuthenticator.compatibleVersions((String)"x", (String)"No Version"));
        Assert.assertFalse((boolean)DBAuthenticator.compatibleApp(null));
        Assert.assertFalse((boolean)DBAuthenticator.compatibleApp((String)""));
        Assert.assertFalse((boolean)DBAuthenticator.compatibleApp((String)"x"));
        Assert.assertTrue((boolean)DBAuthenticator.compatibleApp((String)"Client"));
    }

    @Test
    public void shouldAllowFailures() throws Exception {
        StatelessClientContext ctx = new StatelessClientContext();
        DBAuthenticatorTest.shouldAllowFailure((I18NBoundMessage)new I18NBoundMessage2P(Messages.APP_MISMATCH, null, null), ctx, null, null);
        ctx.setAppId(Util.getAppId((String)"", (String)ApplicationVersion.getVersion()));
        DBAuthenticatorTest.shouldAllowFailure((I18NBoundMessage)new I18NBoundMessage2P(Messages.APP_MISMATCH, null, null), ctx, null, null);
        ctx.setAppId(Util.getAppId((String)"x", (String)ApplicationVersion.getVersion()));
        DBAuthenticatorTest.shouldAllowFailure((I18NBoundMessage)new I18NBoundMessage2P(Messages.APP_MISMATCH, (Serializable)((Object)"x"), null), ctx, null, null);
        ctx.setAppId(Util.getAppId((String)"Client", (String)""));
        DBAuthenticatorTest.shouldAllowFailure((I18NBoundMessage)new I18NBoundMessage3P(Messages.VERSION_MISMATCH, null, (Serializable)((Object)ApplicationVersion.getVersion()), null), ctx, null, null);
        ctx.setAppId(Util.getAppId((String)"Client", (String)"x"));
        DBAuthenticatorTest.shouldAllowFailure((I18NBoundMessage)new I18NBoundMessage3P(Messages.VERSION_MISMATCH, (Serializable)((Object)"x"), (Serializable)((Object)ApplicationVersion.getVersion()), null), ctx, null, null);
        ctx.setAppId(Util.getAppId((String)"Client", (String)ApplicationVersion.getVersion()));
        Assert.assertFalse((boolean)new DBAuthenticator().shouldAllow(ctx, "x", null));
    }

    private static void shouldAllowFailure(I18NBoundMessage inMessage, final StatelessClientContext inContext, final String inUsername, final char[] inPassword) throws Exception {
        new ExpectedFailure<IncompatibleComponentsException>(inMessage){

            protected void run() throws Exception {
                new DBAuthenticator().shouldAllow(inContext, inUsername, inPassword);
            }
        };
    }
}

