/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors;

import org.marketcetera.core.IDFactory;
import org.marketcetera.core.NoMoreIDsException;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: LongIDFactory.java 16154 2012-07-14 16:34:05Z colin $")
public class LongIDFactory {
    public static final long LOCAL_ID_COUNT = 1000L;
    private final IDFactory mBlockFactory;
    private long mBlockID;
    private long mLocalID = 0L;

    public LongIDFactory(IDFactory blockFactory) {
        this.mBlockFactory = blockFactory;
        this.mLocalID = 999L;
    }

    public IDFactory getBlockFactory() {
        return this.mBlockFactory;
    }

    private void getNextBlock() throws NoMoreIDsException {
        this.mBlockID = Long.parseLong(this.getBlockFactory().getNext()) * 1000L;
        this.mLocalID = 0L;
    }

    public synchronized long getNext() throws NoMoreIDsException {
        ++this.mLocalID;
        if (this.mLocalID == 1000L) {
            this.getNextBlock();
        }
        return this.mBlockID + this.mLocalID;
    }
}

