/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors;

import com.google.common.collect.Multimaps;
import com.google.common.collect.TreeMultimap;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.marketcetera.ors.Messages;
import org.marketcetera.util.file.CloseableRegistry;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.unicode.UnicodeFileReader;
import org.springframework.beans.factory.InitializingBean;

@ClassVersion(value="$Id: OptionRootUnderlyingMap.java 16154 2012-07-14 16:34:05Z colin $")
public class OptionRootUnderlyingMap
implements InitializingBean {
    private volatile Map<String, String> mRootToUnderlying;
    private volatile Map<String, Collection<String>> mUnderlyingToRoots;
    private volatile String[] mIncludeTypes = new String[]{"EU", "EL"};
    private volatile String mFilename;
    private static volatile OptionRootUnderlyingMap sInstance;
    private static final int ROOT_START_IDX = 0;
    private static final int ROOT_END_IDX = 6;
    private static final int UNDERLYING_START_IDX = 7;
    private static final int UNDERLYING_END_IDX = 13;
    private static final int TYPE_START_IDX = 80;
    private static final int TYPE_END_IDX = 82;

    public OptionRootUnderlyingMap() {
        sInstance = this;
    }

    public String getUnderlying(String inOptionRoot) {
        if (inOptionRoot == null) {
            return null;
        }
        Map<String, String> map = this.mRootToUnderlying;
        return map == null ? null : map.get(inOptionRoot);
    }

    public Collection<String> getOptionRoots(String inUnderlying) {
        if (inUnderlying == null) {
            return null;
        }
        Map<String, Collection<String>> map = this.mUnderlyingToRoots;
        return map == null ? null : map.get(inUnderlying);
    }

    public void setFilename(String inFilename) {
        this.mFilename = inFilename;
    }

    public void setIncludeTypes(String[] inIncludeTypes) {
        if (inIncludeTypes == null) {
            throw new NullPointerException();
        }
        this.mIncludeTypes = inIncludeTypes;
    }

    public static OptionRootUnderlyingMap getInstance() {
        return sInstance;
    }

    public void afterPropertiesSet() throws Exception {
        this.loadFromFile();
    }

    int getNumOptionRoots() {
        return this.mRootToUnderlying == null ? 0 : this.mRootToUnderlying.size();
    }

    int getNumUnderlyings() {
        return this.mUnderlyingToRoots == null ? 0 : this.mUnderlyingToRoots.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFromFile() {
        String filename = this.mFilename;
        if (filename != null) {
            HashMap<String, String> rootToUnderlying = null;
            TreeMultimap underlyingToRoots = null;
            CloseableRegistry registry = new CloseableRegistry();
            try {
                String line;
                BufferedReader reader = new BufferedReader((Reader)new UnicodeFileReader(filename));
                registry.register((Closeable)reader);
                HashSet<String> includeTypes = new HashSet<String>(Arrays.asList(this.mIncludeTypes));
                rootToUnderlying = new HashMap<String, String>();
                underlyingToRoots = TreeMultimap.create();
                while ((line = reader.readLine()) != null) {
                    String root = this.extract(line, 0, 6);
                    String underlying = this.extract(line, 7, 13);
                    String type = this.extract(line, 80, 82);
                    if (root == null || underlying == null || type == null || !includeTypes.contains(type)) continue;
                    rootToUnderlying.put(root, underlying);
                    underlyingToRoots.put((Object)underlying, (Object)root);
                }
            }
            catch (IOException e) {
                Messages.ORUM_LOG_ERROR_LOADING_FILE.error((Object)this, (Throwable)e, (Object)filename);
            }
            finally {
                registry.close();
            }
            this.mRootToUnderlying = rootToUnderlying == null ? null : Collections.unmodifiableMap(rootToUnderlying);
            this.mUnderlyingToRoots = underlyingToRoots == null ? null : Multimaps.unmodifiableSortedSetMultimap(underlyingToRoots).asMap();
        } else {
            Messages.ORUM_LOG_SKIP_LOAD_FILE.info((Object)this);
        }
    }

    private String extract(String inValue, int inStartIdx, int inEndIdx) {
        if (inStartIdx >= inValue.length()) {
            return null;
        }
        if ((inEndIdx = Math.min(inEndIdx, inValue.length())) <= inStartIdx) {
            return null;
        }
        return inValue.substring(inStartIdx, inEndIdx).trim();
    }
}

