/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors;

import org.marketcetera.ors.OrderInfo;
import org.marketcetera.ors.OrderInfoCache;
import org.marketcetera.trade.OrderID;
import org.marketcetera.trade.UserID;
import org.marketcetera.util.misc.ClassVersion;
import quickfix.Message;

@ClassVersion(value="$Id: OrderInfoBase.java 16154 2012-07-14 16:34:05Z colin $")
public class OrderInfoBase<T extends OrderInfoCache>
implements OrderInfo {
    private final T mCache;
    private final OrderID mOrderID;
    private final OrderID mOrigOrderID;
    private final UserID mActorID;
    private boolean mViewerIDSet;
    private UserID mViewerID;

    public OrderInfoBase(T cache, OrderID orderID, OrderID origOrderID, UserID actorID) {
        this.mCache = cache;
        this.mOrderID = orderID;
        this.mOrigOrderID = origOrderID;
        this.mActorID = actorID;
        if (this.getOrigOrderID() == null) {
            this.setViewerID(this.getActorID());
        }
    }

    protected T getCache() {
        return this.mCache;
    }

    @Override
    public OrderID getOrderID() {
        return this.mOrderID;
    }

    @Override
    public OrderID getOrigOrderID() {
        return this.mOrigOrderID;
    }

    @Override
    public UserID getActorID() {
        return this.mActorID;
    }

    @Override
    public synchronized boolean isViewerIDSet() {
        return this.mViewerIDSet;
    }

    @Override
    public synchronized UserID getViewerID() {
        if (!this.isViewerIDSet()) {
            throw new IllegalStateException();
        }
        return this.mViewerID;
    }

    @Override
    public synchronized void setViewerID(UserID viewerID) {
        this.mViewerIDSet = true;
        this.mViewerID = viewerID;
    }

    @Override
    public void setERPersisted(boolean erPersisted) {
    }

    @Override
    public void setAckExpected(boolean ackExpected) {
    }

    @Override
    public void setAckProcessed(boolean ackProcessed) {
    }

    @Override
    public void setResponseExpected(boolean responseExpected) {
    }

    @Override
    public void setResponseProcessed(boolean responseProcessed) {
    }

    @Override
    public void setMessageProcessed(Message msg) {
    }
}

