/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.log4j.PropertyConfigurator;
import org.marketcetera.client.Service;
import org.marketcetera.client.jms.JmsManager;
import org.marketcetera.client.jms.ReceiveOnlyHandler;
import org.marketcetera.core.ApplicationBase;
import org.marketcetera.core.ApplicationVersion;
import org.marketcetera.ors.LocalIDFactory;
import org.marketcetera.ors.Messages;
import org.marketcetera.ors.QuickFIXApplication;
import org.marketcetera.ors.ReplyPersister;
import org.marketcetera.ors.RequestHandler;
import org.marketcetera.ors.UserManager;
import org.marketcetera.ors.brokers.Broker;
import org.marketcetera.ors.brokers.Brokers;
import org.marketcetera.ors.brokers.Selector;
import org.marketcetera.ors.config.SpringConfig;
import org.marketcetera.ors.history.ReportHistoryServices;
import org.marketcetera.ors.info.SystemInfoImpl;
import org.marketcetera.ors.mbeans.ORSAdmin;
import org.marketcetera.ors.ws.ClientSession;
import org.marketcetera.ors.ws.ClientSessionFactory;
import org.marketcetera.ors.ws.DBAuthenticator;
import org.marketcetera.ors.ws.ServiceImpl;
import org.marketcetera.quickfix.CurrentFIXDataDictionary;
import org.marketcetera.quickfix.FIXDataDictionary;
import org.marketcetera.quickfix.FIXVersion;
import org.marketcetera.quickfix.IQuickFIXSender;
import org.marketcetera.quickfix.QuickFIXSender;
import org.marketcetera.util.auth.StandardAuthentication;
import org.marketcetera.util.except.I18NException;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.quickfix.SpringSessionSettings;
import org.marketcetera.util.spring.SpringUtils;
import org.marketcetera.util.ws.stateful.Authenticator;
import org.marketcetera.util.ws.stateful.Server;
import org.marketcetera.util.ws.stateful.SessionFactory;
import org.marketcetera.util.ws.stateful.SessionManager;
import org.marketcetera.util.ws.stateless.StatelessServiceBase;
import org.quickfixj.jmx.JmxExporter;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.context.support.StaticApplicationContext;
import org.springframework.jms.core.JmsOperations;
import org.springframework.jms.listener.SimpleMessageListenerContainer;
import quickfix.Application;
import quickfix.Connector;
import quickfix.DefaultMessageFactory;
import quickfix.Message;
import quickfix.MessageFactory;
import quickfix.SessionNotFound;
import quickfix.SocketInitiator;
import quickfix.StringField;
import quickfix.UtcTimeStampField;
import quickfix.field.SenderCompID;
import quickfix.field.SendingTime;
import quickfix.field.TargetCompID;

@ClassVersion(value="$Id: OrderRoutingSystem.java 16154 2012-07-14 16:34:05Z colin $")
public class OrderRoutingSystem
extends ApplicationBase {
    private static final Class<?> LOGGER_CATEGORY = OrderRoutingSystem.class;
    private static final String APP_CONTEXT_CFG_BASE = "file:" + CONF_DIR + "properties.xml";
    private static final String TRADE_RECORDER_QUEUE = "trade-recorder";
    private static final String JMX_NAME = "org.marketcetera.ors.mbean:type=ORSAdmin";
    private AbstractApplicationContext mContext;
    private final StandardAuthentication mAuth;
    private final Brokers mBrokers;
    private final QuickFIXApplication mQFApp;
    private SimpleMessageListenerContainer mListener;
    private SocketInitiator mInitiator;
    private final QuickFIXSender qSender;
    private static final AtomicInteger counter = new AtomicInteger(0);

    public OrderRoutingSystem(String[] args) throws Exception {
        this.mAuth = new StandardAuthentication(APP_CONTEXT_CFG_BASE, args);
        if (!this.getAuth().setValues()) {
            this.printUsage((I18NBoundMessage)Messages.APP_MISSING_CREDENTIALS);
        }
        if ((args = this.getAuth().getOtherArgs()).length != 0) {
            this.printUsage((I18NBoundMessage)Messages.APP_NO_ARGS_ALLOWED);
        }
        StaticApplicationContext parentContext = new StaticApplicationContext((ApplicationContext)new FileSystemXmlApplicationContext(APP_CONTEXT_CFG_BASE));
        SpringUtils.addStringBean((GenericApplicationContext)parentContext, (String)"runtimeUsername", (String)this.getAuth().getUser());
        SpringUtils.addStringBean((GenericApplicationContext)parentContext, (String)"runtimePassword", (String)this.getAuth().getPasswordAsString());
        parentContext.refresh();
        this.mContext = new FileSystemXmlApplicationContext(new String[]{"file:" + CONF_DIR + "server.xml"}, (ApplicationContext)parentContext);
        this.mContext.start();
        SystemInfoImpl systemInfo = new SystemInfoImpl();
        SpringConfig cfg = SpringConfig.getSingleton();
        if (cfg == null) {
            throw new I18NException((I18NBoundMessage)Messages.APP_NO_CONFIGURATION);
        }
        cfg.getIDFactory().init();
        JmsManager jmsMgr = new JmsManager(cfg.getIncomingConnectionFactory(), cfg.getOutgoingConnectionFactory());
        ReportHistoryServices historyServices = cfg.getReportHistoryServices();
        systemInfo.setValue("HISTORY_SERVICES", historyServices);
        this.mBrokers = new Brokers(cfg.getBrokers(), historyServices);
        Selector selector = new Selector(this.getBrokers(), cfg.getSelector());
        UserManager userManager = new UserManager();
        ReplyPersister persister = new ReplyPersister(historyServices, cfg.getOrderInfoCache());
        historyServices.init(cfg.getIDFactory(), jmsMgr, persister);
        CurrentFIXDataDictionary.setCurrentFIXDataDictionary((FIXDataDictionary)FIXDataDictionary.initializeDataDictionary((String)FIXVersion.FIX_SYSTEM.getDataDictionaryURL()));
        SessionManager sessionManager = new SessionManager((SessionFactory)new ClientSessionFactory(systemInfo, jmsMgr, userManager), cfg.getServerSessionLife() == -1L ? -1L : cfg.getServerSessionLife() * 1000L);
        userManager.setSessionManager((SessionManager<ClientSession>)sessionManager);
        Server server = new Server(cfg.getServerHost(), cfg.getServerPort(), (Authenticator)new DBAuthenticator(), sessionManager);
        server.publish((StatelessServiceBase)new ServiceImpl((SessionManager<ClientSession>)sessionManager, this.getBrokers(), cfg.getIDFactory(), historyServices), Service.class);
        this.qSender = new QuickFIXSender();
        LocalIDFactory localIdFactory = new LocalIDFactory(cfg.getIDFactory());
        localIdFactory.init();
        RequestHandler handler = new RequestHandler(this.getBrokers(), selector, cfg.getAllowedOrders(), persister, (IQuickFIXSender)this.qSender, userManager, localIdFactory);
        this.mListener = jmsMgr.getIncomingJmsFactory().registerHandlerOEX((ReceiveOnlyHandler)handler, "ors-commands", false);
        this.mQFApp = new QuickFIXApplication(systemInfo, this.getBrokers(), cfg.getSupportedMessages(), persister, (IQuickFIXSender)this.qSender, userManager, (JmsOperations)jmsMgr.getOutgoingJmsFactory().createJmsTemplateX("ors-broker-status", true), null);
        SpringSessionSettings settings = this.getBrokers().getSettings();
        this.mInitiator = new SocketInitiator((Application)this.mQFApp, settings.getQMessageStoreFactory(), settings.getQSettings(), settings.getQLogFactory(), (MessageFactory)new DefaultMessageFactory());
        this.mInitiator.start();
        MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
        new JmxExporter(mbeanServer).export((Connector)this.mInitiator);
        mbeanServer.registerMBean(new ORSAdmin(this.getBrokers(), (IQuickFIXSender)this.qSender, localIdFactory, userManager), new ObjectName(JMX_NAME));
    }

    private void printUsage(I18NBoundMessage message) throws I18NException {
        System.err.println(message.getText());
        System.err.println(Messages.APP_USAGE.getText((Object)OrderRoutingSystem.class.getName()));
        System.err.println(Messages.APP_AUTH_OPTIONS.getText());
        System.err.println();
        this.getAuth().printUsage(System.err);
        throw new I18NException(message);
    }

    synchronized void stop() {
        Brokers brokers = this.getBrokers();
        for (Broker broker : brokers.getBrokers()) {
            if (broker.getSpringBroker().getFixLogoutRequired()) {
                SLF4JLoggerProxy.debug(OrderRoutingSystem.class, (String)"Broker {} requires FIX logout", (Object[])new Object[]{broker.getBrokerID()});
                Message logout = broker.getFIXMessageFactory().createMessage("5");
                logout.getHeader().setField((StringField)new SenderCompID((String)broker.getSpringBroker().getDescriptor().getDictionary().get("SenderCompID")));
                logout.getHeader().setField((StringField)new TargetCompID((String)broker.getSpringBroker().getDescriptor().getDictionary().get("TargetCompID")));
                logout.getHeader().setField((UtcTimeStampField)new SendingTime(new Date()));
                logout.toString();
                try {
                    SLF4JLoggerProxy.debug(OrderRoutingSystem.class, (String)"Sending logout message {} to broker {}", (Object[])new Object[]{logout, broker.getBrokerID()});
                    this.qSender.sendToTarget(logout, broker.getSessionID());
                }
                catch (SessionNotFound e) {
                    SLF4JLoggerProxy.warn(OrderRoutingSystem.class, (Throwable)e, (String)"Unable to logout from {}", (Object[])new Object[]{broker.getBrokerID()});
                }
                continue;
            }
            SLF4JLoggerProxy.debug(OrderRoutingSystem.class, (String)"Broker {} does not require FIX logout", (Object[])new Object[]{broker.getBrokerID()});
        }
        if (this.mInitiator != null) {
            this.mInitiator.stop();
            this.mInitiator = null;
        }
        if (this.mListener != null) {
            this.mListener.shutdown();
            this.mListener = null;
        }
        if (this.mContext != null) {
            this.mContext.close();
            this.mContext = null;
        }
    }

    StandardAuthentication getAuth() {
        return this.mAuth;
    }

    Brokers getBrokers() {
        return this.mBrokers;
    }

    public static void main(String[] args) {
        OrderRoutingSystem ors;
        PropertyConfigurator.configureAndWatch((String)(ApplicationBase.CONF_DIR + "log4j" + File.separator + "server.properties"), (long)20000L);
        Messages.APP_COPYRIGHT.info(LOGGER_CATEGORY);
        Messages.APP_VERSION_BUILD.info(LOGGER_CATEGORY, (Object)ApplicationVersion.getVersion(), (Object)ApplicationVersion.getBuildNumber());
        Messages.APP_START.info(LOGGER_CATEGORY);
        try {
            ors = new OrderRoutingSystem(args);
        }
        catch (Throwable t) {
            try {
                Messages.APP_STOP_ERROR.error(LOGGER_CATEGORY, t);
            }
            catch (Throwable t2) {
                System.err.println("Reporting failed");
                System.err.println("Reporting failure");
                t2.printStackTrace();
                System.err.println("Original failure");
                t.printStackTrace();
            }
            return;
        }
        Messages.APP_STARTED.info(LOGGER_CATEGORY);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                ors.stop();
                Messages.APP_STOP.info((Object)LOGGER_CATEGORY);
            }
        });
        try {
            ors.startWaitingForever();
        }
        catch (Throwable t) {
            try {
                Messages.APP_STOP_ERROR.error(LOGGER_CATEGORY, t);
            }
            catch (Throwable t2) {
                System.err.println("Reporting failed");
                System.err.println("Reporting failure");
                t2.printStackTrace();
                System.err.println("Original failure");
                t.printStackTrace();
            }
            return;
        }
        Messages.APP_STOP_SUCCESS.info(LOGGER_CATEGORY);
    }
}

