/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors;

import java.util.Collection;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicLong;
import org.marketcetera.ors.Messages;
import org.marketcetera.ors.Principals;
import org.marketcetera.ors.ReplyPersister;
import org.marketcetera.ors.UserManager;
import org.marketcetera.ors.brokers.Broker;
import org.marketcetera.ors.brokers.Brokers;
import org.marketcetera.ors.config.LogonAction;
import org.marketcetera.ors.config.LogoutAction;
import org.marketcetera.ors.filters.MessageFilter;
import org.marketcetera.ors.info.RequestInfoImpl;
import org.marketcetera.ors.info.SessionInfoImpl;
import org.marketcetera.ors.info.SystemInfo;
import org.marketcetera.quickfix.FIXMessageUtil;
import org.marketcetera.quickfix.IQuickFIXSender;
import org.marketcetera.trade.BrokerID;
import org.marketcetera.trade.FIXConverter;
import org.marketcetera.trade.MessageCreationException;
import org.marketcetera.trade.Originator;
import org.marketcetera.trade.TradeMessage;
import org.marketcetera.trade.UserID;
import org.marketcetera.util.except.I18NException;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.marketcetera.util.misc.ClassVersion;
import org.springframework.jms.core.JmsOperations;
import quickfix.Application;
import quickfix.DoNotSend;
import quickfix.FieldNotFound;
import quickfix.Message;
import quickfix.SessionID;
import quickfix.SessionNotFound;
import quickfix.UnsupportedMessageType;

@ClassVersion(value="$Id: QuickFIXApplication.java 16154 2012-07-14 16:34:05Z colin $")
public class QuickFIXApplication
implements Application {
    private static final String HEARTBEAT_CATEGORY = QuickFIXApplication.class.getName() + ".HEARTBEATS";
    private final SystemInfo mSystemInfo;
    private final Brokers mBrokers;
    private final MessageFilter mSupportedMessages;
    private final ReplyPersister mPersister;
    private final IQuickFIXSender mSender;
    private final UserManager mUserManager;
    private final JmsOperations mToClientStatus;
    private final JmsOperations mToTradeRecorder;
    private final BlockingDeque<MessagePackage> messagesToProcess = new LinkedBlockingDeque<MessagePackage>();

    public QuickFIXApplication(SystemInfo systemInfo, Brokers brokers, MessageFilter supportedMessages, ReplyPersister persister, IQuickFIXSender sender, UserManager userManager, JmsOperations toClientStatus, JmsOperations toTradeRecorder) {
        this.mSystemInfo = systemInfo;
        this.mBrokers = brokers;
        this.mSupportedMessages = supportedMessages;
        this.mPersister = persister;
        this.mSender = sender;
        this.mUserManager = userManager;
        this.mToClientStatus = toClientStatus;
        this.mToTradeRecorder = toTradeRecorder;
        new MessageProcessor();
    }

    public SystemInfo getSystemInfo() {
        return this.mSystemInfo;
    }

    public Brokers getBrokers() {
        return this.mBrokers;
    }

    public MessageFilter getSupportedMessages() {
        return this.mSupportedMessages;
    }

    public ReplyPersister getPersister() {
        return this.mPersister;
    }

    public IQuickFIXSender getSender() {
        return this.mSender;
    }

    public UserManager getUserManager() {
        return this.mUserManager;
    }

    public JmsOperations getToClientStatus() {
        return this.mToClientStatus;
    }

    public JmsOperations getToTradeRecorder() {
        return this.mToTradeRecorder;
    }

    private Object getCategory(Message msg) {
        if (FIXMessageUtil.isHeartbeat((Message)msg)) {
            return HEARTBEAT_CATEGORY;
        }
        return this;
    }

    private void updateStatus(Broker b, boolean status) {
        if (b.getLoggedOn() == status) {
            return;
        }
        Messages.QF_SENDING_STATUS.info((Object)this, (Object)status, (Object)b);
        b.setLoggedOn(status);
        if (this.getToClientStatus() == null) {
            return;
        }
        this.getToClientStatus().convertAndSend((Object)b.getStatus());
    }

    private void sendTradeRecord(Message msg) {
        Messages.QF_SENDING_TRADE_RECORD.info(this.getCategory(msg), (Object)msg);
        if (this.getToTradeRecorder() == null) {
            return;
        }
        this.getToTradeRecorder().convertAndSend((Object)msg);
    }

    private void sendToClientTrades(boolean admin, Broker b, Message msg, Originator originator) {
        TradeMessage reply;
        if (this.getUserManager() == null) {
            return;
        }
        Principals principals = admin ? Principals.UNKNOWN : this.getPersister().getPrincipals(msg, false);
        if (originator == Originator.Broker && b.getResponseModifiers() != null) {
            try {
                SessionInfoImpl sessionInfo = new SessionInfoImpl(this.getSystemInfo());
                sessionInfo.setValue("ACTOR_ID", principals.getActorID());
                RequestInfoImpl requestInfo = new RequestInfoImpl(sessionInfo);
                requestInfo.setValue("BROKER", b);
                requestInfo.setValue("BROKER_ID", b.getBrokerID());
                requestInfo.setValue("ORIGINATOR", originator);
                requestInfo.setValue("FIX_MESSAGE_FACTORY", b.getFIXMessageFactory());
                requestInfo.setValue("CURRENT_MESSAGE", msg);
                b.getResponseModifiers().modifyMessage(requestInfo);
                msg = requestInfo.getValueIfInstanceOf("CURRENT_MESSAGE", Message.class);
            }
            catch (I18NException ex) {
                Messages.QF_MODIFICATION_FAILED.error(this.getCategory(msg), (Throwable)ex, (Object)msg, (Object)b.toString());
                return;
            }
        }
        try {
            reply = FIXConverter.fromQMessage((Message)msg, (Originator)originator, (BrokerID)b.getBrokerID(), (UserID)principals.getActorID(), (UserID)principals.getViewerID());
        }
        catch (MessageCreationException ex) {
            Messages.QF_REPORT_FAILED.error(this.getCategory(msg), (Throwable)ex, (Object)msg, (Object)b.toString());
            return;
        }
        this.getPersister().persistReply(reply);
        Messages.QF_SENDING_REPLY.info(this.getCategory(msg), (Object)reply);
        this.getUserManager().convertAndSend(reply);
    }

    public void onCreate(SessionID session) {
    }

    public void onLogon(SessionID session) {
        Broker b = this.getBrokers().getBroker(session);
        this.updateStatus(b, true);
        if (b.getSpringBroker().getLogonActions() != null) {
            for (LogonAction action : b.getSpringBroker().getLogonActions()) {
                try {
                    action.onLogon(b, this.getSender());
                }
                catch (Exception e) {
                    SLF4JLoggerProxy.warn(QuickFIXApplication.class, (Throwable)e);
                }
            }
        }
    }

    public void onLogout(SessionID session) {
        Broker b = this.getBrokers().getBroker(session);
        this.updateStatus(b, false);
        Collection<LogoutAction> logoutActions = b.getSpringBroker().getLogoutActions();
        if (logoutActions != null) {
            for (LogoutAction action : logoutActions) {
                try {
                    action.onLogout(b, this.getSender());
                }
                catch (Exception e) {
                    SLF4JLoggerProxy.warn(QuickFIXApplication.class, (Throwable)e);
                }
            }
        }
    }

    public void toAdmin(Message msg, SessionID session) {
        Broker b = this.getBrokers().getBroker(session);
        Messages.QF_TO_ADMIN.info(this.getCategory(msg), (Object)msg, (Object)b);
        b.logMessage(msg);
        if (b.getModifiers() != null) {
            try {
                RequestInfoImpl requestInfo = new RequestInfoImpl(new SessionInfoImpl(this.getSystemInfo()));
                requestInfo.setValue("BROKER", b);
                requestInfo.setValue("BROKER_ID", b.getBrokerID());
                requestInfo.setValue("FIX_MESSAGE_FACTORY", b.getFIXMessageFactory());
                requestInfo.setValue("CURRENT_MESSAGE", msg);
                b.getModifiers().modifyMessage(requestInfo);
                msg = requestInfo.getValueIfInstanceOf("CURRENT_MESSAGE", Message.class);
            }
            catch (I18NException ex) {
                Messages.QF_MODIFICATION_FAILED.warn(this.getCategory(msg), (Throwable)ex, (Object)msg, (Object)b.toString());
            }
        }
        if (FIXMessageUtil.isReject((Message)msg)) {
            try {
                String msgType = msg.isSetField(35) ? null : msg.getString(372);
                String msgTypeName = b.getFIXDataDictionary().getHumanFieldValue(35, msgType);
                msg.setString(58, Messages.QF_IN_MESSAGE_REJECTED.getText((Object)msgTypeName, (Object)msg.getString(58)));
            }
            catch (FieldNotFound ex) {
                Messages.QF_MODIFICATION_FAILED.warn(this.getCategory(msg), (Throwable)ex, (Object)msg, (Object)b.toString());
            }
            this.sendToClientTrades(true, b, msg, Originator.Server);
        }
    }

    public void fromAdmin(Message msg, SessionID session) {
        this.messagesToProcess.add(new MessagePackage(msg, MessageType.FROM_ADMIN, session));
    }

    public void toApp(Message msg, SessionID session) throws DoNotSend {
        Broker b = this.getBrokers().getBroker(session);
        Messages.QF_TO_APP.info(this.getCategory(msg), (Object)msg, (Object)b);
        b.logMessage(msg);
    }

    public void fromApp(Message msg, SessionID session) throws UnsupportedMessageType, FieldNotFound {
        Broker b = this.getBrokers().getBroker(session);
        Messages.QF_FROM_APP.info(this.getCategory(msg), (Object)msg, (Object)b);
        b.logMessage(msg);
        if (!this.getSupportedMessages().isAccepted(msg)) {
            Messages.QF_DISALLOWED_MESSAGE.info(this.getCategory(msg));
            throw new UnsupportedMessageType();
        }
        this.messagesToProcess.add(new MessagePackage(msg, MessageType.FROM_APP, session));
    }

    @ClassVersion(value="$Id: QuickFIXApplication.java 16154 2012-07-14 16:34:05Z colin $")
    private class MessageProcessor
    implements Runnable {
        private final Thread thread = new Thread((Runnable)this, "QuickFIXApplication Message Processing Tread");

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                block10: while (true) {
                    MessagePackage message = (MessagePackage)QuickFIXApplication.this.messagesToProcess.take();
                    switch (message.getMessageType()) {
                        case FROM_ADMIN: {
                            SessionID session = message.getSessionId();
                            Message msg = message.getMessage();
                            Broker b = QuickFIXApplication.this.getBrokers().getBroker(session);
                            Messages.QF_FROM_ADMIN.info(QuickFIXApplication.this.getCategory(msg), (Object)msg, (Object)b);
                            b.logMessage(msg);
                            QuickFIXApplication.this.sendToClientTrades(true, b, msg, Originator.Broker);
                            continue block10;
                        }
                        case FROM_APP: {
                            SessionID session = message.getSessionId();
                            Message msg = message.getMessage();
                            Broker b = QuickFIXApplication.this.getBrokers().getBroker(session);
                            try {
                                char ordStatus;
                                if (FIXMessageUtil.isTradingSessionStatus((Message)msg)) {
                                    Messages.QF_TRADE_SESSION_STATUS.info(QuickFIXApplication.this.getCategory(msg), (Object)b.getFIXDataDictionary().getHumanFieldValue(340, msg.getString(340)));
                                }
                                QuickFIXApplication.this.sendToClientTrades(false, b, msg, Originator.Broker);
                                if (msg.getHeader().isSetField(128)) {
                                    try {
                                        Message reject = b.getFIXMessageFactory().createSessionReject(msg, 9);
                                        reject.setString(58, Messages.QF_COMP_ID_REJECT.getText((Object)msg.getHeader().getString(128)));
                                        QuickFIXApplication.this.getSender().sendToTarget(reject, session);
                                    }
                                    catch (SessionNotFound ex) {
                                        Messages.QF_COMP_ID_REJECT_FAILED.error(QuickFIXApplication.this.getCategory(msg), (Throwable)ex, (Object)b.toString());
                                    }
                                    continue block10;
                                }
                                if (!FIXMessageUtil.isExecutionReport((Message)msg) || (ordStatus = msg.getChar(39)) != '2' && ordStatus != '1') continue block10;
                                QuickFIXApplication.this.sendTradeRecord(msg);
                            }
                            catch (FieldNotFound e) {
                                SLF4JLoggerProxy.error(QuickFIXApplication.class, (Throwable)e);
                            }
                            continue block10;
                        }
                    }
                    throw new UnsupportedOperationException();
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }

        private MessageProcessor() {
            this.thread.start();
        }
    }

    @ClassVersion(value="$Id: QuickFIXApplication.java 16154 2012-07-14 16:34:05Z colin $")
    private static class MessagePackage {
        private final Message message;
        private final MessageType messageType;
        private final SessionID sessionId;
        private final long id = counter.incrementAndGet();
        private static final AtomicLong counter = new AtomicLong(0L);

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.id ^ this.id >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof MessagePackage)) {
                return false;
            }
            MessagePackage other = (MessagePackage)obj;
            return this.id == other.id;
        }

        private MessagePackage(Message inMessage, MessageType inMessageType, SessionID inSessionId) {
            this.message = inMessage;
            this.messageType = inMessageType;
            this.sessionId = inSessionId;
        }

        private Message getMessage() {
            return this.message;
        }

        private MessageType getMessageType() {
            return this.messageType;
        }

        private SessionID getSessionId() {
            return this.sessionId;
        }
    }

    @ClassVersion(value="$Id: QuickFIXApplication.java 16154 2012-07-14 16:34:05Z colin $")
    private static enum MessageType {
        FROM_ADMIN,
        FROM_APP;

    }
}

