/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors;

import org.marketcetera.ors.Messages;
import org.marketcetera.ors.OrderInfo;
import org.marketcetera.ors.OrderInfoCache;
import org.marketcetera.ors.Principals;
import org.marketcetera.ors.ReportCache;
import org.marketcetera.ors.history.ReportHistoryServices;
import org.marketcetera.ors.history.ReportSavedListener;
import org.marketcetera.persist.PersistenceException;
import org.marketcetera.trade.ExecutionReport;
import org.marketcetera.trade.OrderID;
import org.marketcetera.trade.ReportBase;
import org.marketcetera.trade.TradeMessage;
import org.marketcetera.trade.UserID;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.marketcetera.util.misc.ClassVersion;
import quickfix.FieldNotFound;
import quickfix.Message;

@ClassVersion(value="$Id: ReplyPersister.java 16161 2012-07-16 20:27:32Z colin $")
public class ReplyPersister
implements ReportSavedListener {
    private final ReportHistoryServices mHistoryServices;
    private final OrderInfoCache mCache;

    public ReplyPersister(ReportHistoryServices historyServices, OrderInfoCache cache) {
        this.mHistoryServices = historyServices;
        this.mCache = cache;
    }

    @Override
    public void reportSaved(ReportBase report, boolean status) {
        OrderID orderID = report.getOrderID();
        if (orderID == null) {
            return;
        }
        OrderInfo info = this.getCache().get(orderID);
        if (info == null) {
            return;
        }
        info.setERPersisted(status);
    }

    private ReportHistoryServices getHistoryServices() {
        return this.mHistoryServices;
    }

    private OrderInfoCache getCache() {
        return this.mCache;
    }

    public void persistReply(TradeMessage msg) {
        if (!(msg instanceof ReportBase)) {
            return;
        }
        if (msg instanceof ExecutionReport) {
            ReportCache.INSTANCE.cache((ExecutionReport)msg);
        }
        try {
            this.getHistoryServices().save((ReportBase)msg);
        }
        catch (PersistenceException ex) {
            Messages.RP_PERSIST_ERROR.error((Object)this, (Throwable)ex, (Object)msg);
            return;
        }
    }

    public OrderInfo addOutgoingOrder(Message msg, UserID actorID) {
        OrderID origOrderID;
        OrderID orderID;
        try {
            orderID = new OrderID(msg.getString(11));
        }
        catch (FieldNotFound ex) {
            Messages.RP_ADD_TO_CACHE_FAILED.warn((Object)this, (Throwable)ex, (Object)actorID, (Object)msg);
            return null;
        }
        try {
            origOrderID = new OrderID(msg.getString(41));
        }
        catch (FieldNotFound ex) {
            origOrderID = null;
        }
        return this.getCache().put(orderID, origOrderID, actorID);
    }

    public Principals getPrincipals(Message inMessage, boolean isAck) {
        Principals principals;
        OrderID origOrderID;
        Principals principals2;
        OrderInfo info;
        OrderID orderID;
        try {
            orderID = this.getOrderIDFrom(inMessage, 11);
        }
        catch (FieldNotFound e) {
            SLF4JLoggerProxy.warn(ReplyPersister.class, (Throwable)e, (String)"An error occurred retrieving field {} from {} so the principals cannot be determined", (Object[])new Object[]{11, inMessage});
            return Principals.UNKNOWN;
        }
        if (orderID != null && (info = this.getCache().get(orderID)) != null && (principals2 = this.getPrincipalsFromInfo(inMessage, isAck, info)).getActorID() != null && principals2.getViewerID() != null) {
            return principals2;
        }
        try {
            origOrderID = this.getOrderIDFrom(inMessage, 41);
        }
        catch (FieldNotFound e) {
            SLF4JLoggerProxy.warn(ReplyPersister.class, (Throwable)e, (String)"An error occurred retrieving field {} from {} so the principals cannot be determined", (Object[])new Object[]{41, inMessage});
            return Principals.UNKNOWN;
        }
        if (origOrderID == null) {
            SLF4JLoggerProxy.warn(ReplyPersister.class, (String)"Message {} contains neither ClOrdID (11) nor OrigClOrdID (41) so the principals cannot be determined", (Object[])new Object[]{inMessage});
            return Principals.UNKNOWN;
        }
        info = this.getCache().get(origOrderID);
        if (info != null && (principals = this.getPrincipalsFromInfo(inMessage, isAck, info)).getActorID() != null && principals.getViewerID() != null) {
            return principals;
        }
        SLF4JLoggerProxy.warn(ReplyPersister.class, (String)"Message {} could not be mapped to a known order so the principals cannot be determined", (Object[])new Object[]{inMessage});
        return Principals.UNKNOWN;
    }

    private OrderID getOrderIDFrom(Message inMessage, int inField) throws FieldNotFound {
        if (inMessage.isSetField(inField)) {
            return new OrderID(inMessage.getString(inField));
        }
        return null;
    }

    private Principals getPrincipalsFromInfo(Message inMessage, boolean isAck, OrderInfo inInfo) {
        OrderID orderID = null;
        if (!inInfo.isViewerIDSet()) {
            UserID viewerID;
            orderID = inInfo.getOrigOrderID();
            if (orderID == null) {
                throw new IllegalStateException();
            }
            OrderInfo parentInfo = this.getCache().get(orderID);
            if (parentInfo != null) {
                if (!parentInfo.isViewerIDSet()) {
                    throw new IllegalStateException();
                }
                viewerID = parentInfo.getViewerID();
            } else {
                try {
                    viewerID = this.getHistoryServices().getPrincipals(orderID).getViewerID();
                }
                catch (PersistenceException ex) {
                    Messages.RP_GET_FROM_DB_FAILED.warn((Object)this, (Throwable)ex, (Object)orderID);
                    viewerID = null;
                }
            }
            inInfo.setViewerID(viewerID);
        }
        if (isAck) {
            inInfo.setAckProcessed(true);
        } else {
            inInfo.setResponseProcessed(true);
        }
        inInfo.setMessageProcessed(inMessage);
        return new Principals(inInfo.getActorID(), inInfo.getViewerID());
    }
}

