/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.marketcetera.trade.ExecutionReport;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: ReportCache.java 16154 2012-07-14 16:34:05Z colin $")
public enum ReportCache {
    INSTANCE;

    private final Map<String, ExecutionReport> latestReports = new ConcurrentHashMap<String, ExecutionReport>();

    public ExecutionReport getLatestReportFor(String inOrderId) {
        if (inOrderId == null) {
            return null;
        }
        ExecutionReport report = this.latestReports.get(inOrderId);
        if (report == null) {
            // empty if block
        }
        return report;
    }

    public void cache(ExecutionReport inReport) {
        if (inReport != null && inReport.getOrderID() != null) {
            this.latestReports.put(inReport.getOrderID().getValue(), inReport);
        }
    }

    public void clear() {
        this.latestReports.clear();
    }
}

