/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.concurrent.Callable;
import org.apache.commons.lang.ObjectUtils;
import org.marketcetera.client.jms.OrderEnvelope;
import org.marketcetera.client.jms.ReceiveOnlyHandler;
import org.marketcetera.core.CoreException;
import org.marketcetera.core.IDFactory;
import org.marketcetera.metrics.ConditionsFactory;
import org.marketcetera.metrics.ThreadedMetric;
import org.marketcetera.ors.Messages;
import org.marketcetera.ors.OrderInfo;
import org.marketcetera.ors.Principals;
import org.marketcetera.ors.ReplyPersister;
import org.marketcetera.ors.ReportCache;
import org.marketcetera.ors.UserManager;
import org.marketcetera.ors.brokers.Broker;
import org.marketcetera.ors.brokers.Brokers;
import org.marketcetera.ors.brokers.Selector;
import org.marketcetera.ors.filters.OrderFilter;
import org.marketcetera.ors.info.RequestInfoImpl;
import org.marketcetera.ors.info.SessionInfo;
import org.marketcetera.quickfix.FIXMessageFactory;
import org.marketcetera.quickfix.FIXMessageUtil;
import org.marketcetera.quickfix.FIXVersion;
import org.marketcetera.quickfix.IQuickFIXSender;
import org.marketcetera.trade.BrokerID;
import org.marketcetera.trade.ExecutionReport;
import org.marketcetera.trade.FIXConverter;
import org.marketcetera.trade.FIXOrder;
import org.marketcetera.trade.MessageCreationException;
import org.marketcetera.trade.Order;
import org.marketcetera.trade.OrderBase;
import org.marketcetera.trade.OrderCancel;
import org.marketcetera.trade.OrderReplace;
import org.marketcetera.trade.OrderSingle;
import org.marketcetera.trade.Originator;
import org.marketcetera.trade.TradeMessage;
import org.marketcetera.trade.UserID;
import org.marketcetera.util.except.I18NException;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.quickfix.AnalyzedMessage;
import quickfix.CharField;
import quickfix.ConfigError;
import quickfix.DataDictionary;
import quickfix.DecimalField;
import quickfix.FieldNotFound;
import quickfix.IntField;
import quickfix.Message;
import quickfix.SessionNotFound;
import quickfix.StringField;
import quickfix.UtcTimeStampField;
import quickfix.field.AvgPx;
import quickfix.field.CumQty;
import quickfix.field.CxlRejResponseTo;
import quickfix.field.ExecID;
import quickfix.field.ExecTransType;
import quickfix.field.LastPx;
import quickfix.field.LastShares;
import quickfix.field.LeavesQty;
import quickfix.field.MsgSeqNum;
import quickfix.field.OrdStatus;
import quickfix.field.OrdType;
import quickfix.field.OrderID;
import quickfix.field.OrigClOrdID;
import quickfix.field.Price;
import quickfix.field.SenderCompID;
import quickfix.field.SendingTime;
import quickfix.field.TargetCompID;

@ClassVersion(value="$Id: RequestHandler.java 16154 2012-07-14 16:34:05Z colin $")
public class RequestHandler
implements ReceiveOnlyHandler<OrderEnvelope> {
    private static final String SELF_SENDER_COMP_ID = "ORS";
    private static final String SELF_TARGET_COMP_ID = "ORS Client";
    private static final String SELF_ORDER_ID = "NONE";
    private static final String UNKNOWN_EXEC_ID = "ERROR";
    private static final char SOH = '\u0001';
    private static final char SOH_REPLACE = '|';
    private static final Callable<Boolean> METRIC_CONDITION_RH = ConditionsFactory.createSamplingCondition((int)100, (String)"metc.metrics.ors.rh.sampling.interval");
    private final Brokers mBrokers;
    private final Selector mSelector;
    private final OrderFilter mAllowedOrders;
    private final ReplyPersister mPersister;
    private final IQuickFIXSender mSender;
    private final UserManager mUserManager;
    private final IDFactory mIDFactory;
    private final DataDictionary mDataDictionary;

    public RequestHandler(Brokers brokers, Selector selector, OrderFilter allowedOrders, ReplyPersister persister, IQuickFIXSender sender, UserManager userManager, IDFactory idFactory) throws ConfigError {
        this.mBrokers = brokers;
        this.mSelector = selector;
        this.mAllowedOrders = allowedOrders;
        this.mPersister = persister;
        this.mSender = sender;
        this.mUserManager = userManager;
        this.mIDFactory = idFactory;
        this.mDataDictionary = new DataDictionary(FIXVersion.FIX_SYSTEM.getDataDictionaryURL());
    }

    public Brokers getBrokers() {
        return this.mBrokers;
    }

    public Selector getSelector() {
        return this.mSelector;
    }

    public OrderFilter getAllowedOrders() {
        return this.mAllowedOrders;
    }

    public ReplyPersister getPersister() {
        return this.mPersister;
    }

    public UserManager getUserManager() {
        return this.mUserManager;
    }

    public IQuickFIXSender getSender() {
        return this.mSender;
    }

    public IDFactory getIDFactory() {
        return this.mIDFactory;
    }

    public FIXMessageFactory getMsgFactory() {
        return FIXVersion.FIX_SYSTEM.getMessageFactory();
    }

    public DataDictionary getDataDictionary() {
        return this.mDataDictionary;
    }

    private FIXMessageFactory getBestMsgFactory(Broker b) {
        if (b == null) {
            return this.getMsgFactory();
        }
        return b.getFIXMessageFactory();
    }

    private DataDictionary getBestDataDictionary(Broker b) {
        if (b == null) {
            return this.getDataDictionary();
        }
        return b.getDataDictionary();
    }

    private ExecID getNextExecId() throws CoreException {
        return new ExecID(this.getIDFactory().getNext());
    }

    private static String getOptFieldStr(Message msg, int field) {
        try {
            return msg.getString(field);
        }
        catch (FieldNotFound ex) {
            return null;
        }
    }

    private static void addRequiredFields(Message msg) {
        msg.getHeader().setField((IntField)new MsgSeqNum(0));
        msg.getHeader().setField((StringField)new SenderCompID(SELF_SENDER_COMP_ID));
        msg.getHeader().setField((StringField)new TargetCompID(SELF_TARGET_COMP_ID));
        msg.getHeader().setField((UtcTimeStampField)new SendingTime(new Date()));
        msg.toString();
    }

    private Message createRejection(I18NException ex, Broker b, Order msg) {
        Message qMsgReply;
        boolean orderCancelType;
        if (ex.getI18NBoundMessage() == Messages.RH_UNSUPPORTED_MESSAGE) {
            return this.getBestMsgFactory(b).newBusinessMessageReject(msg.getClass().getName(), 3, ex.getLocalizedDetail().replace('\u0001', '|'));
        }
        Message qMsg = null;
        try {
            qMsg = FIXConverter.toQMessage((FIXMessageFactory)this.getBestMsgFactory(b), (DataDictionary)this.getBestDataDictionary(b), (Order)msg);
        }
        catch (I18NException ex2) {
            Messages.RH_REJ_CONVERSION_FAILED.warn((Object)this, (Throwable)ex2, (Object)msg);
        }
        boolean bl = orderCancelType = FIXMessageUtil.isCancelRequest((Message)qMsg) || FIXMessageUtil.isCancelReplaceRequest((Message)qMsg);
        if (orderCancelType) {
            qMsgReply = this.getBestMsgFactory(b).newOrderCancelRejectEmpty();
            char reason = FIXMessageUtil.isCancelRequest((Message)qMsg) ? (char)'1' : '2';
            qMsgReply.setField((CharField)new CxlRejResponseTo(reason));
        } else {
            qMsgReply = this.getBestMsgFactory(b).newExecutionReportEmpty();
            try {
                qMsgReply.setField((StringField)this.getNextExecId());
            }
            catch (CoreException ex2) {
                Messages.RH_REJ_ID_GENERATION_FAILED.warn((Object)this, (Throwable)ex2);
                qMsgReply.setField((StringField)new ExecID(UNKNOWN_EXEC_ID));
            }
            qMsgReply.setField((DecimalField)new AvgPx(0.0));
            qMsgReply.setField((DecimalField)new CumQty(0.0));
            qMsgReply.setField((DecimalField)new LastShares(0.0));
            qMsgReply.setField((DecimalField)new LastPx(0.0));
            qMsgReply.setField((CharField)new ExecTransType('3'));
        }
        qMsgReply.setField((CharField)new OrdStatus('8'));
        qMsgReply.setString(58, ex.getLocalizedDetail().replace('\u0001', '|'));
        if (qMsg != null) {
            FIXMessageUtil.fillFieldsFromExistingMessage((Message)qMsgReply, (Message)qMsg, (DataDictionary)this.getBestDataDictionary(b), (boolean)false);
        }
        if (!qMsgReply.isSetField(37)) {
            qMsgReply.setField((StringField)new OrderID(SELF_ORDER_ID));
        }
        if (!orderCancelType) {
            try {
                this.getBestMsgFactory(b).getMsgAugmentor().executionReportAugment(qMsgReply);
            }
            catch (FieldNotFound ex2) {
                Messages.RH_REJ_AUGMENTATION_FAILED.warn((Object)this, (Throwable)ex2, (Object)qMsgReply);
            }
        }
        RequestHandler.addRequiredFields(qMsgReply);
        return qMsgReply;
    }

    private Message createExecutionReport(Broker b, Message qMsg) throws CoreException, FieldNotFound {
        AvgPx price;
        String orderID;
        char ordStatus;
        if (FIXMessageUtil.isOrderSingle((Message)qMsg)) {
            ordStatus = 'A';
            orderID = SELF_ORDER_ID;
        } else if (FIXMessageUtil.isCancelReplaceRequest((Message)qMsg)) {
            ordStatus = 'E';
            orderID = RequestHandler.getOptFieldStr(qMsg, 37);
            if (orderID == null) {
                orderID = SELF_ORDER_ID;
            }
        } else if (FIXMessageUtil.isCancelRequest((Message)qMsg)) {
            ordStatus = '6';
            orderID = RequestHandler.getOptFieldStr(qMsg, 37);
            if (orderID == null) {
                orderID = SELF_ORDER_ID;
            }
        } else {
            return null;
        }
        FIXMessageFactory messageFactory = this.getBestMsgFactory(b);
        Message qMsgReply = messageFactory.newExecutionReportEmpty();
        String msgType = "8";
        DataDictionary dict = this.getBestDataDictionary(b);
        String clOrderId = null;
        if (qMsg.isSetField(41)) {
            OrigClOrdID clOrdId = new OrigClOrdID();
            qMsg.getField((StringField)clOrdId);
            clOrderId = clOrdId.getValue();
        }
        ExecutionReport latestMessage = ReportCache.INSTANCE.getLatestReportFor(clOrderId);
        if (dict.isMsgField(msgType, 37)) {
            qMsgReply.setField((StringField)new OrderID(orderID));
        }
        if (dict.isMsgField(msgType, 17)) {
            qMsgReply.setField((StringField)new ExecID(this.getNextExecId().getValue()));
        }
        if (dict.isMsgField(msgType, 39)) {
            qMsgReply.setField((CharField)new OrdStatus(ordStatus));
        }
        if (dict.isMsgField(msgType, 32)) {
            if (latestMessage != null && latestMessage.getLastQuantity() != null) {
                LastShares lastShares = new LastShares(latestMessage.getLastQuantity());
                qMsgReply.setField((DecimalField)lastShares);
            } else {
                qMsgReply.setField((DecimalField)new LastShares(BigDecimal.ZERO));
            }
        }
        if (dict.isMsgField(msgType, 31)) {
            if (latestMessage != null && latestMessage.getLastPrice() != null) {
                LastPx lastPx = new LastPx(latestMessage.getLastPrice());
                qMsgReply.setField((DecimalField)lastPx);
            } else {
                qMsgReply.setField((DecimalField)new LastPx(BigDecimal.ZERO));
            }
        }
        if (dict.isMsgField(msgType, 14)) {
            if (latestMessage != null && latestMessage.getCumulativeQuantity() != null) {
                CumQty cumQty = new CumQty(latestMessage.getCumulativeQuantity());
                qMsgReply.setField((DecimalField)cumQty);
            } else {
                qMsgReply.setField((DecimalField)new CumQty(BigDecimal.ZERO));
            }
        }
        if (dict.isMsgField(msgType, 6)) {
            if (latestMessage != null && latestMessage.getAveragePrice() != null) {
                price = new AvgPx(latestMessage.getAveragePrice());
                qMsgReply.setField((DecimalField)price);
            } else {
                qMsgReply.setField((DecimalField)new AvgPx(BigDecimal.ZERO));
            }
        }
        if (dict.isMsgField(msgType, 151)) {
            if (latestMessage != null && latestMessage.getLeavesQuantity() != null) {
                LeavesQty leavesQty = new LeavesQty(latestMessage.getLeavesQuantity());
                qMsgReply.setField((DecimalField)leavesQty);
            } else {
                qMsgReply.setField((DecimalField)new LeavesQty(BigDecimal.ZERO));
            }
        }
        if (dict.isMsgField(msgType, 40) && latestMessage != null && latestMessage.getOrderType() != null) {
            OrdType ordType = new OrdType(latestMessage.getOrderType().getFIXValue());
            qMsgReply.setField((CharField)ordType);
        }
        if (dict.isMsgField(msgType, 44)) {
            if (latestMessage != null && latestMessage.getPrice() != null) {
                price = new Price(latestMessage.getPrice());
                qMsgReply.setField((DecimalField)price);
            } else {
                qMsgReply.setField((DecimalField)new Price(BigDecimal.ZERO));
            }
        }
        if (dict.isMsgField(msgType, 37) && latestMessage != null && latestMessage.getBrokerOrderID() != null) {
            OrderID brokerOrderID = new OrderID(latestMessage.getBrokerOrderID());
            qMsgReply.setField((StringField)brokerOrderID);
        }
        FIXMessageUtil.fillFieldsFromExistingMessage((Message)qMsgReply, (Message)qMsg, (DataDictionary)this.getBestDataDictionary(b), (boolean)false);
        messageFactory.getMsgAugmentor().executionReportAugment(qMsgReply);
        RequestHandler.addRequiredFields(qMsgReply);
        return qMsgReply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveMessage(OrderEnvelope msgEnv) {
        TradeMessage reply;
        Principals principals;
        Messages.RH_RECEIVED_MESSAGE.info((Object)this, (Object)msgEnv);
        Order msg = null;
        UserID actorID = null;
        BrokerID bID = null;
        Broker b = null;
        Message qMsg = null;
        Message qMsgToSend = null;
        Message qMsgReply = null;
        boolean responseExpected = false;
        OrderInfo orderInfo = null;
        try {
            if (msgEnv == null) {
                throw new I18NException((I18NBoundMessage)Messages.RH_NULL_MESSAGE_ENVELOPE);
            }
            ThreadedMetric.begin((Object[])new Object[]{msgEnv.getOrder() instanceof OrderBase ? ((OrderBase)msgEnv.getOrder()).getOrderID() : null});
            msg = msgEnv.getOrder();
            if (msg == null) {
                throw new I18NException((I18NBoundMessage)Messages.RH_NULL_MESSAGE);
            }
            SessionInfo sessionInfo = this.getUserManager().getSessionInfo(msgEnv.getSessionId());
            if (sessionInfo == null) {
                throw new I18NException((I18NBoundMessage)new I18NBoundMessage1P(Messages.RH_SESSION_EXPIRED, (Serializable)msgEnv.getSessionId()));
            }
            actorID = (UserID)sessionInfo.getValue("ACTOR_ID");
            RequestInfoImpl requestInfo = new RequestInfoImpl(sessionInfo);
            ThreadedMetric.event((String)"requestHandler.sessionInfoObtained", (Object[])new Object[0]);
            if (!(msg instanceof OrderSingle || msg instanceof OrderCancel || msg instanceof OrderReplace || msg instanceof FIXOrder)) {
                throw new I18NException((I18NBoundMessage)Messages.RH_UNSUPPORTED_MESSAGE);
            }
            Order oMsg = msg;
            bID = oMsg.getBrokerID();
            if (bID == null) {
                bID = this.getSelector().chooseBroker(oMsg);
            }
            if (bID == null) {
                throw new I18NException((I18NBoundMessage)Messages.RH_UNKNOWN_BROKER);
            }
            requestInfo.setValue("BROKER_ID", bID);
            b = this.getBrokers().getBroker(bID);
            if (b == null) {
                throw new I18NException((I18NBoundMessage)Messages.RH_UNKNOWN_BROKER_ID);
            }
            requestInfo.setValue("BROKER", b);
            requestInfo.setValue("FIX_MESSAGE_FACTORY", b.getFIXMessageFactory());
            ThreadedMetric.event((String)"requestHandler.brokerSelected", (Object[])new Object[0]);
            try {
                qMsg = FIXConverter.toQMessage((FIXMessageFactory)b.getFIXMessageFactory(), (DataDictionary)b.getDataDictionary(), (Order)oMsg);
            }
            catch (I18NException ex) {
                throw new I18NException((Throwable)ex, (I18NBoundMessage)Messages.RH_CONVERSION_FAILED);
            }
            orderInfo = this.getPersister().addOutgoingOrder(qMsg, actorID);
            b.logMessage(qMsg);
            ThreadedMetric.event((String)"requestHandler.orderConverted", (Object[])new Object[0]);
            if (!b.getLoggedOn()) {
                throw new I18NException((I18NBoundMessage)Messages.RH_UNAVAILABLE_BROKER);
            }
            try {
                this.getAllowedOrders().assertAccepted(qMsg);
            }
            catch (CoreException ex) {
                throw new I18NException((Throwable)ex, (I18NBoundMessage)Messages.RH_ORDER_DISALLOWED);
            }
            ThreadedMetric.event((String)"requestHandler.orderAllowed", (Object[])new Object[0]);
            if (b.getModifiers() != null) {
                requestInfo.setValue("CURRENT_MESSAGE", qMsg);
                try {
                    b.getModifiers().modifyMessage(requestInfo);
                }
                catch (I18NException ex) {
                    throw new I18NException((Throwable)ex, (I18NBoundMessage)Messages.RH_MODIFICATION_FAILED);
                }
                qMsg = requestInfo.getValueIfInstanceOf("CURRENT_MESSAGE", Message.class);
            }
            ThreadedMetric.event((String)"requestHandler.modifiersApplied", (Object[])new Object[0]);
            if (b.getRoutes() != null) {
                try {
                    b.getRoutes().modifyMessage(qMsg, b.getFIXMessageAugmentor());
                }
                catch (I18NException ex) {
                    throw new I18NException((Throwable)ex, (I18NBoundMessage)Messages.RH_ROUTING_FAILED);
                }
            }
            ThreadedMetric.event((String)"requestHandler.orderRoutingApplied", (Object[])new Object[0]);
            if (b.getPreSendModifiers() != null) {
                qMsgToSend = (Message)qMsg.clone();
                requestInfo.setValue("CURRENT_MESSAGE", qMsgToSend);
                try {
                    try {
                        b.getPreSendModifiers().modifyMessage(requestInfo);
                    }
                    catch (I18NException ex) {
                        throw new I18NException((Throwable)ex, (I18NBoundMessage)Messages.RH_PRE_SEND_MODIFICATION_FAILED);
                    }
                    qMsgToSend = requestInfo.getValueIfInstanceOf("CURRENT_MESSAGE", Message.class);
                }
                finally {
                    requestInfo.setValue("CURRENT_MESSAGE", qMsg);
                }
            }
            qMsgToSend = qMsg;
            ThreadedMetric.event((String)"requestHandler.preSendModifiersApplied", (Object[])new Object[0]);
            try {
                this.getSender().sendToTarget(qMsgToSend, b.getSessionID());
            }
            catch (SessionNotFound ex) {
                throw new I18NException((Throwable)ex, (I18NBoundMessage)Messages.RH_UNAVAILABLE_BROKER);
            }
            responseExpected = true;
            ThreadedMetric.event((String)"requestHandler.orderSent", (Object[])new Object[0]);
            try {
                qMsgReply = this.createExecutionReport(b, qMsg);
                if (qMsgReply == null) {
                    Messages.RH_ACK_FAILED_WARN.warn((Object)this, (Object)msg, (Object)qMsg, (Object)b.toString());
                }
            }
            catch (FieldNotFound ex) {
                throw new I18NException((Throwable)ex, (I18NBoundMessage)Messages.RH_ACK_FAILED);
            }
            catch (CoreException ex) {
                throw new I18NException((Throwable)ex, (I18NBoundMessage)Messages.RH_ACK_FAILED);
            }
        }
        catch (I18NException ex) {
            Messages.RH_MESSAGE_PROCESSING_FAILED.error((Object)this, (Throwable)ex, msg, qMsg, qMsgToSend, (Object)ObjectUtils.toString(b, (String)ObjectUtils.toString(bID)));
            qMsgReply = this.createRejection(ex, b, msg);
        }
        finally {
            if (orderInfo != null) {
                orderInfo.setResponseExpected(responseExpected);
            }
        }
        ThreadedMetric.event((String)"requestHandler.replyComposed", (Object[])new Object[0]);
        boolean msgAckExpected = false;
        try {
            if (qMsgReply == null) {
                return;
            }
            if (SLF4JLoggerProxy.isDebugEnabled((Object)this)) {
                Messages.RH_ANALYZED_MESSAGE.debug((Object)this, (Object)new AnalyzedMessage(this.getBestDataDictionary(b), qMsgReply).toString());
            }
            principals = this.getPersister().getPrincipals(qMsgReply, true);
            msgAckExpected = true;
            ThreadedMetric.event((String)"requestHandler.principalsFetched", (Object[])new Object[0]);
        }
        finally {
            if (orderInfo != null) {
                orderInfo.setAckExpected(msgAckExpected);
            }
        }
        try {
            reply = FIXConverter.fromQMessage((Message)qMsgReply, (Originator)Originator.Server, (BrokerID)bID, (UserID)principals.getActorID(), (UserID)principals.getViewerID());
        }
        catch (MessageCreationException ex) {
            Messages.RH_REPORT_FAILED.error((Object)this, (Throwable)ex, (Object)qMsgReply);
            return;
        }
        ThreadedMetric.event((String)"requestHandler.replyConverted", (Object[])new Object[0]);
        this.getPersister().persistReply(reply);
        Messages.RH_SENDING_REPLY.info((Object)this, (Object)reply);
        ThreadedMetric.event((String)"requestHandler.replyPersisted", (Object[])new Object[0]);
        this.getUserManager().convertAndSend(reply);
        ThreadedMetric.end(METRIC_CONDITION_RH, (Object[])new Object[0]);
    }
}

