/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors;

import org.marketcetera.ors.OrderInfoBase;
import org.marketcetera.ors.SimpleOrderInfoCache;
import org.marketcetera.trade.OrderID;
import org.marketcetera.trade.UserID;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: SimpleOrderInfo.java 16154 2012-07-14 16:34:05Z colin $")
public class SimpleOrderInfo
extends OrderInfoBase<SimpleOrderInfoCache> {
    private Boolean mERPersisted;
    private Boolean mAckExpected;
    private Boolean mAckProcessed;
    private Boolean mResponseExpected;
    private Boolean mResponseProcessed;

    public SimpleOrderInfo(SimpleOrderInfoCache cache, OrderID orderID, OrderID origOrderID, UserID actorID) {
        super(cache, orderID, origOrderID, actorID);
    }

    protected synchronized Boolean getERPersisted() {
        return this.mERPersisted;
    }

    protected synchronized Boolean getAckExpected() {
        return this.mAckExpected;
    }

    protected synchronized Boolean getAckProcessed() {
        return this.mAckProcessed;
    }

    protected synchronized Boolean getResponseExpected() {
        return this.mResponseExpected;
    }

    protected synchronized Boolean getResponseProcessed() {
        return this.mResponseProcessed;
    }

    protected synchronized boolean mayRemove() {
        return this.getERPersisted() == Boolean.TRUE || this.getResponseExpected() == Boolean.FALSE && (this.getAckExpected() == Boolean.FALSE || this.getAckExpected() == Boolean.TRUE && this.getAckProcessed() == Boolean.TRUE);
    }

    protected synchronized boolean shouldRemove() {
        return this.mayRemove() && (this.getAckExpected() == Boolean.FALSE || this.getAckExpected() == Boolean.TRUE && this.getAckProcessed() == Boolean.TRUE) && (this.getResponseExpected() == Boolean.FALSE || this.getResponseExpected() == Boolean.TRUE && this.getResponseProcessed() == Boolean.TRUE);
    }

    protected synchronized void removeIfDesired() {
        if (this.shouldRemove()) {
            ((SimpleOrderInfoCache)this.getCache()).remove(this.getOrderID());
        }
    }

    @Override
    public synchronized void setERPersisted(boolean erPersisted) {
        this.mERPersisted = erPersisted;
        this.removeIfDesired();
    }

    @Override
    public synchronized void setAckExpected(boolean ackExpected) {
        this.mAckExpected = ackExpected;
        this.removeIfDesired();
    }

    @Override
    public synchronized void setAckProcessed(boolean ackProcessed) {
        this.mAckProcessed = ackProcessed;
        this.removeIfDesired();
    }

    @Override
    public synchronized void setResponseExpected(boolean responseExpected) {
        this.mResponseExpected = responseExpected;
        this.removeIfDesired();
    }

    @Override
    public synchronized void setResponseProcessed(boolean responseProcessed) {
        this.mResponseProcessed = responseProcessed;
        this.removeIfDesired();
    }
}

