/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.marketcetera.ors.Messages;
import org.marketcetera.ors.OrderInfoCache;
import org.marketcetera.ors.SimpleOrderInfo;
import org.marketcetera.trade.OrderID;
import org.marketcetera.trade.UserID;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: SimpleOrderInfoCache.java 16154 2012-07-14 16:34:05Z colin $")
public class SimpleOrderInfoCache
implements OrderInfoCache {
    private final Map<OrderID, SimpleOrderInfo> mMap = new ConcurrentHashMap<OrderID, SimpleOrderInfo>();

    private Map<OrderID, SimpleOrderInfo> getMap() {
        return this.mMap;
    }

    public void remove(OrderID orderID) {
        this.getMap().remove(orderID);
        Messages.OIM_REMOVED_ENTRY.debug((Object)this, (Object)orderID, (Object)this.getMap().size());
    }

    @Override
    public SimpleOrderInfo put(OrderID orderID, OrderID origOrderID, UserID actorID) {
        SimpleOrderInfo info = new SimpleOrderInfo(this, orderID, origOrderID, actorID);
        this.getMap().put(orderID, info);
        Messages.OIM_ADDED_ENTRY.debug((Object)this, (Object)orderID, (Object)this.getMap().size());
        return info;
    }

    @Override
    public SimpleOrderInfo get(OrderID orderID) {
        return this.getMap().get(orderID);
    }
}

