/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.marketcetera.ors.info.SessionInfo;
import org.marketcetera.ors.security.SimpleUser;
import org.marketcetera.ors.security.SingleSimpleUserQuery;
import org.marketcetera.ors.ws.ClientSession;
import org.marketcetera.persist.PersistenceException;
import org.marketcetera.trade.ReportBase;
import org.marketcetera.trade.TradeMessage;
import org.marketcetera.trade.UserID;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.ws.stateful.SessionHolder;
import org.marketcetera.util.ws.stateful.SessionManager;
import org.marketcetera.util.ws.tags.SessionId;

@ClassVersion(value="$Id: UserManager.java 16154 2012-07-14 16:34:05Z colin $")
public class UserManager {
    private final Map<UserID, Set<ClientSession>> mUserIDMap = new ConcurrentHashMap<UserID, Set<ClientSession>>();
    private final Set<UserID> mRUserIDs = new CopyOnWriteArraySet<UserID>();
    private final Set<UserID> mSUserIDs = new CopyOnWriteArraySet<UserID>();
    private SessionManager<ClientSession> mSessionManager;

    private Map<UserID, Set<ClientSession>> getUserIDMap() {
        return this.mUserIDMap;
    }

    private Set<UserID> getRUserIDs() {
        return this.mRUserIDs;
    }

    private Set<UserID> getSUserIDs() {
        return this.mSUserIDs;
    }

    void setSessionManager(SessionManager<ClientSession> sessionManager) {
        this.mSessionManager = sessionManager;
    }

    public SessionManager<ClientSession> getSessionManager() {
        return this.mSessionManager;
    }

    public synchronized void sync() {
        HashSet<UserID> allUserIDs = new HashSet<UserID>();
        allUserIDs.addAll(this.getSUserIDs());
        allUserIDs.addAll(this.getRUserIDs());
        for (UserID userID : allUserIDs) {
            SimpleUser user = null;
            try {
                user = (SimpleUser)new SingleSimpleUserQuery(userID.getValue()).fetch();
            }
            catch (PersistenceException ex) {
                // empty catch block
            }
            if (user != null && !user.isActive()) {
                user = null;
            }
            this.getSUserIDs().remove(userID);
            this.getRUserIDs().remove(userID);
            if (user != null) {
                if (user.isSuperuser()) {
                    this.getSUserIDs().add(userID);
                    continue;
                }
                this.getRUserIDs().add(userID);
                continue;
            }
            Set<ClientSession> sessions = this.getUserIDMap().get(userID);
            for (ClientSession s : sessions) {
                this.getSessionManager().remove(s.getSessionId());
            }
        }
        this.logStatus();
    }

    public synchronized void addSession(ClientSession session) {
        SimpleUser user = session.getUser();
        UserID userID = user.getUserID();
        Set<ClientSession> sessions = this.getUserIDMap().get(userID);
        if (sessions == null) {
            sessions = new CopyOnWriteArraySet<ClientSession>();
            this.getUserIDMap().put(userID, sessions);
        }
        sessions.add(session);
        if (user.isSuperuser()) {
            this.getRUserIDs().remove(userID);
            this.getSUserIDs().add(userID);
        } else {
            this.getRUserIDs().add(userID);
            this.getSUserIDs().remove(userID);
        }
        this.logStatus();
    }

    public synchronized void removedSession(ClientSession session) {
        UserID userID = session.getUser().getUserID();
        Set<ClientSession> sessions = this.getUserIDMap().get(userID);
        sessions.remove(session);
        if (sessions.size() == 0) {
            this.getUserIDMap().remove(userID);
            this.getSUserIDs().remove(userID);
            this.getRUserIDs().remove(userID);
        }
        this.logStatus();
    }

    public SessionInfo getSessionInfo(SessionId sessionId) {
        SessionHolder holder = this.getSessionManager().get(sessionId);
        if (holder == null) {
            return null;
        }
        return ((ClientSession)holder.getSession()).getSessionInfo();
    }

    public void convertAndSend(TradeMessage msg) {
        Set<ClientSession> sessions;
        UserID viewerID = null;
        if (msg instanceof ReportBase) {
            viewerID = ((ReportBase)msg).getViewerID();
        }
        if (viewerID != null && this.getRUserIDs().contains(viewerID) && (sessions = this.getUserIDMap().get(viewerID)) != null) {
            for (ClientSession s : sessions) {
                s.getReplyTopic().convertAndSend((Object)msg);
            }
        }
        for (UserID userID : this.getSUserIDs()) {
            Set<ClientSession> sessions2 = this.getUserIDMap().get(userID);
            if (sessions2 == null) continue;
            for (ClientSession s : sessions2) {
                s.getReplyTopic().convertAndSend((Object)msg);
            }
        }
    }

    public void logStatus() {
        SLF4JLoggerProxy.debug((Object)this, (String)"User ID map");
        for (Map.Entry<UserID, Set<ClientSession>> entry : this.getUserIDMap().entrySet()) {
            SLF4JLoggerProxy.debug((Object)this, (String)" User ID: {}", (Object[])new Object[]{entry.getKey()});
            for (ClientSession s : entry.getValue()) {
                SLF4JLoggerProxy.debug((Object)this, (String)"  {}", (Object[])new Object[]{s});
            }
        }
        SLF4JLoggerProxy.debug((Object)this, (String)"Non-superusers");
        for (UserID userID : this.getRUserIDs()) {
            SLF4JLoggerProxy.debug((Object)this, (String)" {}", (Object[])new Object[]{userID});
        }
        SLF4JLoggerProxy.debug((Object)this, (String)"Superusers");
        for (UserID userID : this.getSUserIDs()) {
            SLF4JLoggerProxy.debug((Object)this, (String)" {}", (Object[])new Object[]{userID});
        }
    }
}

