/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors.brokers;

import org.marketcetera.client.brokers.BrokerStatus;
import org.marketcetera.ors.brokers.Messages;
import org.marketcetera.ors.brokers.SpringBroker;
import org.marketcetera.ors.filters.MessageModifierManager;
import org.marketcetera.ors.filters.MessageRouteManager;
import org.marketcetera.ors.history.ReportHistoryServices;
import org.marketcetera.quickfix.FIXDataDictionary;
import org.marketcetera.quickfix.FIXMessageFactory;
import org.marketcetera.quickfix.FIXMessageUtil;
import org.marketcetera.quickfix.FIXVersion;
import org.marketcetera.quickfix.messagefactory.FIXMessageAugmentor;
import org.marketcetera.trade.BrokerID;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.quickfix.AnalyzedMessage;
import quickfix.DataDictionary;
import quickfix.Message;
import quickfix.Session;
import quickfix.SessionID;

@ClassVersion(value="$Id: Broker.java 16154 2012-07-14 16:34:05Z colin $")
public class Broker {
    private static final String HEARTBEAT_CATEGORY = Broker.class.getName() + ".HEARTBEATS";
    private final SpringBroker mSpringBroker;
    private final BrokerID mBrokerID;
    private FIXDataDictionary mDataDictionary;
    private boolean mLoggedOn;

    public Broker(SpringBroker springBroker, ReportHistoryServices historyServices) {
        this.mSpringBroker = springBroker;
        this.mBrokerID = new BrokerID(this.getSpringBroker().getId());
    }

    public SpringBroker getSpringBroker() {
        return this.mSpringBroker;
    }

    public BrokerStatus getStatus() {
        return new BrokerStatus(this.getName(), this.getBrokerID(), this.getLoggedOn());
    }

    public String getName() {
        return this.getSpringBroker().getName();
    }

    public BrokerID getBrokerID() {
        return this.mBrokerID;
    }

    public SessionID getSessionID() {
        return this.getSpringBroker().getDescriptor().getQSessionID();
    }

    public Session getSession() {
        return Session.lookupSession((SessionID)this.getSessionID());
    }

    public DataDictionary getDataDictionary() {
        return this.getSession().getDataDictionary();
    }

    public MessageModifierManager getModifiers() {
        return this.getSpringBroker().getModifiers();
    }

    public MessageRouteManager getRoutes() {
        return this.getSpringBroker().getRoutes();
    }

    public MessageModifierManager getPreSendModifiers() {
        return this.getSpringBroker().getPreSendModifiers();
    }

    public MessageModifierManager getResponseModifiers() {
        return this.getSpringBroker().getResponseModifiers();
    }

    public FIXVersion getFIXVersion() {
        return FIXVersion.getFIXVersion((String)this.getSessionID().getBeginString());
    }

    public FIXMessageFactory getFIXMessageFactory() {
        return this.getFIXVersion().getMessageFactory();
    }

    public synchronized FIXDataDictionary getFIXDataDictionary() {
        if (this.mDataDictionary == null) {
            this.mDataDictionary = new FIXDataDictionary(this.getDataDictionary());
        }
        return this.mDataDictionary;
    }

    public FIXMessageAugmentor getFIXMessageAugmentor() {
        return this.getFIXMessageFactory().getMsgAugmentor();
    }

    public synchronized void setLoggedOn(boolean loggedOn) {
        this.mLoggedOn = loggedOn;
    }

    public synchronized boolean getLoggedOn() {
        return this.mLoggedOn;
    }

    public void logMessage(Message msg) {
        Object category;
        Object object = category = FIXMessageUtil.isHeartbeat((Message)msg) ? HEARTBEAT_CATEGORY : this;
        if (SLF4JLoggerProxy.isDebugEnabled((Object)category)) {
            Messages.ANALYZED_MESSAGE.debug(category, (Object)new AnalyzedMessage(this.getDataDictionary(), msg).toString());
        }
    }

    public String toString() {
        return Messages.BROKER_STRING.getText((Object)this.getBrokerID().getValue(), (Object)this.getName(), (Object)this.getSessionID());
    }
}

