/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors.brokers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.marketcetera.client.brokers.BrokerStatus;
import org.marketcetera.client.brokers.BrokersStatus;
import org.marketcetera.ors.brokers.Broker;
import org.marketcetera.ors.brokers.Messages;
import org.marketcetera.ors.brokers.SpringBroker;
import org.marketcetera.ors.brokers.SpringBrokers;
import org.marketcetera.ors.history.ReportHistoryServices;
import org.marketcetera.trade.BrokerID;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.quickfix.SpringSessionSettings;
import quickfix.SessionID;

@ClassVersion(value="$Id: Brokers.java 16154 2012-07-14 16:34:05Z colin $")
public class Brokers {
    private final SpringBrokers mSpringBrokers;
    private final List<Broker> mBrokers;
    private final Map<BrokerID, Broker> mBrokerIDMap;
    private final Map<SessionID, Broker> mSessionIDMap;

    public Brokers(SpringBrokers springBrokers, ReportHistoryServices historyServices) {
        this.mSpringBrokers = springBrokers;
        int capacity = this.getSpringBrokers().getBrokers().size();
        this.mBrokers = new ArrayList<Broker>(capacity);
        this.mBrokerIDMap = new HashMap<BrokerID, Broker>(capacity);
        this.mSessionIDMap = new HashMap<SessionID, Broker>(capacity);
        for (SpringBroker sb : this.getSpringBrokers().getBrokers()) {
            Broker b = new Broker(sb, historyServices);
            this.mBrokers.add(b);
            this.mBrokerIDMap.put(b.getBrokerID(), b);
            this.mSessionIDMap.put(b.getSessionID(), b);
        }
    }

    public SpringBrokers getSpringBrokers() {
        return this.mSpringBrokers;
    }

    public List<Broker> getBrokers() {
        return this.mBrokers;
    }

    public BrokersStatus getStatus() {
        ArrayList<BrokerStatus> list = new ArrayList<BrokerStatus>(this.getBrokers().size());
        for (Broker b : this.getBrokers()) {
            list.add(b.getStatus());
        }
        return new BrokersStatus(list);
    }

    public SpringSessionSettings getSettings() {
        return this.getSpringBrokers().getSettings();
    }

    public Broker getBroker(SessionID sessionID) {
        Broker b = this.mSessionIDMap.get(sessionID);
        if (b == null) {
            Messages.INVALID_SESSION_ID.error((Object)this, (Object)sessionID);
        }
        return b;
    }

    public Broker getBroker(BrokerID brokerID) {
        Broker b = this.mBrokerIDMap.get(brokerID);
        if (b == null) {
            Messages.INVALID_BROKER_ID.error((Object)this, (Object)brokerID);
        }
        return b;
    }
}

