/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors.brokers;

import java.util.ArrayList;
import java.util.List;
import org.marketcetera.ors.brokers.Brokers;
import org.marketcetera.ors.brokers.SelectorEntry;
import org.marketcetera.ors.brokers.SpringSelector;
import org.marketcetera.ors.brokers.SpringSelectorEntry;
import org.marketcetera.trade.BrokerID;
import org.marketcetera.trade.Order;
import org.marketcetera.trade.SecurityType;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: Selector.java 16154 2012-07-14 16:34:05Z colin $")
public class Selector {
    private final Brokers mBrokers;
    private final SpringSelector mSpringSelector;
    private List<SelectorEntry> mEntries;
    private final BrokerID mDefaultBrokerID;

    public Selector(Brokers brokers, SpringSelector springSelector) {
        this.mBrokers = brokers;
        this.mSpringSelector = springSelector;
        if (this.getSpringSelector().getEntries() != null) {
            this.mEntries = new ArrayList<SelectorEntry>(this.getSpringSelector().getEntries().size());
            for (SpringSelectorEntry se : this.getSpringSelector().getEntries()) {
                this.mEntries.add(new SelectorEntry(se));
            }
        }
        this.mDefaultBrokerID = this.getSpringSelector().getDefaultBroker() != null ? new BrokerID(this.getSpringSelector().getDefaultBroker().getId()) : null;
    }

    private Brokers getBrokers() {
        return this.mBrokers;
    }

    public SpringSelector getSpringSelector() {
        return this.mSpringSelector;
    }

    public List<SelectorEntry> getEntries() {
        return this.mEntries;
    }

    public BrokerID getDefaultBroker() {
        return this.mDefaultBrokerID;
    }

    public BrokerID chooseBroker(Order order) {
        BrokerID bID = order.getBrokerID();
        if (bID != null) {
            return bID;
        }
        SecurityType orderType = order.getSecurityType();
        if (orderType != null && orderType != SecurityType.Unknown && this.getEntries() != null) {
            for (SelectorEntry e : this.getEntries()) {
                if (e.getSkipIfUnavailable() && !this.getBrokers().getBroker(e.getBroker()).getLoggedOn() || !e.getTargetType().equals((Object)orderType)) continue;
                return e.getBroker();
            }
        }
        if (this.getDefaultBroker() != null) {
            return this.getDefaultBroker();
        }
        return null;
    }
}

