/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors.brokers;

import java.io.Serializable;
import org.marketcetera.ors.brokers.Messages;
import org.marketcetera.ors.brokers.SpringSelectorEntry;
import org.marketcetera.trade.BrokerID;
import org.marketcetera.trade.SecurityType;
import org.marketcetera.util.except.I18NRuntimeException;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: SelectorEntry.java 16154 2012-07-14 16:34:05Z colin $")
public class SelectorEntry {
    private final SpringSelectorEntry mSpringSelectorEntry;
    private final SecurityType mTargetType;
    private final BrokerID mBrokerID;

    public SelectorEntry(SpringSelectorEntry springSelectorEntry) {
        this.mSpringSelectorEntry = springSelectorEntry;
        this.mTargetType = SecurityType.getInstanceForFIXValue((String)this.getSpringSelectorEntry().getTargetType());
        if (SecurityType.Unknown.equals((Object)this.getTargetType())) {
            throw new I18NRuntimeException((I18NBoundMessage)new I18NBoundMessage1P(Messages.UNKNOWN_SECURITY_TYPE, (Serializable)((Object)this.getSpringSelectorEntry().getTargetType())));
        }
        this.mBrokerID = new BrokerID(this.getSpringSelectorEntry().getBroker().getId());
    }

    public SpringSelectorEntry getSpringSelectorEntry() {
        return this.mSpringSelectorEntry;
    }

    public SecurityType getTargetType() {
        return this.mTargetType;
    }

    public BrokerID getBroker() {
        return this.mBrokerID;
    }

    public boolean getSkipIfUnavailable() {
        return this.getSpringSelectorEntry().getSkipIfUnavailable();
    }
}

