/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors.brokers;

import java.util.ArrayList;
import java.util.List;
import org.marketcetera.ors.brokers.Messages;
import org.marketcetera.ors.brokers.SpringBroker;
import org.marketcetera.util.except.I18NException;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.quickfix.SpringSessionDescriptor;
import org.marketcetera.util.quickfix.SpringSessionSettings;
import org.springframework.beans.factory.InitializingBean;

@ClassVersion(value="$Id: SpringBrokers.java 16154 2012-07-14 16:34:05Z colin $")
public class SpringBrokers
implements InitializingBean {
    private SpringSessionSettings mSessionSettings;
    private List<SpringBroker> mBrokers;

    public void setSettings(SpringSessionSettings sessionSettings) {
        this.mSessionSettings = sessionSettings;
    }

    public SpringSessionSettings getSettings() {
        return this.mSessionSettings;
    }

    public void setBrokers(List<SpringBroker> brokers) {
        this.mBrokers = brokers;
    }

    public List<SpringBroker> getBrokers() {
        return this.mBrokers;
    }

    public void afterPropertiesSet() throws I18NException {
        if (this.getSettings() == null) {
            throw new I18NException((I18NBoundMessage)Messages.NO_SETTINGS);
        }
        if (this.getBrokers() == null) {
            throw new I18NException((I18NBoundMessage)Messages.NO_BROKERS);
        }
        ArrayList<SpringSessionDescriptor> list = new ArrayList<SpringSessionDescriptor>(this.getBrokers().size());
        for (SpringBroker b : this.getBrokers()) {
            list.add(b.getDescriptor());
        }
        this.getSettings().setDescriptors(list);
    }
}

