/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors.config;

import javax.jms.ConnectionFactory;
import org.marketcetera.core.IDFactory;
import org.marketcetera.ors.OrderInfoCache;
import org.marketcetera.ors.brokers.SpringBrokers;
import org.marketcetera.ors.brokers.SpringSelector;
import org.marketcetera.ors.config.Messages;
import org.marketcetera.ors.filters.MessageFilter;
import org.marketcetera.ors.filters.MessageFilterNoop;
import org.marketcetera.ors.filters.OrderFilter;
import org.marketcetera.ors.filters.OrderFilterNoop;
import org.marketcetera.ors.history.ReportHistoryServices;
import org.marketcetera.util.except.I18NException;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.misc.ClassVersion;
import org.springframework.beans.factory.InitializingBean;

@ClassVersion(value="$Id: SpringConfig.java 16154 2012-07-14 16:34:05Z colin $")
public class SpringConfig
implements InitializingBean {
    private static SpringConfig sSingleton;
    private SpringBrokers mBrokers;
    private SpringSelector mSelector;
    private MessageFilter mSupportedMessages;
    private OrderFilter mAllowedOrders;
    private String mServerHost;
    private int mServerPort;
    private long mServerSessionLife;
    private ConnectionFactory mIncomingCF;
    private ConnectionFactory mOutgoingCF;
    private IDFactory mIDFactory;
    private ReportHistoryServices mReportHistoryServices;
    private OrderInfoCache mOrderInfoCache;

    public SpringConfig() {
        this.mSupportedMessages = new MessageFilterNoop();
        this.mAllowedOrders = new OrderFilterNoop();
        this.mServerHost = "localhost";
        this.mServerPort = 9000;
        this.mServerSessionLife = -1L;
        SpringConfig.setSingleton(this);
    }

    public SpringConfig(SpringBrokers brokers, SpringSelector selector, MessageFilter supportedMessages, OrderFilter allowedOrders, String serverHost, int serverPort, long serverSessionLife, ConnectionFactory incomingCF, ConnectionFactory outgoingCF, IDFactory idFactory, ReportHistoryServices reportHistoryServices, OrderInfoCache orderInfoCache) throws I18NException {
        this.setBrokers(brokers);
        this.setSelector(selector);
        this.setSupportedMessages(supportedMessages);
        this.setAllowedOrders(allowedOrders);
        this.setServerHost(serverHost);
        this.setServerPort(serverPort);
        this.setServerSessionLife(serverSessionLife);
        this.setIncomingConnectionFactory(incomingCF);
        this.setOutgoingConnectionFactory(outgoingCF);
        this.setIDFactory(idFactory);
        this.setReportHistoryServices(reportHistoryServices);
        this.setOrderInfoCache(orderInfoCache);
        this.afterPropertiesSet();
        SpringConfig.setSingleton(this);
    }

    public static void setSingleton(SpringConfig singleton) {
        sSingleton = singleton;
    }

    public static SpringConfig getSingleton() {
        return sSingleton;
    }

    public void setBrokers(SpringBrokers brokers) {
        this.mBrokers = brokers;
    }

    public SpringBrokers getBrokers() {
        return this.mBrokers;
    }

    public void setSelector(SpringSelector selector) {
        this.mSelector = selector;
    }

    public SpringSelector getSelector() {
        return this.mSelector;
    }

    public void setSupportedMessages(MessageFilter supportedMessages) {
        this.mSupportedMessages = supportedMessages;
    }

    public MessageFilter getSupportedMessages() {
        return this.mSupportedMessages;
    }

    public void setAllowedOrders(OrderFilter allowedOrders) {
        this.mAllowedOrders = allowedOrders;
    }

    public OrderFilter getAllowedOrders() {
        return this.mAllowedOrders;
    }

    public void setServerHost(String serverHost) {
        this.mServerHost = serverHost;
    }

    public String getServerHost() {
        return this.mServerHost;
    }

    public void setServerPort(int serverPort) {
        this.mServerPort = serverPort;
    }

    public int getServerPort() {
        return this.mServerPort;
    }

    public void setServerSessionLife(long serverSessionLife) {
        this.mServerSessionLife = serverSessionLife;
    }

    public long getServerSessionLife() {
        return this.mServerSessionLife;
    }

    public void setIncomingConnectionFactory(ConnectionFactory incomingCF) {
        this.mIncomingCF = incomingCF;
    }

    public ConnectionFactory getIncomingConnectionFactory() {
        return this.mIncomingCF;
    }

    public void setOutgoingConnectionFactory(ConnectionFactory outgoingCF) {
        this.mOutgoingCF = outgoingCF;
    }

    public ConnectionFactory getOutgoingConnectionFactory() {
        return this.mOutgoingCF;
    }

    public void setIDFactory(IDFactory idFactory) {
        this.mIDFactory = idFactory;
    }

    public IDFactory getIDFactory() {
        return this.mIDFactory;
    }

    public void setReportHistoryServices(ReportHistoryServices reportHistoryServices) {
        this.mReportHistoryServices = reportHistoryServices;
    }

    public ReportHistoryServices getReportHistoryServices() {
        return this.mReportHistoryServices;
    }

    public void setOrderInfoCache(OrderInfoCache orderInfoCache) {
        this.mOrderInfoCache = orderInfoCache;
    }

    public OrderInfoCache getOrderInfoCache() {
        return this.mOrderInfoCache;
    }

    public void afterPropertiesSet() throws I18NException {
        if (this.getBrokers() == null) {
            throw new I18NException((I18NBoundMessage)Messages.NO_BROKERS);
        }
        if (this.getSelector() == null) {
            throw new I18NException((I18NBoundMessage)Messages.NO_SELECTOR);
        }
        if (this.getIncomingConnectionFactory() == null) {
            throw new I18NException((I18NBoundMessage)Messages.NO_INCOMING_CONNECTION_FACTORY);
        }
        if (this.getOutgoingConnectionFactory() == null) {
            throw new I18NException((I18NBoundMessage)Messages.NO_OUTGOING_CONNECTION_FACTORY);
        }
        if (this.getIDFactory() == null) {
            throw new I18NException((I18NBoundMessage)Messages.NO_ID_FACTORY);
        }
        if (this.getReportHistoryServices() == null) {
            throw new I18NException((I18NBoundMessage)Messages.NO_REPORT_HISTORY_SERVICES);
        }
        if (this.getOrderInfoCache() == null) {
            throw new I18NException((I18NBoundMessage)Messages.NO_ORDER_INFO_CACHE);
        }
    }
}

