/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors.filters;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.marketcetera.core.CoreException;
import org.marketcetera.ors.filters.Messages;
import org.marketcetera.ors.history.ReportHistoryServices;
import org.marketcetera.quickfix.messagefactory.FIXMessageAugmentor;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.misc.ClassVersion;
import quickfix.FieldMap;
import quickfix.FieldNotFound;
import quickfix.Message;
import quickfix.StringField;

@ClassVersion(value="$Id: DefaultMessageModifier.java 16154 2012-07-14 16:34:05Z colin $")
public class DefaultMessageModifier
implements org.marketcetera.ors.filters.MessageModifier {
    private static final String ADMIN_MODIFIER_KEY = "ADMIN";
    private static final String APP_MODIFIER_KEY = "APP";
    private static final String GLOBAL_MODIFIER_KEY = "*";
    private static final String PARSER_REGEX = "([0-9]+)(\\((\\*|[0-9a-z]+|admin|app)\\))?";
    private static final Pattern DEFAULT_FIELDS_PATTERN = Pattern.compile("([0-9]+)(\\((\\*|[0-9a-z]+|admin|app)\\))?", 2);
    private Map<String, MessageModifier> messageModifiers = new HashMap<String, MessageModifier>();

    public void setMsgFields(Map<String, String> fields) throws CoreException {
        this.setFieldsHelper(fields, MessageFieldType.MESSAGE);
    }

    public void setHeaderFields(Map<String, String> fields) throws CoreException {
        this.setFieldsHelper(fields, MessageFieldType.HEADER);
    }

    public void setTrailerFields(Map<String, String> fields) throws CoreException {
        this.setFieldsHelper(fields, MessageFieldType.TRAILER);
    }

    @Override
    public boolean modifyMessage(Message message, ReportHistoryServices historyServices, FIXMessageAugmentor augmentor) throws CoreException {
        MessageModifier mod;
        String msgType = null;
        boolean modified = false;
        try {
            msgType = message.getHeader().getString(35);
        }
        catch (FieldNotFound fieldNotFound) {
            // empty catch block
        }
        if (msgType != null) {
            mod = this.messageModifiers.get(msgType = msgType.toUpperCase());
            if (mod != null) {
                boolean bl = modified = mod.modifyOrder(message) || modified;
            }
            if (message.isAdmin()) {
                mod = this.messageModifiers.get(ADMIN_MODIFIER_KEY);
                if (mod != null) {
                    modified = mod.modifyOrder(message) || modified;
                }
            } else {
                mod = this.messageModifiers.get(APP_MODIFIER_KEY);
                if (mod != null) {
                    boolean bl = modified = mod.modifyOrder(message) || modified;
                }
            }
        }
        if ((mod = this.messageModifiers.get(GLOBAL_MODIFIER_KEY)) != null) {
            modified = mod.modifyOrder(message) || modified;
        }
        return modified;
    }

    public void addDefaultField(int field, Object defaultValue, MessageFieldType fieldType) {
        this.addDefaultField(field, defaultValue, fieldType, null);
    }

    public void addDefaultField(int field, Object defaultValue, MessageFieldType fieldType, String predicate) {
        MessageModifier mod;
        if (predicate == null) {
            predicate = GLOBAL_MODIFIER_KEY;
        }
        if ((mod = this.messageModifiers.get(predicate = predicate.toUpperCase())) == null) {
            mod = new MessageModifier();
            this.messageModifiers.put(predicate, mod);
        }
        mod.addDefaultField(field, defaultValue, fieldType);
    }

    protected void setFieldsHelper(Map<String, String> fields, MessageFieldType fieldType) throws CoreException {
        Set<String> keys = fields.keySet();
        for (String oneKey : keys) {
            String value = fields.get(oneKey);
            Matcher defaultFieldsMatcher = DEFAULT_FIELDS_PATTERN.matcher(oneKey);
            String predicate = null;
            if (defaultFieldsMatcher.matches()) {
                int groupCount = defaultFieldsMatcher.groupCount();
                String fieldIDString = defaultFieldsMatcher.group(1);
                int fieldID = Integer.parseInt(fieldIDString);
                if (groupCount == 3) {
                    predicate = defaultFieldsMatcher.group(3);
                }
                this.addDefaultField(fieldID, value, fieldType, predicate);
                continue;
            }
            throw new CoreException((I18NBoundMessage)new I18NBoundMessage1P(Messages.ORDER_MODIFIER_WRONG_FIELD_FORMAT, (Serializable)((Object)oneKey)));
        }
    }

    public static enum MessageFieldType {
        MESSAGE,
        HEADER,
        TRAILER;

    }

    class MessageModifier {
        private Map<Integer, Object> msgFields = new HashMap<Integer, Object>();
        private Map<Integer, Object> headerFields = new HashMap<Integer, Object>();
        private Map<Integer, Object> trailerFields = new HashMap<Integer, Object>();

        public boolean modifyOrder(Message order) {
            boolean modified = false;
            for (Integer field : this.msgFields.keySet()) {
                modified = this.modifyOneField((FieldMap)order, field, this.msgFields.get(field)) || modified;
            }
            for (Integer field : this.headerFields.keySet()) {
                modified = this.modifyOneField((FieldMap)order.getHeader(), field, this.headerFields.get(field)) || modified;
            }
            for (Integer field : this.trailerFields.keySet()) {
                modified = this.modifyOneField((FieldMap)order.getTrailer(), field, this.trailerFields.get(field)) || modified;
            }
            return modified;
        }

        public void addDefaultField(int field, Object defaultValue, MessageFieldType fieldType) {
            switch (fieldType) {
                case MESSAGE: {
                    this.msgFields.put(field, defaultValue);
                    break;
                }
                case HEADER: {
                    this.headerFields.put(field, defaultValue);
                    break;
                }
                case TRAILER: {
                    this.trailerFields.put(field, defaultValue);
                }
            }
        }

        protected boolean modifyOneField(FieldMap order, int field, Object defaultValue) {
            try {
                order.getField(new StringField(field));
                return false;
            }
            catch (FieldNotFound ex) {
                order.setField(new StringField(field, defaultValue.toString()));
                return true;
            }
        }
    }
}

