/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors.filters;

import org.marketcetera.core.CoreException;
import org.marketcetera.ors.filters.MessageModifier;
import org.marketcetera.ors.history.ReportHistoryServices;
import org.marketcetera.quickfix.messagefactory.FIXMessageAugmentor;
import org.marketcetera.util.misc.ClassVersion;
import quickfix.FieldNotFound;
import quickfix.Message;
import quickfix.StringField;

@ClassVersion(value="$Id: FieldDuplicatorMessageModifier.java 16154 2012-07-14 16:34:05Z colin $")
public class FieldDuplicatorMessageModifier
implements MessageModifier {
    private int destField;
    private int sourceField;

    public FieldDuplicatorMessageModifier(int sourceField, int destField) {
        this.sourceField = sourceField;
        this.destField = destField;
    }

    @Override
    public boolean modifyMessage(Message message, ReportHistoryServices historyServices, FIXMessageAugmentor augmentor) throws CoreException {
        try {
            if (message.isSetField(this.sourceField)) {
                String value = message.getString(this.sourceField);
                message.setField(new StringField(this.destField, value));
                return true;
            }
            return false;
        }
        catch (FieldNotFound fieldNotFound) {
            throw new CoreException((Throwable)fieldNotFound);
        }
    }
}

