/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors.filters;

import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.marketcetera.core.CoreException;
import org.marketcetera.ors.filters.MessageModifier;
import org.marketcetera.ors.filters.Messages;
import org.marketcetera.ors.history.ReportHistoryServices;
import org.marketcetera.quickfix.messagefactory.FIXMessageAugmentor;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.marketcetera.util.misc.ClassVersion;
import quickfix.FieldNotFound;
import quickfix.Message;
import quickfix.StringField;
import quickfix.field.MsgType;

@ClassVersion(value="$Id: FieldRemoverMessageModifier.java 16154 2012-07-14 16:34:05Z colin $")
public class FieldRemoverMessageModifier
implements MessageModifier {
    private final String msgType;
    private final int field;
    private static final String allMessageIndicator = "*";
    private static final Pattern messageDescriptor = Pattern.compile("[0-9]{1,5}\\((\\*?|[A-Z]{1,3})\\)");

    public FieldRemoverMessageModifier() {
        this(null);
    }

    public FieldRemoverMessageModifier(String inField) {
        inField = StringUtils.trimToNull((String)inField);
        if (inField == null) {
            this.field = -1;
            this.msgType = null;
        } else {
            Validate.isTrue((boolean)messageDescriptor.matcher(inField).matches(), (String)Messages.NON_CONFORMING_FIELD_SPECIFICATION.getText());
            int splitIndex = inField.indexOf(40);
            this.field = Integer.parseInt(inField.substring(0, splitIndex));
            this.msgType = inField.substring(splitIndex + 1, inField.length() - 1);
        }
    }

    @Override
    public boolean modifyMessage(Message inMessage, ReportHistoryServices inHistoryServices, FIXMessageAugmentor inAugmentor) throws CoreException {
        boolean isModified = false;
        if (this.msgType != null && inMessage.isSetField(this.field)) {
            SLF4JLoggerProxy.debug(FieldRemoverMessageModifier.class, (String)"Message contains field {}", (Object[])new Object[]{this.field});
            if (this.msgType.equals(allMessageIndicator)) {
                SLF4JLoggerProxy.debug(FieldRemoverMessageModifier.class, (String)"Message type specifier is 'all messages', removing field");
                inMessage.removeField(this.field);
                isModified = true;
            } else {
                MsgType thisMessageType = new MsgType();
                try {
                    inMessage.getHeader().getField((StringField)thisMessageType);
                }
                catch (FieldNotFound e) {
                    throw new CoreException((Throwable)e);
                }
                if (thisMessageType.valueEquals(this.msgType)) {
                    SLF4JLoggerProxy.debug(FieldRemoverMessageModifier.class, (String)"Message type specified matches message, removing field");
                    inMessage.removeField(this.field);
                    isModified = true;
                }
            }
        }
        if (isModified) {
            SLF4JLoggerProxy.debug(FieldRemoverMessageModifier.class, (String)"Modified message is {}", (Object[])new Object[]{inMessage});
        }
        return isModified;
    }

    public String getMsgType() {
        return this.msgType;
    }

    public int getField() {
        return this.field;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("MsgType", (Object)this.msgType).append("Field", this.field).toString();
    }
}

