/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors.filters;

import java.util.LinkedList;
import java.util.List;
import org.marketcetera.ors.filters.MessageModifier;
import org.marketcetera.ors.filters.TransactionTimeInsertMessageModifier;
import org.marketcetera.ors.history.ReportHistoryServices;
import org.marketcetera.ors.info.RequestInfo;
import org.marketcetera.quickfix.FIXMessageFactory;
import org.marketcetera.quickfix.messagefactory.FIXMessageAugmentor;
import org.marketcetera.util.except.I18NException;
import org.marketcetera.util.misc.ClassVersion;
import quickfix.Message;

@ClassVersion(value="$Id: MessageModifierManager.java 16154 2012-07-14 16:34:05Z colin $")
public class MessageModifierManager {
    private List<MessageModifier> messageModifiers;

    public void setMessageModifiers(List<MessageModifier> mods) {
        this.messageModifiers = new LinkedList<MessageModifier>();
        for (MessageModifier mod : mods) {
            this.messageModifiers.add(mod);
        }
        this.messageModifiers.add(new TransactionTimeInsertMessageModifier());
    }

    public void modifyMessage(RequestInfo info) throws I18NException {
        Message inMessage = (Message)info.getValue("CURRENT_MESSAGE");
        ReportHistoryServices historyServices = (ReportHistoryServices)info.getSessionInfo().getSystemInfo().getValue("HISTORY_SERVICES");
        FIXMessageAugmentor augmentor = ((FIXMessageFactory)info.getValue("FIX_MESSAGE_FACTORY")).getMsgAugmentor();
        for (MessageModifier oneModifier : this.messageModifiers) {
            oneModifier.modifyMessage(inMessage, historyServices, augmentor);
        }
    }
}

