/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors.filters;

import java.util.HashMap;
import java.util.Map;
import org.marketcetera.core.CoreException;
import org.marketcetera.ors.filters.Messages;
import org.marketcetera.quickfix.MarketceteraFIXException;
import org.marketcetera.quickfix.messagefactory.FIXMessageAugmentor;
import org.marketcetera.util.misc.ClassVersion;
import quickfix.FieldNotFound;
import quickfix.Message;
import quickfix.StringField;
import quickfix.field.DeliverToCompID;
import quickfix.field.ExDestination;
import quickfix.field.MsgType;
import quickfix.field.Symbol;
import quickfix.field.SymbolSfx;
import quickfix.field.TargetSubID;

@ClassVersion(value="$Id: MessageRouteManager.java 16154 2012-07-14 16:34:05Z colin $")
public class MessageRouteManager {
    public static final String FIELD_57_METHOD = "field:57";
    public static final String FIELD_100_METHOD = "field:100";
    public static final String FIELD_128_METHOD = "field:128";
    private Map<String, String> mRoutes = new HashMap<String, String>();
    private String routeMethod;
    private boolean separateSuffix;

    public void setRoutes(Map<String, String> routeMap) {
        for (String suffix : routeMap.keySet()) {
            this.addOneRoute(suffix, routeMap.get(suffix));
        }
    }

    public void addOneRoute(String key, String route) {
        if (route != null && !"".equals(route)) {
            this.mRoutes.put(key, route);
        }
    }

    public void setRouteMethod(String inMethod) {
        this.routeMethod = inMethod;
        if (!(this.routeMethod == null || FIELD_57_METHOD.equals(this.routeMethod) || FIELD_100_METHOD.equals(this.routeMethod) || FIELD_128_METHOD.equals(this.routeMethod))) {
            throw new IllegalArgumentException(Messages.ERROR_UNRECOGNIZED_ROUTE.getText((Object)this.routeMethod));
        }
    }

    public void setSeparateSuffix(boolean inSeparateSuffix) {
        this.separateSuffix = inSeparateSuffix;
    }

    public boolean isSeparateSuffix() {
        return this.separateSuffix;
    }

    protected Map<String, String> getRoutesMap() {
        return this.mRoutes;
    }

    public boolean modifyMessage(Message anOrder, FIXMessageAugmentor augmentor) throws CoreException {
        try {
            boolean isModified = false;
            Symbol symbolField = new Symbol();
            anOrder.getField((StringField)symbolField);
            String symbolString = symbolField.getValue();
            if (symbolString != null) {
                String securityType;
                MsgType msgTypeField = new MsgType();
                anOrder.getHeader().getField((StringField)msgTypeField);
                if (this.routeMethod != null && ("D".equals(msgTypeField.getValue()) || "G".equals(msgTypeField.getValue()) || "F".equals(msgTypeField.getValue()))) {
                    int periodPosition = symbolString.lastIndexOf(46);
                    if (periodPosition > 0) {
                        String routeKey = symbolString.substring(periodPosition + 1);
                        String rootSymbol = symbolString.substring(0, periodPosition);
                        String mappedRoute = this.mRoutes.get(routeKey);
                        if (mappedRoute != null) {
                            if (FIELD_57_METHOD.equals(this.routeMethod)) {
                                anOrder.getHeader().setField((StringField)new TargetSubID(mappedRoute));
                            } else if (FIELD_100_METHOD.equals(this.routeMethod)) {
                                anOrder.setField((StringField)new ExDestination(mappedRoute));
                            } else if (FIELD_128_METHOD.equals(this.routeMethod)) {
                                anOrder.getHeader().setField((StringField)new DeliverToCompID(mappedRoute));
                            }
                            anOrder.setField((StringField)new Symbol(rootSymbol));
                        }
                    }
                    isModified = true;
                }
                String string = securityType = anOrder.isSetField(167) ? anOrder.getString(167) : null;
                if (this.isSeparateSuffix() && !"FOR".equals(securityType)) {
                    int suffixEnd = symbolString.length();
                    int slashPosition = 0;
                    slashPosition = symbolString.lastIndexOf(47);
                    if (slashPosition > 0) {
                        int periodPosition = symbolString.lastIndexOf(46);
                        if (periodPosition > 0) {
                            suffixEnd = periodPosition;
                        }
                        if (slashPosition + 1 == suffixEnd) {
                            anOrder.setField((StringField)new Symbol(symbolString.substring(0, slashPosition + 1)));
                        } else {
                            anOrder.setField((StringField)new Symbol(symbolString.substring(0, slashPosition)));
                            anOrder.setField((StringField)new SymbolSfx(symbolString.substring(slashPosition + 1, suffixEnd)));
                        }
                        isModified = true;
                    }
                }
            }
            return isModified;
        }
        catch (FieldNotFound fnfEx) {
            throw MarketceteraFIXException.createFieldNotFoundException((FieldNotFound)fnfEx, (Message)anOrder);
        }
        catch (Exception ex) {
            throw new CoreException((Throwable)ex);
        }
    }
}

